/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.ForgeDirection;
import openblocks.OpenBlocks;
import openblocks.common.tileentity.OpenTileEntity;

public class TileEntityElevator
extends OpenTileEntity {
    private int lowerLevel = 0;
    private int upperLevel = 0;
    private static final float DIRECTION_MAGNITUDE = 0.95f;
    private HashMap cooldown = new HashMap();

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            Iterator cooldownIter = this.cooldown.entrySet().iterator();
            while (cooldownIter.hasNext()) {
                Map.Entry entry = cooldownIter.next();
                int less = (Integer)entry.getValue() - 1;
                entry.setValue(less);
                if (less != 0) continue;
                cooldownIter.remove();
            }
            List playersInRange = this.field_70331_k.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72332_a().func_72299_a((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)(this.field_70329_l + 1), (double)(this.field_70330_m + 3), (double)(this.field_70327_n + 1)));
            if (playersInRange.size() > 0) {
                ForgeDirection teleportDirection = ForgeDirection.UNKNOWN;
                for (EntityPlayer player : playersInRange) {
                    if (this.cooldown.containsKey(player.field_71092_bJ) || player.field_71075_bZ.field_75098_d && player.field_71075_bZ.field_75100_b) continue;
                    if (player.func_70093_af() && player.field_70154_o == null && (!OpenBlocks.Config.elevatorBlockMustFaceDirection || player.func_70040_Z().field_72448_b < (double)-0.95f)) {
                        teleportDirection = ForgeDirection.DOWN;
                    } else if (player.field_70163_u > (double)this.field_70330_m + 1.2 && player.field_70154_o == null && (!OpenBlocks.Config.elevatorBlockMustFaceDirection || player.func_70040_Z().field_72448_b > (double)0.95f)) {
                        teleportDirection = ForgeDirection.UP;
                    }
                    if (teleportDirection == ForgeDirection.UNKNOWN) continue;
                    try {
                        int level = this.findLevel(teleportDirection);
                        if (level == 0) continue;
                        player.func_70634_a(player.field_70165_t, (double)level + 1.1, player.field_70161_v);
                        this.field_70331_k.func_72956_a((Entity)player, "openblocks.teleport", 1.0f, 1.0f);
                        this.addPlayerCooldownToTargetAndNeighbours(player, this.field_70329_l, level, this.field_70327_n);
                    }
                    catch (Exception ex) {}
                }
            }
            this.lowerLevel = 0;
            this.upperLevel = 0;
        }
    }

    private void addPlayerCooldownToTargetAndNeighbours(EntityPlayer player, int xCoord, int level, int zCoord) {
        for (int x = xCoord - 1; x <= xCoord + 1; ++x) {
            for (int z = zCoord - 1; z <= zCoord + 1; ++z) {
                TileEntity targetTile = this.field_70331_k.func_72796_p(x, level, z);
                if (!(targetTile instanceof TileEntityElevator)) continue;
                ((TileEntityElevator)targetTile).addPlayerCooldown(player);
            }
        }
    }

    private void addPlayerCooldown(EntityPlayer player) {
        this.cooldown.put(player.field_71092_bJ, 6);
    }

    private boolean isPassable(int x, int y, int z, boolean canStandHere) {
        int blockId = this.field_70331_k.func_72798_a(x, y, z);
        if (canStandHere) {
            return this.field_70331_k.func_72799_c(x, y, z) || Block.field_71973_m[blockId] == null || OpenBlocks.Config.irregularBlocksArePassable && Block.field_71973_m[blockId].func_71872_e(this.field_70331_k, x, y, z) == null;
        }
        return blockId != 0 && OpenBlocks.Config.elevatorMaxBlockPassCount != -1 && (!OpenBlocks.Config.elevatorIgnoreHalfBlocks || Block.func_71932_i((int)blockId));
    }

    private int findLevel(ForgeDirection direction) throws Exception {
        if (direction != ForgeDirection.UP && direction != ForgeDirection.DOWN) {
            throw new Exception("Must be either up or down... for now");
        }
        int blocksInTheWay = 0;
        for (int y = 2; y < OpenBlocks.Config.elevatorTravelDistance; ++y) {
            int yPos = this.field_70330_m + y * direction.offsetY;
            if (this.field_70331_k.func_72899_e(this.field_70329_l, yPos, this.field_70327_n)) {
                int blockId = this.field_70331_k.func_72798_a(this.field_70329_l, yPos, this.field_70327_n);
                if (blockId == OpenBlocks.Config.blockElevatorId) {
                    TileEntity otherBlock = this.field_70331_k.func_72796_p(this.field_70329_l, yPos, this.field_70327_n);
                    if (!(otherBlock instanceof TileEntityElevator) || ((TileEntityElevator)otherBlock).func_70322_n() != this.func_70322_n()) continue;
                    if (this.isPassable(this.field_70329_l, yPos + 1, this.field_70327_n, true) && this.isPassable(this.field_70329_l, yPos + 2, this.field_70327_n, true)) {
                        return yPos;
                    }
                    return 0;
                }
                if (!this.isPassable(this.field_70329_l, yPos, this.field_70327_n, false) || ++blocksInTheWay <= OpenBlocks.Config.elevatorMaxBlockPassCount) continue;
                return 0;
            }
            return 0;
        }
        return 0;
    }

    public boolean onActivated(EntityPlayer player) {
        Item item;
        ItemStack stack = player.func_70694_bm();
        if (stack != null && (item = stack.func_77973_b()) instanceof ItemDye) {
            int dmg = stack.func_77960_j();
            if (dmg == 15) {
                dmg = 0;
            } else if (dmg == 0) {
                dmg = 15;
            }
            this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, dmg, 3);
            this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            return true;
        }
        return false;
    }

    @Override
    protected void initialize() {
    }
}

