/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;
import openblocks.common.api.IAwareTile;
import openblocks.common.api.ISurfaceAttachment;
import openblocks.common.tileentity.NetworkedTileEntity;
import openblocks.sync.ISyncHandler;
import openblocks.sync.SyncableFlags;
import openblocks.sync.SyncableInt;
import openblocks.utils.BlockUtils;

public class TileEntityBearTrap
extends NetworkedTileEntity
implements ISyncHandler,
IAwareTile,
ISurfaceAttachment {
    private boolean hasBeenSnapped = false;
    private SyncableFlags flags = new SyncableFlags();
    private SyncableInt trappedEntityId = new SyncableInt();

    public TileEntityBearTrap() {
        this.addSyncedObject(Keys.flags, this.flags);
        this.addSyncedObject(Keys.trappedEntityId, this.trappedEntityId);
        this.flags.on(Flags.isShut);
    }

    @Override
    protected void initialize() {
    }

    @Override
    public void func_70316_g() {
        Entity trappedEntity;
        super.func_70316_g();
        if (this.trappedEntityId.getValue() != 0 && (trappedEntity = this.field_70331_k.func_73045_a(this.trappedEntityId.getValue())) != null) {
            trappedEntity.field_82151_R = 0.0f;
            trappedEntity.field_70140_Q = 0.0f;
            trappedEntity.field_70165_t = 0.5 + (double)this.field_70329_l;
            trappedEntity.field_70161_v = 0.5 + (double)this.field_70327_n;
            trappedEntity.field_70163_u = this.field_70330_m;
            trappedEntity.field_70169_q = 0.5 + (double)this.field_70329_l;
            trappedEntity.field_70166_s = 0.5 + (double)this.field_70327_n;
            trappedEntity.field_70167_r = this.field_70330_m;
            trappedEntity.field_70142_S = 0.5 + (double)this.field_70329_l;
            trappedEntity.field_70136_U = 0.5 + (double)this.field_70327_n;
            trappedEntity.field_70137_T = this.field_70330_m;
            trappedEntity.field_70159_w = 0.0;
            trappedEntity.field_70181_x = 0.0;
            trappedEntity.field_70179_y = 0.0;
        }
        this.sync(2);
    }

    public void onEntityCollided(Entity entity) {
        if (!this.field_70331_k.field_72995_K && !this.flags.get(Flags.isShut) && this.tickSinceOpened() > 20 && entity instanceof EntityCreature) {
            this.trappedEntityId.setValue(entity.field_70157_k);
            entity.field_70170_p.func_72956_a(entity, this.field_70331_k.field_73012_v.nextBoolean() ? "openblocks.beartrapclose" : "openblocks.beartrapcloseb", 0.5f, 1.0f);
            this.flags.set(Flags.isShut, true);
        }
    }

    public boolean isShut() {
        return this.flags.get(Flags.isShut);
    }

    @Override
    public void onBlockBroken() {
    }

    @Override
    public void onBlockAdded() {
    }

    public int tickSinceOpened() {
        return this.flags.ticksSinceChange(Flags.isShut);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!this.field_70331_k.field_72995_K && this.flags.get(Flags.isShut)) {
            this.flags.off(Flags.isShut);
            this.trappedEntityId.setValue(0);
            player.field_70170_p.func_72956_a((Entity)player, "openblocks.beartrapopen", 0.5f, 1.0f);
        }
        return true;
    }

    @Override
    public void onNeighbourChanged(int blockId) {
    }

    @Override
    public void onBlockPlacedBy(EntityPlayer player, ForgeDirection side, ItemStack stack, float hitX, float hitY, float hitZ) {
        this.setRotation(BlockUtils.get2dOrientation((EntityLiving)player));
        this.sync();
    }

    @Override
    public boolean onBlockEventReceived(int eventId, int eventParam) {
        return false;
    }

    public void setOpen() {
        this.flags.set(Flags.isShut, false);
    }

    @Override
    public void onSynced(List changes) {
        if (changes.contains(this.flags)) {
            this.hasBeenSnapped = true;
        }
    }

    @Override
    public ForgeDirection getSurfaceDirection() {
        return ForgeDirection.DOWN;
    }

    public static enum Flags {
        isShut;

    }

    public static enum Keys {
        flags,
        trappedEntityId;

    }
}

