/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openblocks.OpenBlocks;
import openblocks.common.block.OpenBlock;

public abstract class OpenTileEntity
extends TileEntity {
    private boolean initialized = false;
    private boolean isActive = false;
    private boolean isLoaded = false;
    private ForgeDirection rotation = ForgeDirection.UNKNOWN;
    private boolean flag1 = false;
    private boolean flag2 = false;

    public ForgeDirection getRotation() {
        int ordinal = (this.getMetadata() & 3) + 2;
        ForgeDirection direction = ForgeDirection.getOrientation((int)ordinal);
        return direction;
    }

    public void setRotation(ForgeDirection rot) {
        if (rot == ForgeDirection.UP || rot == ForgeDirection.DOWN || rot == ForgeDirection.UNKNOWN) {
            rot = ForgeDirection.EAST;
        }
        this.rotation = rot;
    }

    private boolean getFlag(int index) {
        if (index > 1) {
            return false;
        }
        if (index < 0) {
            return false;
        }
        index = 4 + 4 * index;
        int currentMeta = this.getMetadata();
        boolean result = (currentMeta & index) == index;
        return result;
    }

    public boolean getFlag1() {
        return this.getFlag(0);
    }

    public boolean getFlag2() {
        return this.getFlag(1);
    }

    public void setFlag1(boolean on) {
        this.flag1 = on;
    }

    public void setFlag2(boolean on) {
        this.flag2 = on;
    }

    public void func_70316_g() {
        this.isActive = true;
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
    }

    public boolean isLoaded() {
        return this.initialized;
    }

    public boolean isAddedToWorld() {
        return this.field_70331_k != null;
    }

    protected void initialize() {
        this.flag1 = this.getFlag1();
        this.flag2 = this.getFlag2();
        this.rotation = this.getRotation();
    }

    protected boolean isActive() {
        return this.isActive;
    }

    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.isLoaded = true;
    }

    public void onChunkUnload() {
        this.isActive = false;
    }

    public TileEntity getTileInDirection(ForgeDirection direction) {
        int x = this.field_70329_l + direction.offsetX;
        int y = this.field_70330_m + direction.offsetY;
        int z = this.field_70327_n + direction.offsetZ;
        if (this.field_70331_k != null && this.field_70331_k.func_72899_e(x, y, z)) {
            return this.field_70331_k.func_72796_p(x, y, z);
        }
        return null;
    }

    public String toString() {
        return String.format("%s,%s,%s", this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public boolean isAirBlock(ForgeDirection direction) {
        return this.field_70331_k != null && this.field_70331_k.func_72799_c(this.field_70329_l + direction.offsetX, this.field_70330_m + direction.offsetY, this.field_70327_n + direction.offsetZ);
    }

    public void sendBlockEvent(int key, int value) {
        this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n), key, value);
    }

    public void sync() {
        OpenBlock block = this.getBlock();
        if (block != null) {
            int ordinal = this.rotation.ordinal() - 2;
            int currentMeta = this.getMetadata();
            int newMeta = ordinal;
            newMeta = (this.flag1 ? 4 : 0) | newMeta & 3;
            newMeta = (this.flag2 ? 8 : 0) | newMeta & 7;
            if (currentMeta != newMeta) {
                this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, newMeta, 3);
            }
        }
    }

    public boolean shouldRefresh(int oldID, int newID, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return oldID != newID;
    }

    public OpenBlock getBlock() {
        Block block = Block.field_71973_m[this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n)];
        if (block instanceof OpenBlock) {
            return (OpenBlock)block;
        }
        return null;
    }

    public int getMetadata() {
        return this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void openGui(EntityPlayer player, Enum gui) {
        player.openGui((Object)OpenBlocks.instance, gui.ordinal(), this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }
}

