/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import java.util.Arrays;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import openblocks.OpenBlocks;
import openblocks.common.item.IMetaItem;
import openblocks.common.item.ItemGeneric;

public class MetaGeneric
implements IMetaItem {
    private String name;
    private Icon icon;
    private Object[][] recipes;

    public MetaGeneric(String name, Object ... recipe) {
        this.name = name;
        this.recipes = new Object[][]{recipe};
    }

    public MetaGeneric(String name, Object[] ... recipes) {
        this.name = name;
        this.recipes = recipes;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public String getUnlocalizedName(ItemStack stack) {
        return String.format("openblocks.%s", this.name);
    }

    @Override
    public boolean hitEntity(ItemStack itemStack, EntityLiving target, EntityLiving player) {
        return false;
    }

    @Override
    public boolean onItemUse(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        return false;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack itemStack, EntityPlayer player, World world) {
        return itemStack;
    }

    @Override
    public boolean displayInCreative() {
        return true;
    }

    @Override
    public void registerIcons(IconRegister register) {
        this.icon = register.func_94245_a(String.format("openblocks:%s", this.name));
    }

    @Override
    public void addRecipe() {
        if (this.recipes == null) {
            return;
        }
        for (int i = 0; i < this.recipes.length; ++i) {
            Object[] recipe = this.recipes[i];
            int amount = (Integer)recipe[0];
            boolean smelting = false;
            int itemId = 0;
            int itemMeta = 0;
            if (recipe[1] instanceof Integer) {
                itemId = amount;
                itemMeta = (Integer)recipe[1];
                smelting = true;
            } else {
                recipe = Arrays.copyOfRange(recipe, 1, recipe.length);
            }
            for (int j = 0; j < recipe.length; ++j) {
                if (!(recipe[j] instanceof ItemGeneric.Metas)) continue;
                recipe[j] = ((ItemGeneric.Metas)((Object)recipe[j])).newItemStack();
            }
            Object r = null;
            if (smelting) {
                FurnaceRecipes.func_77602_a().addSmelting(itemId, itemMeta, (ItemStack)recipe[2], ((Float)recipe[3]).floatValue());
                continue;
            }
            r = recipe[0] instanceof String ? new ShapedOreRecipe(OpenBlocks.Items.generic.newItemStack(this, amount), recipe) : new ShapelessOreRecipe(OpenBlocks.Items.generic.newItemStack(this, amount), recipe);
            if (r == null) continue;
            CraftingManager.func_77594_a().func_77592_b().add(r);
        }
    }
}

