/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.entity;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import openblocks.OpenBlocks;
import openblocks.common.GenericInventory;
import openblocks.common.entity.ai.EntityAICollectItem;
import openblocks.utils.BlockUtils;

public class EntityLuggage
extends EntityTameable
implements IEntityAdditionalSpawnData {
    protected GenericInventory inventory = new GenericInventory("luggage", false, 27);
    public boolean special;
    public int lastSound = 0;

    public EntityLuggage(World world) {
        super(world);
        this.field_70750_az = OpenBlocks.getTexturesPath("models/luggage.png");
        this.func_70105_a(0.5f, 0.5f);
        this.field_70697_bw = 0.4f;
        this.func_70903_f(true);
        this.func_70661_as().func_75491_a(true);
        this.func_70661_as().func_75495_e(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, this.field_70697_bw, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAICollectItem(this));
        this.field_70180_af.func_75682_a(18, (Object)this.inventory.func_70302_i_());
    }

    public void setSpecial() {
        if (this.special) {
            return;
        }
        this.special = true;
        GenericInventory inventory = new GenericInventory("luggage", false, 54);
        inventory.copyFrom(this.inventory);
        if (this.field_70180_af != null) {
            this.field_70180_af.func_75692_b(18, (Object)inventory.func_70302_i_());
        }
        this.inventory = inventory;
    }

    public void refreshTexture() {
        this.field_70750_az = OpenBlocks.getTexturesPath(this.isSpecial() ? "models/luggage_special.png" : "models/luggage.png");
    }

    public boolean isSpecial() {
        if (this.field_70170_p.field_72995_K) {
            return this.inventory.func_70302_i_() > 27;
        }
        return this.special;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            int inventorySize = this.field_70180_af.func_75679_c(18);
            if (this.inventory.func_70302_i_() != inventorySize) {
                this.inventory = new GenericInventory("luggage", false, inventorySize);
            }
            this.refreshTexture();
        }
        ++this.lastSound;
    }

    public boolean func_70650_aV() {
        return true;
    }

    public int func_70667_aM() {
        return 100;
    }

    public GenericInventory getInventory() {
        return this.inventory;
    }

    public EntityAgeable func_90011_a(EntityAgeable entityageable) {
        return null;
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K) {
            if (player.func_70093_af()) {
                ItemStack luggageItem = new ItemStack((Item)OpenBlocks.Items.luggage);
                NBTTagCompound tag = new NBTTagCompound();
                this.inventory.writeToNBT(tag);
                luggageItem.func_77982_d(tag);
                BlockUtils.dropItemStackInWorld(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, luggageItem);
                this.func_70106_y();
            } else {
                player.openGui((Object)OpenBlocks.instance, OpenBlocks.Gui.Luggage.ordinal(), player.field_70170_p, this.field_70157_k, 0, 0);
            }
        }
        return true;
    }

    public boolean canConsumeStackPartially(ItemStack stack) {
        return BlockUtils.testInventoryInsertion(this.inventory, stack) > 0;
    }

    protected void func_70036_a(int par1, int par2, int par3, int par4) {
        this.func_85030_a("openblocks.feet", 0.3f, 0.7f + this.field_70170_p.field_73012_v.nextFloat() * 0.5f);
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74757_a("shiny", this.special);
        this.inventory.writeToNBT(tag);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("shiny") && tag.func_74767_n("shiny")) {
            this.setSpecial();
        }
        this.inventory.readFromNBT(tag);
    }

    public void func_70077_a(EntityLightningBolt lightning) {
        this.setSpecial();
    }

    public boolean func_85032_ar() {
        return true;
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        data.writeInt(this.inventory.func_70302_i_());
    }

    public void readSpawnData(ByteArrayDataInput data) {
        this.inventory = new GenericInventory("luggage", false, data.readInt());
    }
}

