/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.entity;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import openblocks.OpenBlocks;

public class EntityHangGlider
extends Entity
implements IEntityAdditionalSpawnData {
    private EntityPlayer player;
    private boolean shouldDespawn = false;

    public EntityHangGlider(World world) {
        super(world);
    }

    public EntityHangGlider(World world, EntityPlayer player) {
        this(world);
        this.player = player;
        OpenBlocks.proxy.gliderMap.put(player, this);
    }

    protected void func_70088_a() {
    }

    public void despawnGlider() {
        this.shouldDespawn = true;
    }

    public void func_70071_h_() {
        if (this.player == null) {
            this.func_70106_y();
        } else {
            ItemStack held = this.player.func_70694_bm();
            if (this.player.field_70128_L || held == null || held.func_77973_b() == null || held.func_77973_b() != OpenBlocks.Items.hangGlider || this.shouldDespawn) {
                if (this.field_70170_p.field_72995_K) {
                    OpenBlocks.proxy.gliderClientMap.remove(this.player);
                } else {
                    OpenBlocks.proxy.gliderMap.remove(this.player);
                }
                this.func_70106_y();
            } else {
                this.fixPositions();
                double horizontalSpeed = 0.03;
                double verticalSpeed = 0.4;
                if (this.player.func_70093_af()) {
                    horizontalSpeed = 0.1;
                    verticalSpeed = 0.7;
                }
                if (!this.player.field_70122_E && this.player.field_70181_x < 0.0) {
                    this.player.field_70181_x *= verticalSpeed;
                    this.field_70181_x *= verticalSpeed;
                    double x = Math.cos(Math.toRadians(this.player.field_70759_as + 90.0f)) * horizontalSpeed;
                    double z = Math.sin(Math.toRadians(this.player.field_70759_as + 90.0f)) * horizontalSpeed;
                    this.player.field_70159_w += x;
                    this.player.field_70179_y += z;
                    this.player.field_70143_R = 0.0f;
                }
            }
        }
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public void fixPositions() {
        if (this.player != null) {
            this.field_70142_S = this.field_70169_q = this.player.field_70169_q;
            this.field_70137_T = this.field_70167_r = this.player.field_70167_r;
            this.field_70136_U = this.field_70166_s = this.player.field_70166_s;
            this.field_70165_t = this.player.field_70165_t;
            this.field_70163_u = this.player.field_70163_u;
            this.field_70161_v = this.player.field_70161_v;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.field_70126_B = this.player.field_70760_ar;
            this.field_70177_z = this.player.field_70761_aq;
            this.field_70127_C = this.player.field_70127_C;
            this.field_70125_A = this.player.field_70125_A;
            this.field_70159_w = this.field_70165_t - this.field_70169_q;
            this.field_70181_x = this.field_70163_u - this.field_70167_r;
            this.field_70179_y = this.field_70161_v - this.field_70166_s;
        }
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        data.writeUTF(this.player.field_71092_bJ);
    }

    public void readSpawnData(ByteArrayDataInput data) {
        this.player = this.field_70170_p.func_72924_a(data.readUTF());
        OpenBlocks.proxy.gliderClientMap.put(this.player, this);
    }
}

