/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.entity;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StringUtils;
import net.minecraft.world.World;
import openblocks.common.GenericInventory;
import openblocks.sync.ISyncHandler;
import openblocks.sync.ISyncableObject;
import openblocks.sync.SyncMap;
import openblocks.sync.SyncMapEntity;
import openblocks.sync.SyncableFlags;
import openblocks.sync.SyncableFloat;
import openblocks.utils.BlockUtils;

public class EntityGhost
extends EntityMob
implements IEntityAdditionalSpawnData,
IMob,
ISyncHandler {
    private String playerName;
    private static final boolean DISABLE_HEAD_ANIMATION = true;
    protected GenericInventory inventory = new GenericInventory("ghost", false, 100);
    public boolean aggresive;
    public GhostModifier modifier = GhostModifier.NONE;
    SyncMapEntity syncMap = new SyncMapEntity();
    SyncableFlags flags = new SyncableFlags();
    SyncableFloat opacity = new SyncableFloat(0.3f);

    public EntityGhost(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        this.field_70734_aK = this.func_70667_aM();
        this.field_70697_bw = 0.5f;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityLiving)this, EntityPlayer.class, this.field_70697_bw, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, this.field_70697_bw * 0.1f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityLiving)this, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityLiving)this, EntityPlayer.class, 16.0f, 0, true));
        this.func_70661_as().func_75491_a(true);
        this.field_70750_az = "/mob/char.png";
        this.syncMap.put(SyncKeys.FLAGS, (ISyncableObject)this.flags);
        this.syncMap.put(SyncKeys.OPACITY, (ISyncableObject)this.opacity);
    }

    public EntityGhost(World world, String playerName, IInventory playerInvent) {
        this(world);
        this.playerName = playerName;
        if (world.field_72995_K) {
            this.field_70120_cr = "http://skins.minecraft.net/MinecraftSkins/" + StringUtils.func_76338_a((String)playerName) + ".png";
        }
        this.inventory.copyFrom(playerInvent);
    }

    protected void func_70069_a(float par1) {
    }

    protected void func_70064_a(double par1, boolean par3) {
    }

    public boolean func_70617_f_() {
        return false;
    }

    public int func_82193_c(Entity par1Entity) {
        return 10;
    }

    private boolean shouldBeFlying() {
        float distanceToEntity;
        EntityLiving attackTarget = this.func_70643_av();
        if (attackTarget != null && (distanceToEntity = attackTarget.func_70032_d((Entity)this)) > 2.0f) {
            return true;
        }
        return this.flags.ticksSinceSet(FlagKeys.IS_FLYING) < 20;
    }

    public boolean shouldRenderFlying() {
        return this.flags.get(FlagKeys.IS_FLYING);
    }

    public float getOpacity() {
        return Float.valueOf(this.opacity.getValue()).floatValue();
    }

    public boolean hasHeadInHand() {
        return this.flags.get(FlagKeys.HEAD_IN_HAND);
    }

    public int ticksSinceHeadChange() {
        return this.flags.ticksSinceChange(FlagKeys.HEAD_IN_HAND);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            this.opacity.setValue(0.3f);
            boolean isIdle = this.func_70643_av() == null;
            this.flags.set(FlagKeys.IS_FLYING, this.shouldBeFlying());
            this.flags.set(FlagKeys.IS_IDLE, isIdle);
            int sinceIdle = this.flags.ticksSinceSet(FlagKeys.IS_IDLE);
            boolean headInHand = this.flags.get(FlagKeys.HEAD_IN_HAND);
            int ticksSinceHeadChange = this.flags.ticksSinceChange(FlagKeys.HEAD_IN_HAND);
            headInHand = false;
            if (this.flags.get(FlagKeys.IS_FLYING) && (double)(this.field_70170_p.func_72976_f((int)this.field_70165_t, (int)this.field_70161_v) + 1) > this.field_70163_u) {
                this.field_70181_x = Math.max(this.field_70181_x, 0.1);
            }
            this.flags.set(FlagKeys.HEAD_IN_HAND, headInHand);
        }
        this.syncMap.sync(this.field_70170_p, this, this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public boolean func_70097_a(DamageSource damageSource, int par2) {
        return super.func_70097_a(damageSource, par2);
    }

    @Override
    public void onSynced(List changes) {
    }

    public String func_96090_ax() {
        return String.format("Ghost of %s", this.playerName);
    }

    public boolean func_94062_bN() {
        return true;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected boolean func_70650_aV() {
        return true;
    }

    public int func_70667_aM() {
        return 60;
    }

    public void func_70109_d(NBTTagCompound tag) {
        super.func_70109_d(tag);
        if (this.playerName != null) {
            tag.func_74778_a("playerName", this.playerName);
        }
        this.inventory.writeToNBT(tag);
    }

    public void func_70020_e(NBTTagCompound tag) {
        super.func_70020_e(tag);
        if (tag.func_74764_b("playerName")) {
            this.playerName = tag.func_74779_i("playerName");
            if (this.field_70170_p.field_72995_K) {
                this.field_70120_cr = "http://skins.minecraft.net/MinecraftSkins/" + StringUtils.func_76338_a((String)this.playerName) + ".png";
            }
        }
        this.inventory.readFromNBT(tag);
    }

    public void func_70645_a(DamageSource damageSource) {
        if (!this.field_70170_p.field_72995_K) {
            BlockUtils.dropInventory((IInventory)this.inventory, this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        super.func_70645_a(damageSource);
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        data.writeUTF(this.playerName == null ? "Unknown" : this.playerName);
    }

    public void readSpawnData(ByteArrayDataInput data) {
        this.playerName = data.readUTF();
        this.field_70120_cr = "http://skins.minecraft.net/MinecraftSkins/" + StringUtils.func_76338_a((String)this.playerName) + ".png";
    }

    @Override
    public SyncMap getSyncMap() {
        return this.syncMap;
    }

    @Override
    public void writeIdentifier(DataOutputStream dos) throws IOException {
        dos.writeInt(this.field_70157_k);
    }

    public static enum FlagKeys {
        IS_FLYING,
        HEAD_IN_HAND,
        IS_IDLE;

    }

    public static enum SyncKeys {
        FLAGS,
        OPACITY;

    }

    public static enum GhostModifier {
        NONE,
        FIRE,
        ARROW,
        WATER;

    }
}

