/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openblocks.OpenBlocks;
import openblocks.common.api.IAwareTile;
import openblocks.common.api.ISurfaceAttachment;
import openblocks.common.item.ItemOpenBlock;
import openblocks.utils.BlockUtils;

public abstract class OpenBlock
extends BlockContainer {
    private String uniqueBlockId;
    private Class teClass = null;
    protected String modKey = "";

    protected OpenBlock(int id, Material material) {
        super(id, material);
        this.func_71849_a(OpenBlocks.tabOpenBlocks);
        this.func_71848_c(1.0f);
    }

    public TileEntity func_72274_a(World world) {
        try {
            if (this.teClass != null) {
                return (TileEntity)this.teClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (NoSuchMethodException nsm) {
            System.out.println("Notice: Cannot create TE automatically due to constructor requirements");
        }
        catch (Exception ex) {
            System.out.println("Notice: Error creating tile entity");
            ex.printStackTrace();
        }
        return null;
    }

    public void func_94332_a(IconRegister registry) {
        this.field_94336_cN = registry.func_94245_a(String.format("%s:%s", this.modKey, this.uniqueBlockId));
    }

    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te != null) {
            if (IInventory.class.isAssignableFrom(this.teClass)) {
                BlockUtils.dropTileInventory(te);
            }
            if (IAwareTile.class.isAssignableFrom(this.teClass)) {
                ((IAwareTile)te).onBlockBroken();
            }
        }
        super.func_71852_a(world, x, y, z, par5, par6);
    }

    public void setupBlock(Block instance, String uniqueName) {
        this.setupBlock(instance, uniqueName, null);
    }

    public void setupBlock(Block instance, String uniqueName, Class tileEntity) {
        this.setupBlock(instance, uniqueName, tileEntity, ItemOpenBlock.class);
    }

    public void setupBlock(Block instance, String uniqueName, Class tileEntity, Class itemClass) {
        this.uniqueBlockId = uniqueName;
        this.modKey = OpenBlocks.proxy.getModId().toLowerCase();
        GameRegistry.registerBlock((Block)instance, (Class)itemClass, (String)String.format("%s_%s", this.modKey, uniqueName));
        instance.func_71864_b(String.format("%s.%s", this.modKey, uniqueName));
        if (tileEntity != null) {
            GameRegistry.registerTileEntity((Class)tileEntity, (String)String.format("%s_%s", this.modKey, uniqueName));
            this.teClass = tileEntity;
        }
    }

    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return world.isBlockSolidOnSide(x += side.offsetX, y += side.offsetY, z += side.offsetZ, side.getOpposite());
    }

    public boolean canPlaceBlockOnSides(World world, int x, int y, int z, ForgeDirection ... sides) {
        for (ForgeDirection side : sides) {
            if (!this.canPlaceBlockOnSide(world, x, y, z, side)) continue;
            return true;
        }
        return false;
    }

    public void func_71863_a(World world, int x, int y, int z, int blockId) {
        ForgeDirection direction;
        TileEntity te = world.func_72796_p(x, y, z);
        if (te != null && IAwareTile.class.isAssignableFrom(this.teClass)) {
            ((IAwareTile)te).onNeighbourChanged(blockId);
        }
        if (te != null && te instanceof ISurfaceAttachment && !this.canPlaceBlockOnSide(world, x, y, z, direction = ((ISurfaceAttachment)te).getSurfaceDirection())) {
            this.func_71897_c(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_94571_i(x, y, z);
        }
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        IAwareTile te = (IAwareTile)this.getTileEntity((IBlockAccess)world, x, y, z, IAwareTile.class);
        if (te != null) {
            return te.onBlockActivated(player, side, hitX, hitY, hitZ);
        }
        return false;
    }

    public void func_71861_g(World world, int x, int y, int z) {
        IAwareTile te = (IAwareTile)this.getTileEntity((IBlockAccess)world, x, y, z, IAwareTile.class);
        if (te != null) {
            te.onBlockAdded();
        }
        super.func_71861_g(world, x, y, z);
    }

    public boolean func_71883_b(World world, int x, int y, int z, int eventId, int eventParam) {
        IAwareTile te = (IAwareTile)this.getTileEntity((IBlockAccess)world, x, y, z, IAwareTile.class);
        if (te != null) {
            return te.onBlockEventReceived(eventId, eventParam);
        }
        return super.func_71883_b(world, x, y, z, eventId, eventParam);
    }

    protected void setupDimensionsFromCenter(float x, float y, float z, float width, float height, float depth) {
        this.setupDimensions(x - width, y, z - depth, x + width, y + height, z + depth);
    }

    protected void setupDimensions(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.field_72026_ch = minX;
        this.field_72023_ci = minY;
        this.field_72024_cj = minZ;
        this.field_72021_ck = maxX;
        this.field_72022_cl = maxY;
        this.field_72019_cm = maxZ;
    }

    public AxisAlignedBB func_71911_a_(World world, int x, int y, int z) {
        this.func_71902_a((IBlockAccess)world, x, y, z);
        return super.func_71911_a_(world, x, y, z);
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        this.func_71902_a((IBlockAccess)world, x, y, z);
        return super.func_71872_e(world, x, y, z);
    }

    public boolean func_71930_b(World world, int x, int y, int z) {
        return this.canPlaceBlockOnSides(world, x, y, z, ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.SOUTH, ForgeDirection.NORTH, ForgeDirection.UP, ForgeDirection.DOWN);
    }

    public Object getTileEntity(IBlockAccess world, int x, int y, int z, Class T) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te != null && T.isAssignableFrom(te.getClass())) {
            return te;
        }
        return null;
    }

    public void onBlockPlacedBy(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, ForgeDirection side, float hitX, float hitY, float hitZ, int meta) {
        IAwareTile te = (IAwareTile)this.getTileEntity((IBlockAccess)world, x, y, z, IAwareTile.class);
        if (te != null) {
            te.onBlockPlacedBy(player, side, stack, hitX, hitY, hitZ);
        }
    }
}

