/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openblocks.OpenBlocks;
import openblocks.common.block.OpenBlock;
import openblocks.common.item.ItemTankBlock;
import openblocks.common.tileentity.TileEntityTank;

public class BlockTank
extends OpenBlock {
    public BlockTank() {
        super(OpenBlocks.Config.blockTankId, Material.field_76248_c);
        this.setupBlock((Block)this, "tank", TileEntityTank.class, ItemTankBlock.class);
    }

    public boolean canBeReplacedByLeaves(World world, int x, int y, int z) {
        return false;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        return false;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public int func_71857_b() {
        return OpenBlocks.renderId;
    }

    @Override
    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public void func_71846_a(World par1World, int par2, int par3, int par4, int par5, EntityPlayer par6EntityPlayer) {
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntityTank tank;
        if (!OpenBlocks.Config.tanksEmitLight) {
            return 0;
        }
        TileEntity ent = world.func_72796_p(x, y, z);
        if (ent == null) {
            return 0;
        }
        if (ent instanceof TileEntityTank && (tank = (TileEntityTank)ent).containsValidLiquid()) {
            try {
                int blockId = tank.getClientLiquidId();
                if (blockId < 0 || blockId > Block.field_71973_m.length) {
                    return 0;
                }
                if (Block.field_71973_m[blockId] == null) {
                    return 0;
                }
                return (int)Math.min((double)Block.field_71984_q[blockId], Math.max(0.0, 5.0 + tank.getPercentFull() * 15.0));
            }
            catch (Exception e) {
                System.out.println("[OpenModsMonitor] Hello, It's OpenBlocks here. We've got a " + e.toString() + " at " + x + "," + y + "," + z + ". Please report this to the OpenMods team, they'll patch this bug up as soon as possible.");
                return 0;
            }
        }
        return 0;
    }

    public int getLightOpacity(World world, int x, int y, int z) {
        if (!OpenBlocks.Config.tanksAreTransparent) {
            return 16;
        }
        if (!OpenBlocks.Config.tanksHaveDynamicTransparency) {
            return 0;
        }
        TileEntity ent = world.func_72796_p(x, y, z);
        if (ent == null) {
            return 16;
        }
        if (ent instanceof TileEntityTank) {
            TileEntityTank tank = (TileEntityTank)ent;
            if (tank.containsValidLiquid()) {
                return (int)Math.min(16.0, Math.max(0.0, tank.getPercentFull() * 16.0));
            }
            return 0;
        }
        return 255;
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            ItemStack itemStack = new ItemStack((Block)OpenBlocks.Blocks.tank);
            TileEntityTank tank = (TileEntityTank)this.getTileEntity((IBlockAccess)world, x, y, z, TileEntityTank.class);
            if (tank != null && tank.getAmount() > 10) {
                NBTTagCompound nbt = new NBTTagCompound();
                NBTTagCompound tankTag = tank.getItemNBT();
                nbt.func_74766_a("tank", tankTag);
                itemStack.func_77982_d(nbt);
            }
            float f = 0.7f;
            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, itemStack);
            entityitem.field_70293_c = 10;
            world.func_72838_d((Entity)entityitem);
        }
        return world.func_94571_i(x, y, z);
    }

    protected void func_71929_a(World world, int x, int y, int z, ItemStack itemStack) {
    }
}

