/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openblocks.OpenBlocks;
import openblocks.common.block.OpenBlock;
import openblocks.common.tileentity.TileEntityLightbox;
import openblocks.utils.BlockUtils;

public class BlockLightbox
extends OpenBlock {
    public Icon sideIcon;

    public BlockLightbox() {
        super(OpenBlocks.Config.blockLightboxId, Material.field_76264_q);
        this.setupBlock((Block)this, "lightbox", TileEntityLightbox.class);
        this.func_71900_a(1.0f);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) * 15;
    }

    @Override
    public void func_71861_g(World world, int x, int y, int z) {
        boolean powered = world.func_72864_z(x, y, z);
        world.func_72921_c(x, y, z, powered ? 1 : 0, 3);
    }

    @Override
    public void func_71863_a(World world, int x, int y, int z, int blockId) {
        boolean powered = world.func_72864_z(x, y, z);
        world.func_72921_c(x, y, z, powered ? 1 : 0, 3);
        super.func_71863_a(world, x, y, z, blockId);
    }

    public int func_85104_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        return meta;
    }

    @Override
    public void onBlockPlacedBy(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, ForgeDirection side, float hitX, float hitY, float hitZ, int meta) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile != null && tile instanceof TileEntityLightbox) {
            TileEntityLightbox lightbox = (TileEntityLightbox)tile;
            lightbox.setSurfaceAndRotation(side.getOpposite(), BlockUtils.get2dOrientation((EntityLiving)player));
        }
    }

    @Override
    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (!world.field_72995_K) {
            player.openGui((Object)OpenBlocks.instance, OpenBlocks.Gui.Lightbox.ordinal(), world, x, y, z);
        }
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        return !player.func_70093_af() && tileEntity != null;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public int func_71857_b() {
        return OpenBlocks.renderId;
    }

    @Override
    public void func_94332_a(IconRegister registry) {
        super.func_94332_a(registry);
        this.sideIcon = registry.func_94245_a(String.format("%s:%s", this.modKey, "lightbox_side"));
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile == null || !(tile instanceof TileEntityLightbox)) {
            return;
        }
        TileEntityLightbox lightbox = (TileEntityLightbox)tile;
        ForgeDirection direction = lightbox.getSurface();
        switch (direction) {
            case EAST: {
                this.func_71905_a(0.8f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case WEST: {
                this.func_71905_a(0.0f, 0.0f, 0.0f, 0.2f, 1.0f, 1.0f);
                break;
            }
            case NORTH: {
                this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.2f);
                break;
            }
            case SOUTH: {
                this.func_71905_a(0.0f, 0.0f, 0.8f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case UP: {
                this.func_71905_a(0.0f, 0.8f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case DOWN: {
                this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.2f, 1.0f);
                break;
            }
            default: {
                this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public Icon func_71858_a(int side, int meta) {
        if (side == 2 || side == 3) {
            return super.func_71858_a(side, meta);
        }
        return this.sideIcon;
    }
}

