/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openblocks.OpenBlocks;
import openblocks.common.block.OpenBlock;
import openblocks.common.tileentity.TileEntityGuide;
import openblocks.utils.BlockUtils;

public class BlockGuide
extends OpenBlock {
    public BlockGuide() {
        super(OpenBlocks.Config.blockGuideId, Material.field_76248_c);
        this.setupBlock((Block)this, "guide", TileEntityGuide.class);
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public int func_71857_b() {
        return OpenBlocks.renderId;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    @Override
    public void func_94332_a(IconRegister registry) {
        this.field_94336_cN = registry.func_94245_a("openblocks:guide");
        Icons.side = registry.func_94245_a("openblocks:guide_side");
    }

    public boolean canBeReplacedByLeaves(World world, int x, int y, int z) {
        return false;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        return false;
    }

    @Override
    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float what, float are, float you) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity == null || !(tileEntity instanceof TileEntityGuide)) {
            return false;
        }
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                ((TileEntityGuide)tileEntity).switchMode(player);
            } else if (player.field_71075_bZ.field_75098_d && world.func_72798_a(x, y + 1, z) == Block.field_72089_ap.field_71990_ca) {
                ((TileEntityGuide)tileEntity).fill(player);
            } else {
                ((TileEntityGuide)tileEntity).changeDimensions(player, ForgeDirection.getOrientation((int)side));
            }
        }
        return true;
    }

    public Icon func_71858_a(int side, int metadata) {
        ForgeDirection direction = BlockUtils.sideToDirection(side);
        if (direction == ForgeDirection.UP || direction == ForgeDirection.DOWN) {
            return this.field_94336_cN;
        }
        return Icons.side;
    }

    public static class Icons {
        public static Icon side;
    }
}

