/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import openblocks.OpenBlocks;
import openblocks.common.block.OpenBlock;
import openblocks.common.entity.EntityGhost;
import openblocks.common.tileentity.TileEntityGrave;
import openblocks.utils.BlockUtils;

public class BlockGrave
extends OpenBlock {
    public BlockGrave() {
        super(OpenBlocks.Config.blockGraveId, Material.field_82717_g);
        this.setupBlock((Block)this, "grave", TileEntityGrave.class);
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public int func_71925_a(Random rand) {
        return 0;
    }

    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
    }

    @Override
    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        TileEntityGrave tile;
        if (!world.field_72995_K && (tile = (TileEntityGrave)this.getTileEntity((IBlockAccess)world, x, y, z, TileEntityGrave.class)) != null) {
            this.handleGhostSpawn(tile, world, x, y, z);
        }
        super.func_71852_a(world, x, y, z, par5, par6);
    }

    public int func_71857_b() {
        return OpenBlocks.renderId;
    }

    private void updateOnSoilStatus(World worldObj, int x, int y, int z) {
        TileEntityGrave graveEnt = (TileEntityGrave)worldObj.func_72796_p(x, y, z);
        if (graveEnt != null) {
            int id = 0;
            id = worldObj.func_72798_a(x, y - 1, z);
            Block block = Block.field_71973_m[id];
            if (block != null) {
                graveEnt.onSoil = block == Block.field_71979_v || block == Block.field_71980_u;
            }
        }
    }

    @Override
    public void func_71863_a(World worldObj, int x, int y, int z, int changedBlockId) {
        super.func_71863_a(worldObj, x, y, z, changedBlockId);
        this.updateOnSoilStatus(worldObj, x, y, z);
    }

    public void func_71898_d(World world, int x, int y, int z, int par5) {
    }

    private boolean shouldSpawnGhost(World world) {
        if (world.field_73013_u == 0) {
            return false;
        }
        return OpenBlocks.Config.ghostSpawnProbability > world.field_73012_v.nextInt(100);
    }

    private void handleGhostSpawn(TileEntityGrave grave, World world, int x, int y, int z) {
        if (this.shouldSpawnGhost(world)) {
            EntityGhost ghost = new EntityGhost(world, grave.getUsername(), grave.getLoot());
            ghost.func_70080_a(x, y, z, 0.0f, 0.0f);
            world.func_72838_d((Entity)ghost);
        } else {
            BlockUtils.dropInventory(grave.getLoot(), world, x, y, z);
        }
    }

    @Override
    public AxisAlignedBB func_71911_a_(World world, int x, int y, int z) {
        this.func_71902_a((IBlockAccess)world, x, y, z);
        return super.func_71911_a_(world, x, y, z);
    }

    @Override
    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        this.func_71902_a((IBlockAccess)world, x, y, z);
        return super.func_71872_e(world, x, y, z);
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.3f, 1.0f);
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLiving living, ItemStack stack) {
        super.func_71860_a(world, x, y, z, living, stack);
        this.updateOnSoilStatus(world, x, y, z);
        TileEntityGrave grave = (TileEntityGrave)world.func_72796_p(x, y, z);
        if (living instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)living;
            grave.setUsername(player.field_71092_bJ);
            grave.setLoot((IInventory)player.field_71071_by);
        }
    }
}

