/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import java.lang.reflect.Method;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import openblocks.OpenBlocks;
import openblocks.common.tileentity.TileEntityTrophy;
import openblocks.trophy.BlazeBehavior;
import openblocks.trophy.CaveSpiderBehavior;
import openblocks.trophy.CreeperBehavior;
import openblocks.trophy.EndermanBehavior;
import openblocks.trophy.ITrophyBehavior;
import openblocks.trophy.ItemDropBehavior;
import openblocks.trophy.MooshroomBehavior;
import openblocks.trophy.SkeletonBehavior;
import openblocks.trophy.SnowmanBehavior;
import openblocks.trophy.SquidBehavior;
import openblocks.utils.BlockUtils;

public class TrophyHandler {
    public static HashMap entityCache = new HashMap();

    public static Entity getEntityFromCache(Trophy trophy) {
        Entity entity = (Entity)entityCache.get((Object)trophy);
        if (entity == null) {
            entity = EntityList.func_75620_a((String)trophy.toString(), null);
            if (entity instanceof EntitySlime) {
                try {
                    Method slimeSizeMethod = EntitySlime.class.getDeclaredMethod("setSlimeSize", Integer.TYPE);
                    if (slimeSizeMethod == null) {
                        slimeSizeMethod = EntitySlime.class.getDeclaredMethod("func_70799_a", Integer.TYPE);
                    }
                    if (slimeSizeMethod != null) {
                        slimeSizeMethod.setAccessible(true);
                        slimeSizeMethod.invoke((Object)entity, 1);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            entityCache.put(trophy, entity);
        }
        return entity;
    }

    @ForgeSubscribe
    public void onLivingDeath(LivingDeathEvent event) {
        Entity entity;
        String entityName;
        if (!event.entity.field_70170_p.field_72995_K && Math.random() < OpenBlocks.Config.trophyDropChance && (entityName = EntityList.func_75621_b((Entity)(entity = event.entity))) != null && !entityName.isEmpty()) {
            Trophy mobTrophy = null;
            try {
                mobTrophy = Trophy.valueOf(EntityList.func_75621_b((Entity)entity));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (mobTrophy != null) {
                BlockUtils.dropItemStackInWorld(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, mobTrophy.getItemStack());
            }
        }
    }

    public static enum Trophy {
        Wolf,
        Chicken((ITrophyBehavior)new ItemDropBehavior(10000, Item.field_77764_aP.field_77779_bT, "mob.chicken.plop")),
        Cow((ITrophyBehavior)new ItemDropBehavior(20000, Item.field_77770_aF.field_77779_bT)),
        Creeper((ITrophyBehavior)new CreeperBehavior()),
        Skeleton((ITrophyBehavior)new SkeletonBehavior()),
        PigZombie((ITrophyBehavior)new ItemDropBehavior(20000, Item.field_77733_bq.field_77779_bT)),
        Bat(1.0, -0.3),
        Zombie,
        Witch(0.35),
        Villager,
        Ozelot,
        Sheep,
        Blaze((ITrophyBehavior)new BlazeBehavior()),
        Silverfish,
        Spider,
        CaveSpider((ITrophyBehavior)new CaveSpiderBehavior()),
        Slime(0.4),
        Ghast(0.1, 0.2),
        Enderman(0.3, (ITrophyBehavior)new EndermanBehavior()),
        LavaSlime(0.8),
        Squid(0.3, 0.5, (ITrophyBehavior)new SquidBehavior()),
        MushroomCow((ITrophyBehavior)new MooshroomBehavior()),
        VillagerGolem(0.3),
        SnowMan((ITrophyBehavior)new SnowmanBehavior()),
        Pig((ITrophyBehavior)new ItemDropBehavior(20000, Item.field_77784_aq.field_77779_bT));

        private double scale = 0.4;
        private double verticalOffset = 0.0;
        private ITrophyBehavior behavior;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private Trophy() {
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private Trophy() {
            void behavior;
            this.behavior = behavior;
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private Trophy() {
            void scale;
            this.scale = scale;
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private Trophy() {
            void behavior;
            this.scale = (double)scale;
            this.behavior = behavior;
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private Trophy() {
            this((String)var1_-1, (int)var2_-1, scale);
            void verticalOffset;
            void var2_-1;
            void var1_-1;
            this.verticalOffset = verticalOffset;
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private Trophy(ITrophyBehavior verticalOffset) {
            this((String)var1_-1, (int)var2_-1, scale, (double)verticalOffset);
            void behavior;
            void var2_-1;
            void var1_-1;
            this.behavior = behavior;
        }

        public double getVerticalOffset() {
            return this.verticalOffset;
        }

        public double getScale() {
            return this.scale;
        }

        public Entity getEntity() {
            return TrophyHandler.getEntityFromCache(this);
        }

        public ItemStack getItemStack() {
            ItemStack stack = new ItemStack((Block)OpenBlocks.Blocks.trophy, 1, this.ordinal());
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("entity", this.toString());
            stack.func_77982_d(tag);
            return stack;
        }

        public void playSound(World world, double x, double y, double z) {
            Entity e = this.getEntity();
            e.field_70165_t = x;
            e.field_70163_u = y;
            e.field_70161_v = z;
            e.field_70170_p = world;
            if (e instanceof EntityLiving) {
                ((EntityLiving)e).func_70642_aH();
            }
        }

        public void executeActivateBehavior(TileEntityTrophy tile, EntityPlayer player) {
            if (this.behavior != null) {
                this.behavior.executeActivateBehavior(tile, player);
            }
        }

        public void executeTickBehavior(TileEntityTrophy tile) {
            if (this.behavior != null) {
                this.behavior.executeTickBehavior(tile);
            }
        }
    }
}

