/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import openblocks.OpenBlocks;
import openblocks.client.renderer.tileentity.OpenRenderHelper;
import openblocks.common.tileentity.TileEntityTank;
import org.lwjgl.opengl.GL11;

public class TileEntityTankRenderer
extends TileEntitySpecialRenderer {
    RenderBlocks renderBlocks = new RenderBlocks();

    public void func_76894_a(TileEntity tileentity, double x, double y, double z, float f) {
        boolean tankDown;
        this.func_76897_a("/terrain.png");
        TileEntityTank tankTile = (TileEntityTank)tileentity;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GL11.glPushMatrix();
        boolean tankInEast = tankTile.getTankInDirection(ForgeDirection.EAST) != null;
        boolean tankInWest = tankTile.getTankInDirection(ForgeDirection.WEST) != null;
        boolean tankInNorth = tankTile.getTankInDirection(ForgeDirection.NORTH) != null;
        boolean tankInSouth = tankTile.getTankInDirection(ForgeDirection.SOUTH) != null;
        boolean tankUp = tankTile.getTankInDirection(ForgeDirection.UP) != null;
        boolean bl = tankDown = tankTile.getTankInDirection(ForgeDirection.DOWN) != null;
        if (!tankInEast) {
            if (!tankInNorth) {
                OpenRenderHelper.renderCube(0.475, -0.501, -0.501, 0.501, 0.501, -0.475, (Block)OpenBlocks.Blocks.tank, null);
            }
            if (!tankInSouth) {
                OpenRenderHelper.renderCube(0.475, -0.501, 0.475, 0.501, 0.501, 0.501, (Block)OpenBlocks.Blocks.tank, null);
            }
            if (!tankDown) {
                OpenRenderHelper.renderCube(0.475, -0.501, -0.501, 0.501, -0.475, 0.501, (Block)OpenBlocks.Blocks.tank, null);
            }
            if (!tankUp) {
                OpenRenderHelper.renderCube(0.475, 0.475, -0.501, 0.501, 0.501, 0.501, (Block)OpenBlocks.Blocks.tank, null);
            }
        }
        if (!tankInWest) {
            if (!tankInNorth) {
                OpenRenderHelper.renderCube(-0.501, -0.501, -0.501, -0.475, 0.501, -0.475, (Block)OpenBlocks.Blocks.tank, null);
            }
            if (!tankInSouth) {
                OpenRenderHelper.renderCube(-0.501, -0.501, 0.475, -0.475, 0.501, 0.501, (Block)OpenBlocks.Blocks.tank, null);
            }
            if (!tankDown) {
                OpenRenderHelper.renderCube(-0.501, -0.501, -0.501, -0.475, -0.475, 0.501, (Block)OpenBlocks.Blocks.tank, null);
            }
            if (!tankUp) {
                OpenRenderHelper.renderCube(-0.501, 0.475, -0.501, -0.475, 0.501, 0.501, (Block)OpenBlocks.Blocks.tank, null);
            }
        }
        if (!tankInNorth) {
            if (!tankUp) {
                OpenRenderHelper.renderCube(-0.501, 0.475, -0.501, 0.501, 0.501, -0.475, (Block)OpenBlocks.Blocks.tank, null);
            }
            if (!tankDown) {
                OpenRenderHelper.renderCube(-0.501, -0.501, -0.501, 0.501, -0.475, -0.475, (Block)OpenBlocks.Blocks.tank, null);
            }
        }
        if (!tankInSouth) {
            if (!tankUp) {
                OpenRenderHelper.renderCube(-0.501, 0.475, 0.475, 0.501, 0.501, 0.501, (Block)OpenBlocks.Blocks.tank, null);
            }
            if (!tankDown) {
                OpenRenderHelper.renderCube(-0.501, -0.501, 0.475, 0.501, -0.475, 0.501, (Block)OpenBlocks.Blocks.tank, null);
            }
        }
        GL11.glEnable((int)2896);
        LiquidTank internalTank = tankTile.getInternalTank();
        LiquidStack liquid = internalTank.getLiquid();
        this.func_76897_a("/terrain.png");
        if (liquid != null && tankTile.getHeightForRender() > 0.05) {
            Block block = null;
            Icon texture = null;
            GL11.glPushMatrix();
            GL11.glDisable((int)2896);
            try {
                if (liquid.itemID < Block.field_71973_m.length && Block.field_71973_m[liquid.itemID] != null) {
                    block = Block.field_71973_m[liquid.itemID];
                    texture = TileEntityTankRenderer.getLiquidTexture(liquid);
                } else if (Item.field_77698_e[liquid.itemID] != null) {
                    block = Block.field_71943_B;
                    texture = TileEntityTankRenderer.getLiquidTexture(liquid);
                }
                this.func_76897_a(TileEntityTankRenderer.getLiquidSheet(liquid));
                Tessellator t = Tessellator.field_78398_a;
                double ySouthEast = tankTile.getLiquidHeightForSide(ForgeDirection.SOUTH, ForgeDirection.EAST);
                double yNorthEast = tankTile.getLiquidHeightForSide(ForgeDirection.NORTH, ForgeDirection.EAST);
                double ySouthWest = tankTile.getLiquidHeightForSide(ForgeDirection.SOUTH, ForgeDirection.WEST);
                double yNorthWest = tankTile.getLiquidHeightForSide(ForgeDirection.NORTH, ForgeDirection.WEST);
                double uMin = texture.func_94214_a(0.0);
                double uMax = texture.func_94214_a(16.0);
                double vMin = texture.func_94207_b(0.0);
                double vMax = texture.func_94207_b(16.0);
                double vHeight = vMax - vMin;
                t.func_78382_b();
                t.func_78374_a(0.5, -0.5, -0.5, uMax, vMin);
                t.func_78374_a(-0.5, -0.5, -0.5, uMin, vMin);
                t.func_78374_a(-0.5, -0.5 + yNorthWest, -0.5, uMin, vMin + vHeight * yNorthWest);
                t.func_78374_a(0.5, -0.5 + yNorthEast, -0.5, uMax, vMin + vHeight * yNorthEast);
                t.func_78381_a();
                t.func_78382_b();
                t.func_78374_a(0.5, -0.5, 0.5, uMin, vMin);
                t.func_78374_a(0.5, -0.5 + ySouthEast, 0.5, uMin, vMin + vHeight * ySouthEast);
                t.func_78374_a(-0.5, -0.5 + ySouthWest, 0.5, uMax, vMin + vHeight * ySouthWest);
                t.func_78374_a(-0.5, -0.5, 0.5, uMax, vMin);
                t.func_78381_a();
                t.func_78382_b();
                t.func_78374_a(0.5, -0.5, -0.5, uMin, vMin);
                t.func_78374_a(0.5, -0.5 + yNorthEast, -0.5, uMin, vMin + vHeight * yNorthEast);
                t.func_78374_a(0.5, -0.5 + ySouthEast, 0.5, uMax, vMin + vHeight * ySouthEast);
                t.func_78374_a(0.5, -0.5, 0.5, uMax, vMin);
                t.func_78381_a();
                t.func_78382_b();
                t.func_78374_a(-0.5, -0.5, 0.5, uMin, vMin);
                t.func_78374_a(-0.5, -0.5 + ySouthWest, 0.5, uMin, vMin + vHeight * ySouthWest);
                t.func_78374_a(-0.5, -0.5 + yNorthWest, -0.5, uMax, vMin + vHeight * yNorthWest);
                t.func_78374_a(-0.5, -0.5, -0.5, uMax, vMin);
                t.func_78381_a();
                t.func_78382_b();
                t.func_78374_a(0.5, -0.5 + ySouthEast, 0.5, uMax, vMin);
                t.func_78374_a(0.5, -0.5 + yNorthEast, -0.5, uMin, vMin);
                t.func_78374_a(-0.5, -0.5 + yNorthWest, -0.5, uMin, vMax);
                t.func_78374_a(-0.5, -0.5 + ySouthWest, 0.5, uMax, vMax);
                t.func_78381_a();
                t.func_78382_b();
                t.func_78374_a(0.5, -0.5, -0.5, uMax, vMin);
                t.func_78374_a(0.5, -0.5, 0.5, uMin, vMin);
                t.func_78374_a(-0.5, -0.5, 0.5, uMin, vMax);
                t.func_78374_a(-0.5, -0.5, -0.5, uMax, vMax);
                t.func_78381_a();
            }
            catch (Exception e) {
                // empty catch block
            }
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public static Icon getLiquidTexture(LiquidStack liquid) throws Exception {
        if (liquid == null || liquid.itemID <= 0) {
            return null;
        }
        LiquidStack canon = liquid.canonical();
        if (canon == null) {
            throw new Exception();
        }
        Icon icon = canon.getRenderingIcon();
        if (icon == null) {
            throw new Exception();
        }
        return icon;
    }

    public static String getLiquidSheet(LiquidStack liquid) {
        if (liquid == null || liquid.itemID <= 0) {
            return "/terrain.png";
        }
        LiquidStack canon = liquid.canonical();
        if (canon == null) {
            return "/terrain.png";
        }
        return canon.getTextureSheet();
    }
}

