/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import openblocks.OpenBlocks;
import openblocks.client.renderer.tileentity.OpenRenderHelper;
import openblocks.common.TrophyHandler;
import openblocks.common.tileentity.TileEntityBearTrap;
import openblocks.common.tileentity.TileEntityFlag;
import openblocks.common.tileentity.TileEntityGrave;
import openblocks.common.tileentity.TileEntityGuide;
import openblocks.common.tileentity.TileEntityLightbox;
import openblocks.common.tileentity.TileEntitySprinkler;
import openblocks.common.tileentity.TileEntityTarget;
import openblocks.common.tileentity.TileEntityTrophy;
import org.lwjgl.opengl.GL11;

public class BlockRenderingHandler
implements ISimpleBlockRenderingHandler {
    private TileEntityGuide teGuide = new TileEntityGuide();
    private TileEntityLightbox teLightbox = new TileEntityLightbox();
    private TileEntityTarget teTarget = new TileEntityTarget();
    private TileEntityGrave teGrave = new TileEntityGrave();
    private TileEntityFlag teFlag = new TileEntityFlag();
    private TileEntityTrophy teTrophy = new TileEntityTrophy();
    private TileEntityBearTrap teBearTrap = new TileEntityBearTrap();
    private TileEntitySprinkler teSprinkler = new TileEntitySprinkler();

    public BlockRenderingHandler() {
        this.teTarget.setEnabled(true);
    }

    public int getRenderId() {
        return OpenBlocks.renderId;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        TileEntity te = null;
        if (block == OpenBlocks.Blocks.lightbox) {
            te = this.teLightbox;
        } else if (block == OpenBlocks.Blocks.target) {
            te = this.teTarget;
        } else if (block == OpenBlocks.Blocks.grave) {
            te = this.teGrave;
        } else if (block == OpenBlocks.Blocks.flag) {
            te = this.teFlag;
            this.teFlag.setColorIndex(metadata);
        } else if (block == OpenBlocks.Blocks.trophy) {
            if (metadata < TrophyHandler.Trophy.values().length) {
                te = this.teTrophy;
                this.teTrophy.trophyType = TrophyHandler.Trophy.values()[metadata];
            }
        } else if (block == OpenBlocks.Blocks.bearTrap) {
            te = this.teBearTrap;
            this.teBearTrap.setOpen();
        } else if (block == OpenBlocks.Blocks.sprinkler) {
            te = this.teSprinkler;
        }
        try {
            if (Minecraft.func_71410_x().field_71441_e != null) {
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                if (te != null) {
                    te.field_70331_k = Minecraft.func_71410_x().field_71441_e;
                    GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
                    TileEntityRenderer.field_76963_a.func_76949_a(te, 0.0, 0.0, 0.0, 0.0f);
                } else {
                    OpenRenderHelper.renderCube(-0.5, -0.5, -0.5, 0.5, 0.5, 0.5, block, null);
                }
                GL11.glEnable((int)32826);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        return false;
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }
}

