/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.fx;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.LiquidStack;

public class FXLiquidSpray
extends EntityFX {
    public FXLiquidSpray(World par1World, LiquidStack liquid, double x, double y, double z, ForgeDirection sprayDirection, float angle, float spread) {
        super(par1World, x, y, z, 0.0, 0.0, 0.0);
        float sprayStrength = 1.0f;
        double sinPitch = Math.sin(angle);
        double cosPitch = Math.cos(angle);
        double vecX = 0.0;
        double vecY = 0.0;
        double vecZ = 0.0;
        if (sprayDirection.offsetZ == 0) {
            vecY = Math.abs(cosPitch);
            vecZ = sinPitch * (double)sprayDirection.offsetX;
        } else {
            vecY = Math.abs(cosPitch);
            vecX = -sinPitch * (double)sprayDirection.offsetZ;
        }
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        this.field_70545_g = 0.7f;
        this.field_70547_e = 50;
        this.func_70105_a(0.5f, 0.5f);
        this.field_70544_f = 0.3f;
        this.field_70145_X = false;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (sprayDirection.offsetX == 0) {
            vecZ = (this.field_70146_Z.nextDouble() - 0.5) * (double)spread;
        } else {
            vecX = (this.field_70146_Z.nextDouble() - 0.5) * (double)spread;
        }
        this.field_70159_w = vecX / 2.0;
        this.field_70181_x = vecY / 2.0;
        this.field_70179_y = vecZ / 2.0;
        Block block = null;
        Icon texture = null;
        try {
            if (liquid.itemID < Block.field_71973_m.length && Block.field_71973_m[liquid.itemID] != null) {
                block = Block.field_71973_m[liquid.itemID];
                texture = FXLiquidSpray.getLiquidTexture(liquid);
            } else if (Item.field_77698_e[liquid.itemID] != null) {
                block = Block.field_71943_B;
                texture = FXLiquidSpray.getLiquidTexture(liquid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.func_94052_a(Minecraft.func_71410_x().field_71446_o, texture);
    }

    public int func_70537_b() {
        return 1;
    }

    public void func_70539_a(Tessellator par1Tessellator, float par2, float par3, float par4, float par5, float par6, float par7) {
        float f6 = ((float)this.field_70546_d + par2) / (float)this.field_70547_e;
        super.func_70539_a(par1Tessellator, par2, par3, par4, par5, par6, par7);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    public static Icon getLiquidTexture(LiquidStack liquid) throws Exception {
        if (liquid == null || liquid.itemID <= 0) {
            return null;
        }
        LiquidStack canon = liquid.canonical();
        if (canon == null) {
            throw new Exception();
        }
        Icon icon = canon.getRenderingIcon();
        if (icon == null) {
            throw new Exception();
        }
        return icon;
    }
}

