/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundPool;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.event.ForgeSubscribe;
import openblocks.OpenBlocks;

public class SoundLoader {
    String[] soundFiles = new String[]{"teleport.ogg", "open.ogg", "close.ogg", "beartrapclose.ogg", "beartrapcloseb.ogg", "beartrapopen.ogg", "slowpokenom.ogg", "feet.ogg", "chomp.ogg"};
    String[] streamingFiles = new String[0];

    @SideOnly(value=Side.CLIENT)
    @ForgeSubscribe
    public void loadingSounds(SoundLoadEvent event) {
        this.loadSounds(event, event.manager.field_77379_b, this.soundFiles);
        this.loadSounds(event, event.manager.field_77380_c, this.streamingFiles);
    }

    public void loadSounds(SoundLoadEvent event, SoundPool pool, String[] fileNames) {
        Minecraft mc = Minecraft.func_71410_x();
        File resourcesDirectory = new File(mc.field_71412_D, "resources/openblocks/");
        if (!resourcesDirectory.exists()) {
            resourcesDirectory.mkdir();
        }
        for (String fileName : fileNames) {
            try {
                File soundFile = new File(resourcesDirectory, fileName);
                if (!soundFile.exists()) {
                    InputStream streamIn = OpenBlocks.class.getResourceAsStream("/mods/openblocks/sounds/" + fileName);
                    BufferedOutputStream streamOut = new BufferedOutputStream(new FileOutputStream(soundFile));
                    byte[] buffer = new byte[1024];
                    int len = 0;
                    while ((len = streamIn.read(buffer)) >= 0) {
                        streamOut.write(buffer, 0, len);
                    }
                    streamIn.close();
                    streamOut.close();
                }
                event.manager.field_77379_b.func_77459_a("openblocks/" + fileName, soundFile);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

