/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.Calendar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.liquids.LiquidStack;
import openblocks.OpenBlocks;
import openblocks.client.ClientEventHandler;
import openblocks.client.ClientTickHandler;
import openblocks.client.SoundLoader;
import openblocks.client.fx.FXLiquidSpray;
import openblocks.client.gui.GuiLightbox;
import openblocks.client.gui.GuiLuggage;
import openblocks.client.gui.GuiSprinkler;
import openblocks.client.renderer.BlockRenderingHandler;
import openblocks.client.renderer.ItemRendererHangGlider;
import openblocks.client.renderer.ItemRendererLuggage;
import openblocks.client.renderer.ItemRendererTank;
import openblocks.client.renderer.entity.EntityGhostRenderer;
import openblocks.client.renderer.entity.EntityHangGliderRenderer;
import openblocks.client.renderer.entity.EntityLuggageRenderer;
import openblocks.client.renderer.entity.EntityPlayerRenderer;
import openblocks.client.renderer.tileentity.TileEntityBearTrapRenderer;
import openblocks.client.renderer.tileentity.TileEntityFlagRenderer;
import openblocks.client.renderer.tileentity.TileEntityGraveRenderer;
import openblocks.client.renderer.tileentity.TileEntityGuideRenderer;
import openblocks.client.renderer.tileentity.TileEntityLightboxRenderer;
import openblocks.client.renderer.tileentity.TileEntitySprinklerRenderer;
import openblocks.client.renderer.tileentity.TileEntityTankRenderer;
import openblocks.client.renderer.tileentity.TileEntityTargetRenderer;
import openblocks.client.renderer.tileentity.TileEntityTrophyRenderer;
import openblocks.common.CommonProxy;
import openblocks.common.container.ContainerLightbox;
import openblocks.common.container.ContainerLuggage;
import openblocks.common.container.ContainerSprinkler;
import openblocks.common.entity.EntityGhost;
import openblocks.common.entity.EntityHangGlider;
import openblocks.common.entity.EntityLuggage;
import openblocks.common.tileentity.TileEntityBearTrap;
import openblocks.common.tileentity.TileEntityFlag;
import openblocks.common.tileentity.TileEntityGrave;
import openblocks.common.tileentity.TileEntityGuide;
import openblocks.common.tileentity.TileEntityLightbox;
import openblocks.common.tileentity.TileEntitySprinkler;
import openblocks.common.tileentity.TileEntityTank;
import openblocks.common.tileentity.TileEntityTarget;
import openblocks.common.tileentity.TileEntityTrophy;
import openblocks.sync.SyncableManager;

public class ClientProxy
extends CommonProxy {
    private ItemRendererHangGlider hangGliderRenderer;

    public ClientProxy() {
        OpenBlocks.syncableManager = new SyncableManager();
        MinecraftForge.EVENT_BUS.register((Object)new SoundLoader());
    }

    @Override
    public void registerRenderInformation() {
        OpenBlocks.renderId = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRenderingHandler());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityGuide.class, (TileEntitySpecialRenderer)new TileEntityGuideRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLightbox.class, (TileEntitySpecialRenderer)new TileEntityLightboxRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTarget.class, (TileEntitySpecialRenderer)new TileEntityTargetRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityGrave.class, (TileEntitySpecialRenderer)new TileEntityGraveRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityFlag.class, (TileEntitySpecialRenderer)new TileEntityFlagRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTank.class, (TileEntitySpecialRenderer)new TileEntityTankRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTrophy.class, (TileEntitySpecialRenderer)new TileEntityTrophyRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBearTrap.class, (TileEntitySpecialRenderer)new TileEntityBearTrapRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySprinkler.class, (TileEntitySpecialRenderer)new TileEntitySprinklerRenderer());
        MinecraftForgeClient.registerItemRenderer((int)OpenBlocks.Config.blockTankId, (IItemRenderer)new ItemRendererTank());
        this.assertItemHangGliderRenderer();
        MinecraftForge.EVENT_BUS.register((Object)this.hangGliderRenderer);
        RenderingRegistry.registerEntityRenderingHandler(EntityGhost.class, (Render)new EntityGhostRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityHangGlider.class, (Render)new EntityHangGliderRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityLuggage.class, (Render)new EntityLuggageRenderer());
        MinecraftForgeClient.registerItemRenderer((int)OpenBlocks.Items.luggage.field_77779_bT, (IItemRenderer)new ItemRendererLuggage());
        TickRegistry.registerTickHandler((ITickHandler)new ClientTickHandler(), (Side)Side.CLIENT);
        this.attachPlayerRenderer();
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
    }

    @Override
    public void assertItemHangGliderRenderer() {
        if (this.hangGliderRenderer == null) {
            this.hangGliderRenderer = new ItemRendererHangGlider();
        }
        if (MinecraftForgeClient.getItemRenderer((ItemStack)new ItemStack((Item)OpenBlocks.Items.hangGlider), (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.EQUIPPED) == null) {
            MinecraftForgeClient.registerItemRenderer((int)OpenBlocks.Items.hangGlider.field_77779_bT, (IItemRenderer)this.hangGliderRenderer);
        }
    }

    private void attachPlayerRenderer() {
        Render render;
        if (OpenBlocks.Config.tryHookPlayerRenderer && (render = (Render)RenderManager.field_78727_a.field_78729_o.get(EntityPlayer.class)).getClass().equals(RenderPlayer.class)) {
            EntityPlayerRenderer playerRenderer = new EntityPlayerRenderer();
            playerRenderer.func_76976_a(RenderManager.field_78727_a);
            RenderManager.field_78727_a.field_78729_o.put(EntityPlayer.class, playerRenderer);
        }
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (world instanceof WorldClient) {
            if (ID == OpenBlocks.Gui.Luggage.ordinal()) {
                return new GuiLuggage(new ContainerLuggage((IInventory)player.field_71071_by, (EntityLuggage)world.func_73045_a(x)));
            }
            TileEntity tile = world.func_72796_p(x, y, z);
            if (ID == OpenBlocks.Gui.Lightbox.ordinal()) {
                return new GuiLightbox(new ContainerLightbox((IInventory)player.field_71071_by, (TileEntityLightbox)tile));
            }
            if (ID == OpenBlocks.Gui.Sprinkler.ordinal()) {
                return new GuiSprinkler(new ContainerSprinkler((IInventory)player.field_71071_by, (TileEntitySprinkler)tile));
            }
        }
        return null;
    }

    @ForgeSubscribe
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.world != null && event.world.field_72995_K && event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            Calendar cal = Calendar.getInstance();
            if (cal.get(2) == 7 && cal.get(5) == 16) {
                player.func_70006_a("Happy Birthday Mikee!! :)");
            }
        }
    }

    @Override
    public File getWorldDir(World world) {
        return new File(OpenBlocks.getBaseDir(), "saves/" + world.func_72860_G().func_75760_g());
    }

    @Override
    public boolean isServer() {
        return false;
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public void spawnLiquidSpray(World worldObj, LiquidStack water, double x, double y, double z, ForgeDirection direction, float angleRadians, float spread) {
        FXLiquidSpray spray = new FXLiquidSpray(worldObj, water, x, y, z, direction, angleRadians, spread);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)spray);
    }
}

