/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import twilightforest.TFFeature;
import twilightforest.TFFeatureCache;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.world.GenLayerTF;

public class TFWorldChunkManager
extends WorldChunkManager {
    private GenLayer myGenBiomes;
    private GenLayer myBiomeIndexLayer;
    private BiomeCache myBiomeCache = new BiomeCache((WorldChunkManager)this);
    private TFFeatureCache featureCache;
    private List myBiomesToSpawnIn = new ArrayList();

    protected TFWorldChunkManager() {
        this.myBiomesToSpawnIn.add(TFBiomeBase.twilightForest);
        this.myBiomesToSpawnIn.add(TFBiomeBase.twilightForest2);
        this.myBiomesToSpawnIn.add(TFBiomeBase.clearing);
        this.myBiomesToSpawnIn.add(TFBiomeBase.swamp);
        this.myBiomesToSpawnIn.add(TFBiomeBase.mushrooms);
        this.featureCache = new TFFeatureCache(this);
    }

    public TFWorldChunkManager(long par1, WorldType par3WorldType) {
        this();
        GenLayer[] agenlayer = GenLayerTF.makeTheWorld(par1);
        this.myGenBiomes = agenlayer[0];
        this.myBiomeIndexLayer = agenlayer[1];
    }

    public TFWorldChunkManager(World par1World) {
        this(par1World.func_72905_C(), par1World.func_72912_H().func_76067_t());
    }

    public List func_76932_a() {
        return this.myBiomesToSpawnIn;
    }

    public BiomeGenBase func_76935_a(int par1, int par2) {
        BiomeGenBase biome = this.myBiomeCache.func_76837_b(par1, par2);
        if (biome == null) {
            return TFBiomeBase.twilightForest;
        }
        return biome;
    }

    public float[] func_76936_a(float[] par1ArrayOfFloat, int par2, int par3, int par4, int par5) {
        IntCache.func_76446_a();
        if (par1ArrayOfFloat == null || par1ArrayOfFloat.length < par4 * par5) {
            par1ArrayOfFloat = new float[par4 * par5];
        }
        int[] ai = this.myBiomeIndexLayer.func_75904_a(par2, par3, par4, par5);
        for (int i = 0; i < par4 * par5; ++i) {
            if (ai[i] < 0 || BiomeGenBase.field_76773_a[ai[i]] == null) continue;
            float f = (float)BiomeGenBase.field_76773_a[ai[i]].func_76744_g() / 65536.0f;
            if (f > 1.0f) {
                f = 1.0f;
            }
            par1ArrayOfFloat[i] = f;
        }
        return par1ArrayOfFloat;
    }

    public float func_76939_a(float par1, int par2) {
        return par1;
    }

    public float[] func_76934_b(float[] par1ArrayOfFloat, int par2, int par3, int par4, int par5) {
        IntCache.func_76446_a();
        if (par1ArrayOfFloat == null || par1ArrayOfFloat.length < par4 * par5) {
            par1ArrayOfFloat = new float[par4 * par5];
        }
        int[] var6 = this.myBiomeIndexLayer.func_75904_a(par2, par3, par4, par5);
        for (int var7 = 0; var7 < par4 * par5; ++var7) {
            float floatTemp = var6[var7] >= 0 && BiomeGenBase.field_76773_a[var6[var7]] != null ? (float)BiomeGenBase.field_76773_a[var6[var7]].func_76734_h() / 65536.0f : 0.5f;
            if (floatTemp > 1.0f) {
                floatTemp = 1.0f;
            }
            par1ArrayOfFloat[var7] = floatTemp;
        }
        return par1ArrayOfFloat;
    }

    public BiomeGenBase[] func_76937_a(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5) {
        IntCache.func_76446_a();
        if (par1ArrayOfBiomeGenBase == null || par1ArrayOfBiomeGenBase.length < par4 * par5) {
            par1ArrayOfBiomeGenBase = new BiomeGenBase[par4 * par5];
        }
        int[] ai = this.myGenBiomes.func_75904_a(par2, par3, par4, par5);
        for (int i = 0; i < par4 * par5; ++i) {
            par1ArrayOfBiomeGenBase[i] = ai[i] >= 0 ? BiomeGenBase.field_76773_a[ai[i]] : TFBiomeBase.twilightForest;
        }
        return par1ArrayOfBiomeGenBase;
    }

    public BiomeGenBase[] func_76933_b(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5) {
        return this.func_76931_a(par1ArrayOfBiomeGenBase, par2, par3, par4, par5, true);
    }

    public BiomeGenBase[] func_76931_a(BiomeGenBase[] par1ArrayOfBiomeGenBase, int x, int y, int width, int length, boolean cacheFlag) {
        IntCache.func_76446_a();
        if (par1ArrayOfBiomeGenBase == null || par1ArrayOfBiomeGenBase.length < width * length) {
            par1ArrayOfBiomeGenBase = new BiomeGenBase[width * length];
        }
        if (cacheFlag && width == 16 && length == 16 && (x & 0xF) == 0 && (y & 0xF) == 0) {
            BiomeGenBase[] abiomegenbase = this.myBiomeCache.func_76839_e(x, y);
            System.arraycopy(abiomegenbase, 0, par1ArrayOfBiomeGenBase, 0, width * length);
            return par1ArrayOfBiomeGenBase;
        }
        int[] ai = this.myBiomeIndexLayer.func_75904_a(x, y, width, length);
        for (int i = 0; i < width * length; ++i) {
            par1ArrayOfBiomeGenBase[i] = ai[i] >= 0 ? BiomeGenBase.field_76773_a[ai[i]] : TFBiomeBase.twilightForest;
        }
        return par1ArrayOfBiomeGenBase;
    }

    public boolean func_76940_a(int par1, int par2, int par3, List par4List) {
        int i = par1 - par3 >> 2;
        int j = par2 - par3 >> 2;
        int k = par1 + par3 >> 2;
        int l = par2 + par3 >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        int[] ai = this.myGenBiomes.func_75904_a(i, j, i1, j1);
        for (int k1 = 0; k1 < i1 * j1; ++k1) {
            BiomeGenBase biomegenbase = BiomeGenBase.field_76773_a[ai[k1]];
            if (par4List.contains(biomegenbase)) continue;
            return false;
        }
        return true;
    }

    public ChunkPosition func_76941_a(int par1, int par2, int par3, List par4List, Random par5Random) {
        int i = par1 - par3 >> 2;
        int j = par2 - par3 >> 2;
        int k = par1 + par3 >> 2;
        int l = par2 + par3 >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        int[] ai = this.myGenBiomes.func_75904_a(i, j, i1, j1);
        ChunkPosition chunkposition = null;
        int k1 = 0;
        for (int l1 = 0; l1 < ai.length; ++l1) {
            int i2 = i + l1 % i1 << 2;
            int j2 = j + l1 / i1 << 2;
            BiomeGenBase biomegenbase = BiomeGenBase.field_76773_a[ai[l1]];
            if (!par4List.contains(biomegenbase) || chunkposition != null && par5Random.nextInt(k1 + 1) != 0) continue;
            chunkposition = new ChunkPosition(i2, 0, j2);
            ++k1;
        }
        return chunkposition;
    }

    public void func_76938_b() {
        this.myBiomeCache.func_76838_a();
    }

    public int getFeatureID(int mapX, int mapZ, World world) {
        return this.getFeatureIDNoCache(mapX, mapZ, world);
    }

    public int getFeatureIDNoCache(int mapX, int mapZ, World world) {
        return this.getFeatureNoCache((int)mapX, (int)mapZ, (World)world).featureID;
    }

    public TFFeature getFeatureAt(int mapX, int mapZ, World world) {
        return this.getFeatureNoCache(mapX, mapZ, world);
    }

    public TFFeature getFeatureNoCache(int mapX, int mapZ, World world) {
        return TFFeature.generateFeatureFor(mapX >> 4, mapZ >> 4, world);
    }

    public boolean isInFeatureChunk(int mapX, int mapZ) {
        int chunkX = mapX >> 4;
        int chunkZ = mapZ >> 4;
        return chunkX % 16 == 0 && chunkZ % 16 == 0;
    }
}

