/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import twilightforest.block.TFBlocks;
import twilightforest.world.TFTreeGenerator;
import twilightforest.world.TFWorld;

public class TFGenDarkCanopyTree
extends TFTreeGenerator {
    public TFGenDarkCanopyTree() {
        this(false);
    }

    public TFGenDarkCanopyTree(boolean par1) {
        super(par1);
        this.treeBlock = TFBlocks.log.field_71990_ca;
        this.treeMeta = 3;
        this.branchMeta = 15;
        this.leafBlock = TFBlocks.hedge.field_71990_ca;
        this.leafMeta = 1;
        this.rootBlock = TFBlocks.root.field_71990_ca;
        this.rootMeta = 0;
    }

    @Override
    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        boolean foundDirt = false;
        for (int dy = y; dy >= TFWorld.SEALEVEL; --dy) {
            Material materialUnder = world.func_72803_f(x, dy - 1, z);
            if (materialUnder == Material.field_76247_b || materialUnder == Material.field_76248_c) {
                foundDirt = true;
                y = dy;
                break;
            }
            if (materialUnder == Material.field_76246_e || materialUnder == Material.field_76251_o) break;
        }
        if (!foundDirt) {
            return false;
        }
        if (world.func_72803_f(x + 1, y, z + 0) == Material.field_76245_d || world.func_72803_f(x - 1, y, z + 0) == Material.field_76245_d || world.func_72803_f(x + 0, y, z + 1) == Material.field_76245_d || world.func_72803_f(x + 0, y, z - 1) == Material.field_76245_d) {
            return false;
        }
        int treeHeight = 4 + random.nextInt(3);
        this.drawBresehnam(world, x, y, z, x, y + treeHeight, z, this.treeBlock, this.treeMeta, true);
        int numBranches = 4;
        double offset = random.nextFloat();
        for (int b = 0; b < numBranches; ++b) {
            this.buildBranch(world, x, y, z, treeHeight - numBranches + b / 2, 8.0, 0.23 * (double)b + offset, 0.23, random);
        }
        if (this.hasAirAround((IBlockAccess)world, x, y - 1, z)) {
            this.func_76485_a(world, x, y - 1, z, this.treeBlock, this.treeMeta);
        } else {
            this.func_76485_a(world, x, y - 1, z, this.rootBlock, this.rootMeta);
        }
        int numRoots = 3 + random.nextInt(2);
        offset = random.nextDouble();
        for (int b = 0; b < numRoots; ++b) {
            this.buildRoot(world, x, y, z, offset, b);
        }
        return true;
    }

    void buildBranch(World world, int x, int y, int z, int height, double length, double angle, double tilt, Random random) {
        int[] src = new int[]{x, y + height, z};
        int[] dest = TFGenDarkCanopyTree.translate(src[0], src[1], src[2], length, angle, tilt);
        this.drawBresehnam(world, src[0], src[1], src[2], dest[0], dest[1], dest[2], this.treeBlock, this.branchMeta, true);
        int leafSize = 4;
        if (random.nextInt(3) == 0) {
            leafSize = (byte)(leafSize + (random.nextInt(3) - 1));
        }
        if (world.func_72798_a(dest[0], dest[1] - 1, dest[2]) == 0 || world.func_72798_a(dest[0], dest[1] + 1, dest[2]) == 0 || world.func_72798_a(dest[0] + 4, dest[1], dest[2]) == 0 || world.func_72798_a(dest[0] - 4, dest[1], dest[2]) == 0 || world.func_72798_a(dest[0], dest[1], dest[2] + 4) == 0 || world.func_72798_a(dest[0], dest[1], dest[2] - 4) == 0) {
            this.drawCircle(world, dest[0], dest[1] - 1, dest[2], leafSize, this.leafBlock, this.leafMeta, false);
            this.drawCircle(world, dest[0], dest[1], dest[2], leafSize + 1, this.leafBlock, this.leafMeta, false);
            this.drawCircle(world, dest[0], dest[1] + 1, dest[2], leafSize, this.leafBlock, this.leafMeta, false);
            this.drawCircle(world, dest[0], dest[1] + 2, dest[2], leafSize - 2, this.leafBlock, this.leafMeta, false);
        }
    }

    void nullifySkyLightUnderBranch(World world, int sx, int sy, int sz, int rad) {
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            for (int dz = 0; dz <= rad; dz = (int)((byte)(dz + 1))) {
                int dist = Math.max(dx, dz) + (Math.min(dx, dz) >> 1);
                if (dist > rad) continue;
                this.nullifySkyLightColumn(world, sx + dx, sy, sz + dz);
                this.nullifySkyLightColumn(world, sx + dx, sy, sz - dz);
                this.nullifySkyLightColumn(world, sx - dx, sy, sz + dz);
                this.nullifySkyLightColumn(world, sx - dx, sy, sz - dz);
            }
        }
    }

    void nullifySkyLightColumn(World world, int dx, int dy, int dz) {
        for (int y = dy; y >= 0; --y) {
            world.func_72915_b(EnumSkyBlock.Sky, dx, y, dz, 0);
        }
    }
}

