/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import twilightforest.block.TFBlocks;
import twilightforest.world.TFGenerator;

public class TFGenCanopyMushroom
extends TFGenerator {
    private int treeBlock;
    private int treeMeta = 10;
    private int branchMeta = 15;
    private int leafBlock;
    private int leafMeta = 5;

    @Override
    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        int blockUnder;
        int treeHeight = 12;
        if (random.nextInt(3) == 0) {
            treeHeight += random.nextInt(5);
            if (random.nextInt(8) == 0) {
                treeHeight += random.nextInt(5);
            }
        }
        if ((blockUnder = world.func_72798_a(x, y - 1, z)) != Block.field_71980_u.field_71990_ca && blockUnder != Block.field_71979_v.field_71990_ca && blockUnder != Block.field_71994_by.field_71990_ca || y >= 256 - treeHeight - 1) {
            return false;
        }
        this.leafBlock = this.treeBlock = random.nextInt(3) == 0 ? Block.field_72001_bo.field_71990_ca : Block.field_72000_bn.field_71990_ca;
        this.buildBranch(world, x, y, z, 0, treeHeight, 0.0, 0.0, true, random);
        int numBranches = 3 + random.nextInt(2);
        double offset = random.nextDouble();
        for (int b = 0; b < numBranches; ++b) {
            this.buildBranch(world, x, y, z, treeHeight - 5 + b, 9.0, 0.3 * (double)b + offset, 0.2, false, random);
        }
        return true;
    }

    void buildBranch(World world, int x, int y, int z, int height, double length, double angle, double tilt, boolean trunk, Random treeRNG) {
        int[] src = new int[]{x, y + height, z};
        int[] dest = TFGenCanopyMushroom.translate(src[0], src[1], src[2], length, angle, tilt);
        if (src[0] != dest[0] || src[2] != dest[2]) {
            this.drawBresehnam(world, src[0], src[1], src[2], dest[0], src[1], dest[2], this.treeBlock, this.branchMeta, true);
            this.drawBresehnam(world, dest[0], src[1] + 1, dest[2], dest[0], dest[1] - 1, dest[2], this.treeBlock, this.treeMeta, true);
        } else {
            this.drawBresehnam(world, src[0], src[1], src[2], dest[0], dest[1] - 1, dest[2], this.treeBlock, this.treeMeta, true);
        }
        if (trunk) {
            this.addFirefly(world, x, y, z, 3 + treeRNG.nextInt(7), treeRNG.nextDouble());
        }
        this.drawMushroomCircle(world, dest[0], dest[1], dest[2], 4, this.leafBlock, true);
    }

    public void drawMushroomCircle(World world, int sx, int sy, int sz, int rad, int blockValue, boolean priority) {
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            for (int dz = 0; dz <= rad; dz = (int)((byte)(dz + 1))) {
                int dist = (int)((double)Math.max(dx, dz) + (double)Math.min(dx, dz) * 0.5);
                if (dx == 3 && dz == 3) {
                    dist = 6;
                }
                if (dx == 0) {
                    if (dz < rad) {
                        this.putBlockAndMetadata(world, sx + 0, sy, sz + dz, blockValue, 5, priority);
                        this.putBlockAndMetadata(world, sx + 0, sy, sz - dz, blockValue, 5, priority);
                        continue;
                    }
                    this.putBlockAndMetadata(world, sx + 0, sy, sz + dz, blockValue, 8, priority);
                    this.putBlockAndMetadata(world, sx + 0, sy, sz - dz, blockValue, 2, priority);
                    continue;
                }
                if (dz == 0) {
                    if (dx < rad) {
                        this.putBlockAndMetadata(world, sx + dx, sy, sz + 0, blockValue, 5, priority);
                        this.putBlockAndMetadata(world, sx - dx, sy, sz + 0, blockValue, 5, priority);
                        continue;
                    }
                    this.putBlockAndMetadata(world, sx + dx, sy, sz + 0, blockValue, 6, priority);
                    this.putBlockAndMetadata(world, sx - dx, sy, sz + 0, blockValue, 4, priority);
                    continue;
                }
                if (dist < rad) {
                    this.putBlockAndMetadata(world, sx + dx, sy, sz + dz, blockValue, 5, priority);
                    this.putBlockAndMetadata(world, sx + dx, sy, sz - dz, blockValue, 5, priority);
                    this.putBlockAndMetadata(world, sx - dx, sy, sz + dz, blockValue, 5, priority);
                    this.putBlockAndMetadata(world, sx - dx, sy, sz - dz, blockValue, 5, priority);
                    continue;
                }
                if (dist != rad) continue;
                this.putBlockAndMetadata(world, sx + dx, sy, sz + dz, blockValue, 9, priority);
                this.putBlockAndMetadata(world, sx + dx, sy, sz - dz, blockValue, 3, priority);
                this.putBlockAndMetadata(world, sx - dx, sy, sz + dz, blockValue, 7, priority);
                this.putBlockAndMetadata(world, sx - dx, sy, sz - dz, blockValue, 1, priority);
            }
        }
    }

    private void addFirefly(World world, int x, int y, int z, int height, double angle) {
        int iAngle = (int)(angle * 4.0);
        if (iAngle == 0) {
            this.putBlockAndMetadata(world, x + 1, y + height, z, TFBlocks.firefly.field_71990_ca, 0, false);
        } else if (iAngle == 1) {
            this.putBlockAndMetadata(world, x - 1, y + height, z, TFBlocks.firefly.field_71990_ca, 0, false);
        } else if (iAngle == 2) {
            this.putBlockAndMetadata(world, x, y + height, z + 1, TFBlocks.firefly.field_71990_ca, 0, false);
        } else if (iAngle == 3) {
            this.putBlockAndMetadata(world, x, y + height, z - 1, TFBlocks.firefly.field_71990_ca, 0, false);
        }
    }
}

