/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import twilightforest.biomes.TFBiomeBase;

public class GenLayerTFStream
extends GenLayer {
    public GenLayerTFStream(long l, GenLayer genlayer) {
        super(l);
        this.field_75909_a = genlayer;
    }

    public int[] func_75904_a(int x, int z, int width, int depth) {
        int nx = x - 1;
        int nz = z - 1;
        int nwidth = width + 2;
        int ndepth = depth + 2;
        int[] input = this.field_75909_a.func_75904_a(nx, nz, nwidth, ndepth);
        int[] output = IntCache.func_76445_a((int)(width * depth));
        for (int dz = 0; dz < depth; ++dz) {
            for (int dx = 0; dx < width; ++dx) {
                int mid = input[dx + 1 + (dz + 1) * nwidth];
                int left = input[dx + 0 + (dz + 1) * nwidth];
                int down = input[dx + 1 + (dz + 0) * nwidth];
                int right = input[dx + 2 + (dz + 1) * nwidth];
                int up = input[dx + 1 + (dz + 2) * nwidth];
                output[dx + dz * width] = this.shouldStream(mid, left, down, right, up) ? TFBiomeBase.stream.field_76756_M : -1;
            }
        }
        return output;
    }

    boolean shouldStream(int mid, int left, int down, int right, int up) {
        if (this.shouldStream(mid, left)) {
            return true;
        }
        if (this.shouldStream(mid, right)) {
            return true;
        }
        if (this.shouldStream(mid, down)) {
            return true;
        }
        return this.shouldStream(mid, up);
    }

    boolean shouldStream(int biome1, int biome2) {
        if (biome1 == biome2) {
            return false;
        }
        if (biome1 == -biome2) {
            return false;
        }
        if (biome1 == TFBiomeBase.glacier.field_76756_M && biome2 == TFBiomeBase.snow.field_76756_M) {
            return false;
        }
        if (biome1 == TFBiomeBase.snow.field_76756_M && biome2 == TFBiomeBase.glacier.field_76756_M) {
            return false;
        }
        if (biome1 == TFBiomeBase.deepMushrooms.field_76756_M && biome2 == TFBiomeBase.mushrooms.field_76756_M) {
            return false;
        }
        if (biome1 == TFBiomeBase.mushrooms.field_76756_M && biome2 == TFBiomeBase.deepMushrooms.field_76756_M) {
            return false;
        }
        if (biome1 == TFBiomeBase.swamp.field_76756_M && biome2 == TFBiomeBase.fireSwamp.field_76756_M) {
            return false;
        }
        if (biome1 == TFBiomeBase.fireSwamp.field_76756_M && biome2 == TFBiomeBase.swamp.field_76756_M) {
            return false;
        }
        if (biome1 == TFBiomeBase.tfLake.field_76756_M || biome2 == TFBiomeBase.tfLake.field_76756_M) {
            return false;
        }
        if (biome1 == TFBiomeBase.clearing.field_76756_M || biome2 == TFBiomeBase.clearing.field_76756_M) {
            return false;
        }
        return !TFBiomeBase.isFeature(biome1) && !TFBiomeBase.isFeature(biome2);
    }
}

