/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructurePieceBlockSelector;
import twilightforest.TFTreasure;
import twilightforest.structures.StructureTFDecorator;
import twilightforest.structures.StructureTFStrongholdStones;
import twilightforest.structures.StructureTFTowerWoods;

public abstract class StructureTFComponent
extends StructureComponent {
    private static final StructureTFStrongholdStones strongholdStones = new StructureTFStrongholdStones();
    private static final StructureTFTowerWoods towerWoods = new StructureTFTowerWoods();
    public StructureTFDecorator deco = null;
    public int spawnListIndex = 0;

    public StructureTFComponent(int i) {
        super(i);
    }

    public static StructureBoundingBox getComponentToAddBoundingBox(int x, int y, int z, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int dir) {
        switch (dir) {
            default: {
                return new StructureBoundingBox(x + minX, y + minY, z + minZ, x + maxX + minX, y + maxY + minY, z + maxZ + minZ);
            }
            case 0: {
                return new StructureBoundingBox(x + minX, y + minY, z + minZ, x + maxX + minX, y + maxY + minY, z + maxZ + minZ);
            }
            case 1: {
                return new StructureBoundingBox(x - maxZ + minZ, y + minY, z + minX, x + minZ, y + maxY + minY, z + maxX + minX);
            }
            case 2: {
                return new StructureBoundingBox(x - maxX - minX, y + minY, z - maxZ - minZ, x - minX, y + maxY + minY, z - minZ);
            }
            case 3: 
        }
        return new StructureBoundingBox(x + minZ, y + minY, z - maxX, x + maxZ + minZ, y + maxY + minY, z + minX);
    }

    protected TileEntityMobSpawner placeSpawnerAtCurrentPosition(World world, Random rand, int x, int y, int z, String monsterID, StructureBoundingBox sbb) {
        int dz;
        int dy;
        TileEntityMobSpawner tileEntitySpawner = null;
        int dx = this.func_74865_a(x, z);
        if (sbb.func_78890_b(dx, dy = this.func_74862_a(y), dz = this.func_74873_b(x, z)) && world.func_72798_a(dx, dy, dz) != Block.field_72065_as.field_71990_ca) {
            world.func_72832_d(dx, dy, dz, Block.field_72065_as.field_71990_ca, 0, 2);
            tileEntitySpawner = (TileEntityMobSpawner)world.func_72796_p(dx, dy, dz);
            if (tileEntitySpawner != null) {
                tileEntitySpawner.func_98049_a().func_98272_a(monsterID);
            }
        }
        return tileEntitySpawner;
    }

    protected TileEntityMobSpawner placeSpawnerRotated(World world, int x, int y, int z, int rotation, String monsterID, StructureBoundingBox sbb) {
        int dz;
        int dy;
        TileEntityMobSpawner tileEntitySpawner = null;
        int dx = this.getXWithOffsetAsIfRotated(x, z, rotation);
        if (sbb.func_78890_b(dx, dy = this.func_74862_a(y), dz = this.getZWithOffsetAsIfRotated(x, z, rotation)) && world.func_72798_a(dx, dy, dz) != Block.field_72065_as.field_71990_ca) {
            world.func_72832_d(dx, dy, dz, Block.field_72065_as.field_71990_ca, 0, 2);
            tileEntitySpawner = (TileEntityMobSpawner)world.func_72796_p(dx, dy, dz);
            if (tileEntitySpawner != null) {
                tileEntitySpawner.func_98049_a().func_98272_a(monsterID);
            }
        }
        return tileEntitySpawner;
    }

    protected void placeTreasureAtCurrentPosition(World world, Random rand, int x, int y, int z, TFTreasure treasureType, StructureBoundingBox sbb) {
        this.placeTreasureAtCurrentPosition(world, rand, x, y, z, treasureType, false, sbb);
    }

    protected void placeTreasureAtCurrentPosition(World world, Random rand, int x, int y, int z, TFTreasure treasureType, boolean trapped, StructureBoundingBox sbb) {
        int dz;
        int dy;
        int dx = this.func_74865_a(x, z);
        if (sbb.func_78890_b(dx, dy = this.func_74862_a(y), dz = this.func_74873_b(x, z)) && world.func_72798_a(dx, dy, dz) != Block.field_72077_au.field_71990_ca) {
            treasureType.generate(world, rand, dx, dy, dz, trapped ? Block.field_94347_ck.field_71990_ca : Block.field_72077_au.field_71990_ca);
        }
    }

    protected void placeTreasureRotated(World world, int x, int y, int z, int rotation, TFTreasure treasureType, StructureBoundingBox sbb) {
        this.placeTreasureRotated(world, x, y, z, rotation, treasureType, false, sbb);
    }

    protected void placeTreasureRotated(World world, int x, int y, int z, int rotation, TFTreasure treasureType, boolean trapped, StructureBoundingBox sbb) {
        int dz;
        int dy;
        int dx = this.getXWithOffsetAsIfRotated(x, z, rotation);
        if (sbb.func_78890_b(dx, dy = this.func_74862_a(y), dz = this.getZWithOffsetAsIfRotated(x, z, rotation)) && world.func_72798_a(dx, dy, dz) != Block.field_72077_au.field_71990_ca) {
            treasureType.generate(world, null, dx, dy, dz, trapped ? Block.field_94347_ck.field_71990_ca : Block.field_72077_au.field_71990_ca);
        }
    }

    protected int[] offsetTowerCoords(int x, int y, int z, int towerSize, int direction) {
        int dx = this.func_74865_a(x, z);
        int dy = this.func_74862_a(y);
        int dz = this.func_74873_b(x, z);
        if (direction == 0) {
            return new int[]{dx + 1, dy - 1, dz - towerSize / 2};
        }
        if (direction == 1) {
            return new int[]{dx + towerSize / 2, dy - 1, dz + 1};
        }
        if (direction == 2) {
            return new int[]{dx - 1, dy - 1, dz + towerSize / 2};
        }
        if (direction == 3) {
            return new int[]{dx - towerSize / 2, dy - 1, dz - 1};
        }
        return new int[]{x, y, z};
    }

    public int[] getOffsetAsIfRotated(int[] src, int rotation) {
        int temp = this.getCoordBaseMode();
        int[] dest = new int[3];
        this.setCoordBaseMode(rotation);
        dest[0] = this.func_74865_a(src[0], src[2]);
        dest[1] = this.func_74862_a(src[1]);
        dest[2] = this.func_74873_b(src[0], src[2]);
        this.setCoordBaseMode(temp);
        return dest;
    }

    protected int func_74865_a(int x, int z) {
        switch (this.getCoordBaseMode()) {
            case 0: {
                return this.field_74887_e.field_78897_a + x;
            }
            case 1: {
                return this.field_74887_e.field_78893_d - z;
            }
            case 2: {
                return this.field_74887_e.field_78893_d - x;
            }
            case 3: {
                return this.field_74887_e.field_78897_a + z;
            }
        }
        return x;
    }

    protected int func_74862_a(int par1) {
        return super.func_74862_a(par1);
    }

    protected int func_74873_b(int x, int z) {
        switch (this.getCoordBaseMode()) {
            case 0: {
                return this.field_74887_e.field_78896_c + z;
            }
            case 1: {
                return this.field_74887_e.field_78896_c + x;
            }
            case 2: {
                return this.field_74887_e.field_78892_f - z;
            }
            case 3: {
                return this.field_74887_e.field_78892_f - x;
            }
        }
        return z;
    }

    protected int getXWithOffsetAsIfRotated(int x, int z, int rotation) {
        if (this.field_74885_f < 0) {
            return x;
        }
        switch ((this.field_74885_f + rotation) % 4) {
            case 0: {
                return this.field_74887_e.field_78897_a + x;
            }
            case 1: {
                return this.field_74887_e.field_78893_d - z;
            }
            case 2: {
                return this.field_74887_e.field_78893_d - x;
            }
            case 3: {
                return this.field_74887_e.field_78897_a + z;
            }
        }
        return x;
    }

    protected int getZWithOffsetAsIfRotated(int x, int z, int rotation) {
        if (this.field_74885_f < 0) {
            return x;
        }
        switch ((this.field_74885_f + rotation) % 4) {
            case 0: {
                return this.field_74887_e.field_78896_c + z;
            }
            case 1: {
                return this.field_74887_e.field_78896_c + x;
            }
            case 2: {
                return this.field_74887_e.field_78892_f - z;
            }
            case 3: {
                return this.field_74887_e.field_78892_f - x;
            }
        }
        return z;
    }

    public int getCoordBaseMode() {
        return this.field_74885_f;
    }

    public void setCoordBaseMode(int coordBaseMode) {
        this.field_74885_f = coordBaseMode;
    }

    protected int func_74866_a(World par1World, int par2, int par3, int par4, StructureBoundingBox par5StructureBoundingBox) {
        return super.func_74866_a(par1World, par2, par3, par4, par5StructureBoundingBox);
    }

    protected void func_74864_a(World par1World, int par2, int par3, int par4, int par5, int par6, StructureBoundingBox par7StructureBoundingBox) {
        super.func_74864_a(par1World, par2, par3, par4, par5, par6, par7StructureBoundingBox);
    }

    protected void placeBlockRotated(World world, int blockID, int meta, int x, int y, int z, int rotation, StructureBoundingBox sbb) {
        int dz;
        int dy;
        int dx = this.getXWithOffsetAsIfRotated(x, z, rotation);
        if (sbb.func_78890_b(dx, dy = this.func_74862_a(y), dz = this.getZWithOffsetAsIfRotated(x, z, rotation))) {
            world.func_72832_d(dx, dy, dz, blockID, meta, 2);
        }
    }

    protected int getBlockIDRotated(World world, int x, int y, int z, int rotation, StructureBoundingBox sbb) {
        int dz;
        int dy;
        int dx = this.getXWithOffsetAsIfRotated(x, z, rotation);
        if (sbb.func_78890_b(dx, dy = this.func_74862_a(y), dz = this.getZWithOffsetAsIfRotated(x, z, rotation))) {
            return world.func_72798_a(dx, dy, dz);
        }
        return 0;
    }

    protected void fillBlocksRotated(World world, StructureBoundingBox sbb, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int blockID, int meta, int rotation) {
        for (int dx = minY; dx <= maxY; ++dx) {
            for (int dy = minX; dy <= maxX; ++dy) {
                for (int dz = minZ; dz <= maxZ; ++dz) {
                    this.placeBlockRotated(world, blockID, meta, dy, dx, dz, rotation, sbb);
                }
            }
        }
    }

    protected void fillAirRotated(World world, StructureBoundingBox sbb, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int rotation) {
        this.fillBlocksRotated(world, sbb, minX, minY, minZ, maxX, maxY, maxZ, 0, 0, rotation);
    }

    public static StructurePieceBlockSelector getStrongholdStones() {
        return strongholdStones;
    }

    public static StructurePieceBlockSelector getTowerWoods() {
        return towerWoods;
    }

    protected int getStairMeta(int dir) {
        switch ((this.getCoordBaseMode() + dir) % 4) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 3;
            }
        }
        return -1;
    }

    protected int getLadderMeta(int ladderDir) {
        switch ((this.getCoordBaseMode() + ladderDir) % 4) {
            case 0: {
                return 4;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 3;
            }
        }
        return -1;
    }

    protected int getLadderMeta(int ladderDir, int rotation) {
        return this.getLadderMeta(ladderDir + rotation);
    }

    public void nullifySkyLightForBoundingBox(World world) {
        this.nullifySkyLight(world, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1, this.field_74887_e.field_78896_c - 1, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78894_e + 1, this.field_74887_e.field_78892_f + 1);
    }

    public void nullifySkyLightAtCurrentPosition(World world, int sx, int sy, int sz, int dx, int dy, int dz) {
        this.nullifySkyLight(world, this.func_74865_a(sx, sz), this.func_74862_a(sy), this.func_74873_b(sx, sz), this.func_74865_a(dx, dz), this.func_74862_a(dy), this.func_74873_b(dx, dz));
    }

    public void nullifySkyLight(World world, int sx, int sy, int sz, int dx, int dy, int dz) {
        for (int x = sx; x <= dx; ++x) {
            for (int z = sz; z <= dz; ++z) {
                for (int y = sy; y <= dy; ++y) {
                    world.func_72915_b(EnumSkyBlock.Sky, x, y, z, 0);
                }
            }
        }
    }
}

