/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import twilightforest.block.TFBlocks;
import twilightforest.structures.ComponentTFHollowTreeLargeBranch;
import twilightforest.structures.ComponentTFHollowTreeMedBranch;
import twilightforest.structures.ComponentTFHollowTreeSmallBranch;
import twilightforest.structures.ComponentTFLeafSphere;
import twilightforest.structures.StructureTFComponent;
import twilightforest.world.TFGenerator;

public class ComponentTFHollowTreeTrunk
extends StructureTFComponent {
    int radius;
    int height;

    public ComponentTFHollowTreeTrunk(World world, Random rand, int index, int x, int y, int z) {
        super(index);
        this.height = rand.nextInt(64) + 32;
        this.radius = rand.nextInt(4) + 1;
        this.setCoordBaseMode(0);
        this.field_74887_e = new StructureBoundingBox(x, y, z, x + this.radius * 2, y + this.height, z + this.radius * 2);
    }

    public void func_74861_a(StructureComponent structurecomponent, List list, Random rand) {
        int index = this.func_74877_c();
        ComponentTFLeafSphere leafBlob = new ComponentTFLeafSphere(index + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, 3);
        list.add(leafBlob);
        leafBlob.func_74861_a(this, list, rand);
        int numBranches = rand.nextInt(3) + 3;
        for (int i = 0; i <= numBranches; ++i) {
            int branchHeight = (int)((double)this.height * rand.nextDouble() * 0.9) + this.height / 10;
            double branchRotation = rand.nextDouble();
            this.makeMedBranch(list, rand, index + i + 1, branchHeight, 4, branchRotation, 0.35, true);
        }
        this.buildFullCrown(list, rand, index + numBranches + 1);
    }

    protected void buildFullCrown(List list, Random rand, int index) {
        int crownRadius = this.radius * 4 + 4;
        int bvar = this.radius + 2;
        index += this.buildBranchRing(list, rand, index, this.height - crownRadius, 0, crownRadius, 0, 0.35, 0.0, bvar, bvar + 2, 2, true);
        index += this.buildBranchRing(list, rand, index, this.height - crownRadius / 2, 0, crownRadius, 0, 0.28, 0.0, bvar, bvar + 2, 1, true);
        index += this.buildBranchRing(list, rand, index, this.height, 0, crownRadius, 0, 0.15, 0.0, 2, 5, 2, true);
        index += this.buildBranchRing(list, rand, index, this.height, 0, crownRadius / 2, 0, 0.05, 0.0, bvar, bvar + 2, 1, true);
    }

    protected int buildBranchRing(List list, Random rand, int index, int branchHeight, int heightVar, int length, int lengthVar, double tilt, double tiltVar, int minBranches, int maxBranches, int size, boolean leafy) {
        int numBranches = rand.nextInt(maxBranches - minBranches + 1) + minBranches;
        double branchRotation = 1.0 / (double)numBranches;
        double branchOffset = rand.nextDouble();
        for (int i = 0; i <= numBranches; ++i) {
            int dHeight = heightVar > 0 ? branchHeight - heightVar + rand.nextInt(2 * heightVar) : branchHeight;
            if (size == 2) {
                this.makeLargeBranch(list, rand, index, dHeight, length, (double)i * branchRotation + branchOffset, tilt, leafy);
                continue;
            }
            if (size == 1) {
                this.makeMedBranch(list, rand, index, dHeight, length, (double)i * branchRotation + branchOffset, tilt, leafy);
                continue;
            }
            if (size == 3) continue;
            this.makeSmallBranch(list, rand, index, dHeight, length, (double)i * branchRotation + branchOffset, tilt, leafy);
        }
        return numBranches;
    }

    public void makeSmallBranch(List list, Random rand, int index, int branchHeight, int branchLength, double branchRotation, double branchAngle, boolean leafy) {
        int[] bSrc = TFGenerator.translate(this.field_74887_e.field_78897_a + this.radius, this.field_74887_e.field_78895_b + branchHeight, this.field_74887_e.field_78896_c + this.radius, this.radius, branchRotation, 0.5);
        ComponentTFHollowTreeSmallBranch branch = new ComponentTFHollowTreeSmallBranch(index, bSrc[0], bSrc[1], bSrc[2], branchLength, branchRotation, branchAngle, leafy);
        list.add(branch);
        branch.func_74861_a(this, list, rand);
    }

    public void makeMedBranch(List list, Random rand, int index, int branchHeight, int branchLength, double branchRotation, double branchAngle, boolean leafy) {
        int[] bSrc = TFGenerator.translate(this.field_74887_e.field_78897_a + this.radius, this.field_74887_e.field_78895_b + branchHeight, this.field_74887_e.field_78896_c + this.radius, this.radius, branchRotation, 0.5);
        ComponentTFHollowTreeMedBranch branch = new ComponentTFHollowTreeMedBranch(index, bSrc[0], bSrc[1], bSrc[2], branchLength, branchRotation, branchAngle, leafy);
        list.add(branch);
        branch.func_74861_a(this, list, rand);
    }

    public void makeLargeBranch(List list, Random rand, int index, int branchHeight, int branchLength, double branchRotation, double branchAngle, boolean leafy) {
        int[] bSrc = TFGenerator.translate(this.field_74887_e.field_78897_a + this.radius, this.field_74887_e.field_78895_b + branchHeight, this.field_74887_e.field_78896_c + this.radius, this.radius, branchRotation, 0.5);
        ComponentTFHollowTreeLargeBranch branch = new ComponentTFHollowTreeLargeBranch(index, bSrc[0], bSrc[1], bSrc[2], branchLength, branchRotation, branchAngle, leafy);
        list.add(branch);
        branch.func_74861_a(this, list, rand);
    }

    public boolean func_74875_a(World world, Random random, StructureBoundingBox sbb) {
        int hollow = this.radius / 2;
        for (int dx = 0; dx <= 2 * this.radius; ++dx) {
            for (int dz = 0; dz <= 2 * this.radius; ++dz) {
                for (int dy = 0; dy <= this.height; ++dy) {
                    int az;
                    int ax = Math.abs(dx - this.radius);
                    int dist = (int)((double)Math.max(ax, az = Math.abs(dz - this.radius)) + (double)Math.min(ax, az) * 0.5);
                    if (dist <= this.radius && dist > hollow) {
                        this.func_74864_a(world, TFBlocks.log.field_71990_ca, 0, dx, dy, dz, sbb);
                    }
                    if (dist != hollow || dx != hollow + this.radius) continue;
                    this.func_74864_a(world, Block.field_72055_aF.field_71990_ca, 4, dx, dy, dz, sbb);
                }
            }
        }
        return true;
    }
}

