/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures;

import java.util.List;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import twilightforest.block.TFBlocks;
import twilightforest.structures.ComponentTFHollowTreeSmallBranch;
import twilightforest.structures.ComponentTFLeafSphere;
import twilightforest.structures.StructureTFComponent;
import twilightforest.world.TFGenerator;

public class ComponentTFHollowTreeMedBranch
extends StructureTFComponent {
    int[] src;
    int[] dest;
    double length;
    double angle;
    double tilt;
    boolean leafy;

    protected ComponentTFHollowTreeMedBranch(int i, int sx, int sy, int sz, double length, double angle, double tilt, boolean leafy) {
        super(i);
        this.src = new int[]{sx, sy, sz};
        this.dest = TFGenerator.translate(this.src[0], this.src[1], this.src[2], length, angle, tilt);
        this.length = length;
        this.angle = angle;
        this.tilt = tilt;
        this.leafy = leafy;
        this.setCoordBaseMode(0);
        this.field_74887_e = new StructureBoundingBox(Math.min(this.src[0], this.dest[0]), Math.min(this.src[1], this.dest[1]), Math.min(this.src[2], this.dest[2]), Math.max(this.src[0], this.dest[0]), Math.max(this.src[1], this.dest[1]), Math.max(this.src[2], this.dest[2]));
    }

    public void func_74861_a(StructureComponent structurecomponent, List list, Random rand) {
        int index = this.func_74877_c();
        if (this.leafy) {
            int numLeafBalls = Math.min(rand.nextInt(3) + 1, (int)(this.length / 5.0));
            for (int i = 0; i < numLeafBalls; ++i) {
                double slength = (rand.nextDouble() * 0.6 + 0.2) * this.length;
                int[] bdst = TFGenerator.translate(this.src[0], this.src[1], this.src[2], slength, this.angle, this.tilt);
                ComponentTFLeafSphere leafBlob = new ComponentTFLeafSphere(index + 1, bdst[0], bdst[1], bdst[2], 2);
                list.add(leafBlob);
                leafBlob.func_74861_a(this, list, rand);
            }
            ComponentTFLeafSphere leafBlob = new ComponentTFLeafSphere(index + 1, this.dest[0], this.dest[1], this.dest[2], 2);
            list.add(leafBlob);
            leafBlob.func_74861_a(this, list, rand);
        }
        int numShoots = Math.min(rand.nextInt(3) + 1, (int)(this.length / 5.0));
        double angleInc = 0.8 / (double)numShoots;
        for (int i = 0; i < numShoots; ++i) {
            double angleVar = angleInc * (double)i - 0.4;
            double outVar = rand.nextDouble() * 0.8 + 0.2;
            double tiltVar = rand.nextDouble() * 0.75 + 0.15;
            int[] bsrc = TFGenerator.translate(this.src[0], this.src[1], this.src[2], this.length * outVar, this.angle, this.tilt);
            double slength = this.length * 0.4;
            this.makeSmallBranch(list, rand, index + 1, bsrc[0], bsrc[1], bsrc[2], slength, this.angle + angleVar, this.tilt * tiltVar, this.leafy);
        }
    }

    public void makeSmallBranch(List list, Random rand, int index, int x, int y, int z, double branchLength, double branchRotation, double branchAngle, boolean leafy) {
        ComponentTFHollowTreeSmallBranch branch = new ComponentTFHollowTreeSmallBranch(index, x, y, z, branchLength, branchRotation, branchAngle, leafy);
        list.add(branch);
        branch.func_74861_a(this, list, rand);
    }

    public boolean func_74875_a(World world, Random random, StructureBoundingBox sbb) {
        int[] rSrc = new int[]{this.src[0] - this.field_74887_e.field_78897_a, this.src[1] - this.field_74887_e.field_78895_b, this.src[2] - this.field_74887_e.field_78896_c};
        int[] rDest = new int[]{this.dest[0] - this.field_74887_e.field_78897_a, this.dest[1] - this.field_74887_e.field_78895_b, this.dest[2] - this.field_74887_e.field_78896_c};
        this.drawBresehnam(world, sbb, rSrc[0], rSrc[1], rSrc[2], rDest[0], rDest[1], rDest[2], TFBlocks.log.field_71990_ca, 0);
        return true;
    }

    protected void drawBresehnam(World world, StructureBoundingBox sbb, int x1, int y1, int z1, int x2, int y2, int z2, int blockValue, int metaValue) {
        int[] pixel = new int[]{x1, y1, z1};
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        int x_inc = dx < 0 ? -1 : 1;
        int l = Math.abs(dx);
        int y_inc = dy < 0 ? -1 : 1;
        int m = Math.abs(dy);
        int z_inc = dz < 0 ? -1 : 1;
        int n = Math.abs(dz);
        int dx2 = l << 1;
        int dy2 = m << 1;
        int dz2 = n << 1;
        if (l >= m && l >= n) {
            int err_1 = dy2 - l;
            int err_2 = dz2 - l;
            for (int i = 0; i < l; ++i) {
                this.func_74864_a(world, blockValue, metaValue, pixel[0], pixel[1], pixel[2], sbb);
                if (err_1 > 0) {
                    pixel[1] = pixel[1] + y_inc;
                    err_1 -= dx2;
                }
                if (err_2 > 0) {
                    pixel[2] = pixel[2] + z_inc;
                    err_2 -= dx2;
                }
                err_1 += dy2;
                err_2 += dz2;
                pixel[0] = pixel[0] + x_inc;
            }
        } else if (m >= l && m >= n) {
            int err_1 = dx2 - m;
            int err_2 = dz2 - m;
            for (int i = 0; i < m; ++i) {
                this.func_74864_a(world, blockValue, metaValue, pixel[0], pixel[1], pixel[2], sbb);
                if (err_1 > 0) {
                    pixel[0] = pixel[0] + x_inc;
                    err_1 -= dy2;
                }
                if (err_2 > 0) {
                    pixel[2] = pixel[2] + z_inc;
                    err_2 -= dy2;
                }
                err_1 += dx2;
                err_2 += dz2;
                pixel[1] = pixel[1] + y_inc;
            }
        } else {
            int err_1 = dy2 - n;
            int err_2 = dx2 - n;
            for (int i = 0; i < n; ++i) {
                this.func_74864_a(world, blockValue, metaValue, pixel[0], pixel[1], pixel[2], sbb);
                if (err_1 > 0) {
                    pixel[1] = pixel[1] + y_inc;
                    err_1 -= dz2;
                }
                if (err_2 > 0) {
                    pixel[0] = pixel[0] + x_inc;
                    err_2 -= dz2;
                }
                err_1 += dy2;
                err_2 += dx2;
                pixel[2] = pixel[2] + z_inc;
            }
        }
        this.func_74864_a(world, blockValue, metaValue, pixel[0], pixel[1], pixel[2], sbb);
    }
}

