/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import twilightforest.TFTreasure;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.entity.EntityTFMiniGhast;
import twilightforest.entity.EntityTFTowerGhast;
import twilightforest.entity.EntityTFUrGhastFireball;

public class EntityTFUrGhast
extends EntityTFTowerGhast
implements IBossDisplayData {
    private static final int DATA_BOSSHEALTH = 17;
    private static final int DATA_TANTRUM = 18;
    private static final int CRUISING_ALTITUDE = 235;
    private static final int HOVER_ALTITUDE = 20;
    public double courseX;
    public double courseY;
    public double courseZ;
    ArrayList trapLocations;
    ArrayList travelCoords;
    int currentTravelCoordIndex;
    int travelPathRepetitions;
    int desiredRepetitions;
    int nextTantrumCry;
    int damageUntilNextPhase;
    boolean noTrapMode;

    public EntityTFUrGhast(World par1World) {
        super(par1World);
        this.func_70105_a(14.0f, 18.0f);
        this.aggroRange = 128.0f;
        this.wanderFactor = 32.0f;
        this.field_70750_az = "/mods/twilightforest/textures/model/towerboss.png";
        this.field_70145_X = true;
        this.trapLocations = new ArrayList();
        this.travelCoords = new ArrayList();
        this.setInTantrum(false);
        this.damageUntilNextPhase = 45;
        this.field_70728_aV = 317;
        this.noTrapMode = false;
    }

    @Override
    public int func_70667_aM() {
        return 250;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(17, (Object)new Integer(this.func_70667_aM()));
        this.field_70180_af.func_75682_a(18, (Object)0);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(17, (Object)this.field_70734_aK);
        }
        byte aggroStatus = this.field_70180_af.func_75683_a(16);
        switch (aggroStatus) {
            default: {
                this.field_70750_az = "/mods/twilightforest/textures/model/towerboss.png";
                break;
            }
            case 1: {
                this.field_70750_az = "/mods/twilightforest/textures/model/towerboss_openeyes.png";
                break;
            }
            case 2: {
                this.field_70750_az = "/mods/twilightforest/textures/model/towerboss_fire.png";
            }
        }
        if (this.field_70725_aQ > 0) {
            for (int k = 0; k < 5; ++k) {
                double d = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                String explosionType = this.field_70146_Z.nextBoolean() ? "hugeexplosion" : "explode";
                this.field_70170_p.func_72869_a(explosionType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d, d1, d2);
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, int damage) {
        if (source == DamageSource.field_76368_d) {
            return false;
        }
        boolean attackSuccessful = false;
        if (this.isInTantrum()) {
            damage /= 4;
        }
        attackSuccessful = "fireball".equals(source.func_76355_l()) && source.func_76346_g() instanceof EntityPlayer ? super.func_70097_a(DamageSource.func_76356_a((Entity)source.func_76364_f(), (Entity)source.func_76346_g()), damage) : super.func_70097_a(source, damage);
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70737_aN == this.field_70738_aO) {
                this.damageUntilNextPhase -= this.field_70707_bp;
                FMLLog.info((String)"Attack successful, %d damage until phase switch.", (Object[])new Object[]{this.damageUntilNextPhase});
                if (this.damageUntilNextPhase <= 0) {
                    this.switchPhase();
                }
            } else {
                FMLLog.info((String)"Attack fail with %s type attack for %d damage", (Object[])new Object[]{source.field_76373_n, damage});
            }
        }
        return attackSuccessful;
    }

    private void switchPhase() {
        if (this.isInTantrum()) {
            this.stopTantrum();
        } else {
            this.startTantrum();
        }
        this.damageUntilNextPhase = 48;
    }

    protected void startTantrum() {
        this.setInTantrum(true);
        int rainTime = 6000;
        WorldInfo worldInfo = MinecraftServer.func_71276_C().field_71305_c[0].func_72912_H();
        worldInfo.func_76084_b(true);
        worldInfo.func_76069_a(true);
        worldInfo.func_76080_g(rainTime);
        worldInfo.func_76090_f(rainTime);
        this.spawnGhastsAtTraps();
    }

    protected void spawnGhastsAtTraps() {
        ArrayList ghastSpawns = new ArrayList(this.trapLocations);
        int numSpawns = Math.min(2, ghastSpawns.size());
        for (int i = 0; i < numSpawns; ++i) {
            int index = this.field_70146_Z.nextInt(ghastSpawns.size());
            ChunkCoordinates spawnCoord = (ChunkCoordinates)ghastSpawns.get(index);
            ghastSpawns.remove(index);
            this.spawnMinionGhastsAt(spawnCoord.field_71574_a, spawnCoord.field_71572_b, spawnCoord.field_71573_c);
        }
    }

    public void stopTantrum() {
        this.setInTantrum(false);
    }

    private void spawnMinionGhastsAt(int x, int y, int z) {
        int tries = 24;
        int spawns = 0;
        int maxSpawns = 6;
        int rangeXZ = 4;
        int rangeY = 8;
        this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, (double)x, (double)(y + 4), (double)z));
        for (int i = 0; i < tries; ++i) {
            EntityTFMiniGhast minion = new EntityTFMiniGhast(this.field_70170_p);
            double sx = (double)x + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)rangeXZ;
            double sy = (double)y + this.field_70146_Z.nextDouble() * (double)rangeY;
            double sz = (double)z + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)rangeXZ;
            minion.func_70012_b(sx, sy, sz, this.field_70170_p.field_73012_v.nextFloat() * 360.0f, 0.0f);
            minion.makeBossMinion();
            if (minion.func_70601_bi()) {
                this.field_70170_p.func_72838_d((Entity)minion);
                minion.func_70656_aK();
            }
            if (++spawns >= maxSpawns) break;
        }
    }

    @Override
    protected void func_70626_be() {
        byte newAggroStatus;
        byte currentAggroStatus;
        double targetRange;
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == 0) {
            this.func_70106_y();
        }
        this.func_70623_bb();
        List nearbyGhasts = this.field_70170_p.func_72872_a(EntityTFMiniGhast.class, this.field_70121_D.func_72314_b(1.0, 1.0, 1.0));
        for (EntityTFMiniGhast ghast : nearbyGhasts) {
            ghast.func_70106_y();
            this.func_70691_i(2);
        }
        if (this.trapLocations.isEmpty() && !this.noTrapMode) {
            this.scanForTrapsTwice();
        }
        if (this.trapLocations.isEmpty() && !this.noTrapMode) {
            FMLLog.info((String)"[TwilightForest] Ur-ghast cannot find traps nearby, entering trap-less mode", (Object[])new Object[0]);
            this.noTrapMode = true;
        }
        if (this.inTrapCounter > 0) {
            --this.inTrapCounter;
            this.targetedEntity = null;
            return;
        }
        this.field_70794_e = this.field_70791_f;
        if (this.targetedEntity != null && this.targetedEntity.field_70128_L) {
            this.targetedEntity = null;
        }
        if (this.targetedEntity == null) {
            this.targetedEntity = this.findPlayerInRange();
        } else if (!this.isAggressive && this.targetedEntity instanceof EntityPlayer) {
            this.checkToIncreaseAggro((EntityPlayer)this.targetedEntity);
        }
        if (this.isInTantrum()) {
            this.shedTear();
            this.targetedEntity = null;
            if (--this.nextTantrumCry <= 0) {
                this.func_85030_a(this.func_70621_aR(), this.func_70599_aP(), this.func_70647_i());
                this.nextTantrumCry = 20 + this.field_70146_Z.nextInt(30);
            }
            if (this.field_70173_aa % 10 == 0) {
                this.doTantrumDamageEffects();
            }
        }
        this.checkAndChangeCourse();
        double offsetX = this.field_70795_b - this.field_70165_t;
        double offsetY = this.field_70796_c - this.field_70163_u;
        double offsetZ = this.field_70793_d - this.field_70161_v;
        double distanceToWaypoint = offsetX * offsetX + offsetY * offsetY + offsetZ * offsetZ;
        if (distanceToWaypoint < 1.0 || distanceToWaypoint > 3600.0) {
            this.makeNewWaypoint();
        }
        if (this.field_70797_a-- <= 0) {
            this.field_70797_a += this.field_70146_Z.nextInt(5) + 0;
            distanceToWaypoint = MathHelper.func_76133_a((double)distanceToWaypoint);
            double speed = 0.05;
            this.field_70159_w += offsetX / distanceToWaypoint * speed;
            this.field_70181_x += offsetY / distanceToWaypoint * speed;
            this.field_70179_y += offsetZ / distanceToWaypoint * speed;
        }
        double d = targetRange = this.aggroCounter > 0 || this.isAggressive ? (double)this.aggroRange : (double)this.stareRange;
        if (this.targetedEntity != null && this.targetedEntity.func_70068_e((Entity)this) < targetRange * targetRange && this.func_70685_l((Entity)this.targetedEntity)) {
            this.func_70625_a((Entity)this.targetedEntity, 10.0f, this.func_70646_bf());
            if (this.isAggressive) {
                if (this.field_70791_f == 10) {
                    this.func_85030_a("mob.ghast.charge", this.func_70599_aP(), this.func_70647_i());
                }
                ++this.field_70791_f;
                if (this.field_70791_f == 20) {
                    this.spitFireball();
                    this.field_70791_f = -40;
                }
            }
        } else {
            this.isAggressive = false;
            this.targetedEntity = null;
            this.field_70177_z = -((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI;
            this.field_70125_A = 0.0f;
        }
        if (this.field_70791_f > 0 && !this.isAggressive) {
            --this.field_70791_f;
        }
        if ((currentAggroStatus = this.field_70180_af.func_75683_a(16)) != (newAggroStatus = (byte)(this.field_70791_f > 10 ? 2 : (this.aggroCounter > 0 || this.isAggressive ? 1 : 0)))) {
            this.field_70180_af.func_75692_b(16, (Object)newAggroStatus);
        }
    }

    private void doTantrumDamageEffects() {
        AxisAlignedBB below = this.field_70121_D.func_72325_c(0.0, -16.0, 0.0).func_72314_b(0.0, 16.0, 0.0);
        List playersBelow = this.field_70170_p.func_72872_a(EntityPlayer.class, below);
        for (EntityPlayer player : playersBelow) {
            int dz;
            int dy;
            int dx = MathHelper.func_76128_c((double)player.field_70165_t);
            if (!this.field_70170_p.func_72937_j(dx, dy = MathHelper.func_76128_c((double)player.field_70163_u), dz = MathHelper.func_76128_c((double)player.field_70161_v))) continue;
            player.func_70097_a(DamageSource.field_82728_o, 3);
        }
        List ghastsBelow = this.field_70170_p.func_72872_a(EntityTFMiniGhast.class, below);
        for (EntityTFMiniGhast ghast : ghastsBelow) {
            ghast.field_70181_x += 1.0;
        }
    }

    private void shedTear() {
        TwilightForestMod.proxy.spawnParticle("bosstear", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0);
    }

    protected void makeNewWaypoint() {
        double closestDistance = this.func_70092_e(this.courseX, this.courseY, this.courseZ);
        for (int i = 0; i < 50; ++i) {
            double potentialZ;
            double offsetZ;
            double potentialY;
            double offsetY;
            double potentialX = this.field_70165_t + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.wanderFactor);
            double offsetX = this.courseX - potentialX;
            double potentialDistanceToCourse = offsetX * offsetX + (offsetY = this.courseY - (potentialY = this.courseY + (double)(this.field_70146_Z.nextFloat() * 8.0f) - 4.0)) * offsetY + (offsetZ = this.courseZ - (potentialZ = this.field_70161_v + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.wanderFactor))) * offsetZ;
            if (!(potentialDistanceToCourse < closestDistance)) continue;
            this.field_70795_b = potentialX;
            this.field_70796_c = potentialY;
            this.field_70793_d = potentialZ;
            closestDistance = potentialDistanceToCourse;
        }
    }

    protected void checkAndChangeCourse() {
        double offsetZ;
        double offsetY;
        double offsetX;
        double distanceToCourse;
        if (this.courseX == 0.0 && this.courseY == 0.0 && this.courseZ == 0.0) {
            this.changeCourse();
        }
        if ((distanceToCourse = (offsetX = this.courseX - this.field_70165_t) * offsetX + (offsetY = this.courseY - this.field_70163_u) * offsetY + (offsetZ = this.courseZ - this.field_70161_v) * offsetZ) < 100.0) {
            this.changeCourse();
        }
    }

    private void changeCourse() {
        if (this.travelCoords.isEmpty()) {
            this.makeTravelPath();
        }
        if (!this.travelCoords.isEmpty()) {
            if (this.currentTravelCoordIndex >= this.travelCoords.size()) {
                this.currentTravelCoordIndex = 0;
                ++this.travelPathRepetitions;
                if (!this.checkGhastsAtTraps()) {
                    this.spawnGhastsAtTraps();
                }
            }
            this.courseX = ((ChunkCoordinates)this.travelCoords.get((int)this.currentTravelCoordIndex)).field_71574_a;
            this.courseY = ((ChunkCoordinates)this.travelCoords.get((int)this.currentTravelCoordIndex)).field_71572_b + 20;
            this.courseZ = ((ChunkCoordinates)this.travelCoords.get((int)this.currentTravelCoordIndex)).field_71573_c;
            ++this.currentTravelCoordIndex;
        }
    }

    private boolean checkGhastsAtTraps() {
        int trapsWithEnoughGhasts = 0;
        for (ChunkCoordinates trap : this.trapLocations) {
            AxisAlignedBB aabb = AxisAlignedBB.func_72332_a().func_72299_a((double)trap.field_71574_a, (double)trap.field_71572_b, (double)trap.field_71573_c, (double)(trap.field_71574_a + 1), (double)(trap.field_71572_b + 1), (double)(trap.field_71573_c + 1)).func_72314_b(8.0, 16.0, 8.0);
            List nearbyGhasts = this.field_70170_p.func_72872_a(EntityTFMiniGhast.class, aabb);
            if (nearbyGhasts.size() < 4) continue;
            ++trapsWithEnoughGhasts;
        }
        return trapsWithEnoughGhasts >= 1;
    }

    private void makeTravelPath() {
        ArrayList<ChunkCoordinates> potentialPoints;
        int px = MathHelper.func_76128_c((double)this.field_70165_t);
        int py = MathHelper.func_76128_c((double)this.field_70163_u);
        int pz = MathHelper.func_76128_c((double)this.field_70161_v);
        if (!this.noTrapMode) {
            potentialPoints = new ArrayList(this.trapLocations);
        } else {
            potentialPoints = new ArrayList<ChunkCoordinates>();
            potentialPoints.add(new ChunkCoordinates(px + 20, py - 20, pz));
            potentialPoints.add(new ChunkCoordinates(px, py - 20, pz - 20));
            potentialPoints.add(new ChunkCoordinates(px - 20, py - 20, pz));
            potentialPoints.add(new ChunkCoordinates(px, py - 20, pz + 20));
        }
        this.travelCoords.clear();
        while (!potentialPoints.isEmpty()) {
            int index = this.field_70146_Z.nextInt(potentialPoints.size());
            this.travelCoords.add(potentialPoints.get(index));
            potentialPoints.remove(index);
        }
        if (this.noTrapMode) {
            this.travelCoords.add(new ChunkCoordinates(px, py - 20, pz));
        }
    }

    @Override
    protected void spitFireball() {
        double offsetX = this.targetedEntity.field_70165_t - this.field_70165_t;
        double offsetY = this.targetedEntity.field_70121_D.field_72338_b + (double)(this.targetedEntity.field_70131_O / 2.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
        double offsetZ = this.targetedEntity.field_70161_v - this.field_70161_v;
        this.field_70170_p.func_72889_a((EntityPlayer)null, 1008, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
        EntityTFUrGhastFireball entityFireball = new EntityTFUrGhastFireball(this.field_70170_p, this, offsetX, offsetY, offsetZ);
        entityFireball.field_92057_e = 1;
        double shotSpawnDistance = 8.5;
        Vec3 lookVec = this.func_70676_i(1.0f);
        entityFireball.field_70165_t = this.field_70165_t + lookVec.field_72450_a * shotSpawnDistance;
        entityFireball.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f) + lookVec.field_72448_b * shotSpawnDistance;
        entityFireball.field_70161_v = this.field_70161_v + lookVec.field_72449_c * shotSpawnDistance;
        this.field_70170_p.func_72838_d((Entity)entityFireball);
        for (int i = 0; i < 2; ++i) {
            entityFireball = new EntityTFUrGhastFireball(this.field_70170_p, this, offsetX + (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 8.0f), offsetY, offsetZ + (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 8.0f));
            entityFireball.field_92057_e = 1;
            entityFireball.field_70165_t = this.field_70165_t + lookVec.field_72450_a * shotSpawnDistance;
            entityFireball.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f) + lookVec.field_72448_b * shotSpawnDistance;
            entityFireball.field_70161_v = this.field_70161_v + lookVec.field_72449_c * shotSpawnDistance;
            this.field_70170_p.func_72838_d((Entity)entityFireball);
        }
    }

    private void scanForTrapsTwice() {
        int scanRangeXZ = 48;
        int scanRangeY = 32;
        int px = MathHelper.func_76128_c((double)this.field_70165_t);
        int py = MathHelper.func_76128_c((double)this.field_70163_u);
        int pz = MathHelper.func_76128_c((double)this.field_70161_v);
        this.scanForTraps(scanRangeXZ, scanRangeY, px, py, pz);
        if (this.trapLocations.size() > 0) {
            int ax = 0;
            int ay = 0;
            int az = 0;
            for (ChunkCoordinates trapCoords : this.trapLocations) {
                ax += trapCoords.field_71574_a;
                ay += trapCoords.field_71572_b;
                az += trapCoords.field_71573_c;
            }
            this.scanForTraps(scanRangeXZ, scanRangeY, ax /= this.trapLocations.size(), ay /= this.trapLocations.size(), az /= this.trapLocations.size());
        }
    }

    protected void scanForTraps(int scanRangeXZ, int scanRangeY, int px, int py, int pz) {
        for (int sx = -scanRangeXZ; sx <= scanRangeXZ; ++sx) {
            for (int sz = -scanRangeXZ; sz <= scanRangeXZ; ++sz) {
                for (int sy = -scanRangeY; sy <= scanRangeY; ++sy) {
                    ChunkCoordinates trapCoords;
                    if (!this.isTrapAt(px + sx, py + sy, pz + sz) || this.trapLocations.contains(trapCoords = new ChunkCoordinates(px + sx, py + sy, pz + sz))) continue;
                    this.trapLocations.add(trapCoords);
                }
            }
        }
    }

    private boolean isTrapAt(int x, int y, int z) {
        return this.field_70170_p.func_72899_e(x, y, z) && this.field_70170_p.func_72798_a(x, y, z) == TFBlocks.towerDevice.field_71990_ca && (this.field_70170_p.func_72805_g(x, y, z) == 10 || this.field_70170_p.func_72805_g(x, y, z) == 11);
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean isInTantrum() {
        return this.field_70180_af.func_75683_a(18) != 0;
    }

    public void setInTantrum(boolean par1) {
        this.field_70180_af.func_75692_b(18, (Object)(par1 ? Byte.valueOf((byte)-1) : Byte.valueOf((byte)0)));
        this.damageUntilNextPhase = 48;
    }

    @Override
    protected float func_70599_aP() {
        return 16.0f;
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.5f;
    }

    public int func_70968_i() {
        return this.field_70180_af.func_75679_c(17);
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74757_a("inTantrum", this.isInTantrum());
        super.func_70014_b(nbttagcompound);
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setInTantrum(nbttagcompound.func_74767_n("inTantrum"));
    }

    protected void func_70609_aI() {
        super.func_70609_aI();
        if (this.field_70725_aQ == 20 && !this.field_70170_p.field_72995_K) {
            ChunkCoordinates chestCoords = this.findChestCoords();
            TFTreasure.darktower_boss.generate(this.field_70170_p, null, chestCoords.field_71574_a, chestCoords.field_71572_b, chestCoords.field_71573_c);
        }
    }

    private ChunkCoordinates findChestCoords() {
        if (this.trapLocations.size() > 0) {
            int ax = 0;
            int ay = 0;
            int az = 0;
            for (ChunkCoordinates trapCoords : this.trapLocations) {
                ax += trapCoords.field_71574_a;
                ay += trapCoords.field_71572_b;
                az += trapCoords.field_71573_c;
            }
            return new ChunkCoordinates(ax /= this.trapLocations.size(), (ay /= this.trapLocations.size()) + 2, az /= this.trapLocations.size());
        }
        return new ChunkCoordinates(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v));
    }
}

