/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import twilightforest.entity.EntityTFNagaOld;

public class EntityTFNagaSegmentOld
extends EntityLiving
implements IMob {
    EntityTFNagaOld head;
    double sDist = 1.5;
    int attackStrength;
    int deathCounter;

    public EntityTFNagaSegmentOld(World world) {
        super(world);
        this.field_70750_az = "/mods/twilightforest/textures/model/nagasegment.png";
        this.func_70105_a(1.75f, 1.95f);
        this.field_70138_W = 2.0f;
        this.field_70734_aK = 1000;
        this.field_70178_ae = true;
        this.attackStrength = 2;
    }

    public EntityTFNagaSegmentOld(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
    }

    public EntityTFNagaSegmentOld(World world, EntityTFNagaOld head, int segment) {
        this(world);
        this.head = head;
        this.setSegment(segment);
        this.field_70697_bw = head.getMoveSpeed() * 1.5f;
        this.field_70746_aG = head.field_70746_aG;
        this.field_70747_aH = head.field_70747_aH;
    }

    public void setSegment(int i) {
        this.field_70180_af.func_75692_b(16, (Object)new Byte((byte)i));
    }

    public int getSegment() {
        return this.field_70180_af.func_75683_a(16);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)new Byte(1));
    }

    public boolean func_70104_M() {
        return true;
    }

    public void func_70653_a(Entity entity, int i, double d, double d1) {
    }

    protected void func_70069_a(float f) {
    }

    public boolean func_70041_e_() {
        return false;
    }

    public boolean func_70058_J() {
        return false;
    }

    public void func_70071_h_() {
        this.despawnIfInvalid();
        if (this.deathCounter > 0) {
            --this.deathCounter;
            if (this.deathCounter == 0) {
                for (int k = 0; k < 20; ++k) {
                    double d = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    String explosionType = this.field_70146_Z.nextBoolean() ? "largeexplode" : "explode";
                    this.field_70170_p.func_72869_a(explosionType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d, d1, d2);
                }
                this.func_70106_y();
            }
        }
        super.func_70071_h_();
    }

    protected void func_70626_be() {
        if (this.head != null && this.head.field_70724_aR <= 0) {
            List allNearEntities = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(0.75, 0.75, 0.75));
            for (int i = 0; i < allNearEntities.size(); ++i) {
                Entity nearEntity = (Entity)allNearEntities.get(i);
                if (!(nearEntity instanceof EntityLiving) || nearEntity instanceof EntityTFNagaOld || nearEntity instanceof EntityTFNagaSegmentOld) continue;
                this.head.field_70724_aR = 10;
                this.func_70652_k(nearEntity);
            }
        }
    }

    public boolean func_70652_k(Entity entity) {
        if (entity instanceof EntityAnimal) {
            return entity.func_70097_a(DamageSource.func_76358_a((EntityLiving)this), this.attackStrength * 3);
        }
        return entity.func_70097_a(DamageSource.func_76358_a((EntityLiving)this), this.attackStrength);
    }

    public boolean func_70097_a(DamageSource damagesource, int i) {
        if (damagesource.func_94541_c() || damagesource.func_76347_k()) {
            this.field_70737_aN = 0;
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.deathCounter <= 0 && this.head != null) {
            this.field_70738_aO = 10;
            this.field_70737_aN = 10;
            return this.head.func_70097_a(damagesource, Math.round((float)i * 2.0f / 3.0f));
        }
        return false;
    }

    public void despawnIfInvalid() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.head == null || this.head.field_70128_L) {
                this.func_70106_y();
            }
            if (this.field_70170_p.field_73013_u == 0) {
                this.func_70106_y();
            }
        }
    }

    public void pullTowards(Entity leader) {
        this.field_70697_bw = this.head.getMoveSpeed() * 1.5f;
        float angle = (float)Math.atan2(this.field_70161_v - leader.field_70161_v, this.field_70165_t - leader.field_70165_t);
        double idealX = leader.field_70165_t + (double)MathHelper.func_76134_b((float)angle) * this.sDist;
        double idealZ = leader.field_70161_v + (double)MathHelper.func_76126_a((float)angle) * this.sDist;
        double dx = idealX - this.field_70165_t;
        double dy = leader.field_70163_u - this.field_70163_u;
        double dz = idealZ - this.field_70161_v;
        double dist = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        if (dist > this.sDist * 4.0) {
            this.func_70080_a(idealX, leader.field_70163_u + 0.001, idealZ, 0.0f, (float)((double)(angle * 180.0f) / Math.PI) - 90.0f);
            dy = 0.0;
            this.func_70625_a(leader, 90.0f, 90.0f);
            this.field_70701_bs = (float)((double)this.field_70697_bw * dist * 5.0);
        } else if (dist > 0.0) {
            this.func_70625_a(leader, 90.0f, 90.0f);
            this.field_70701_bs = this.head.getMoveSpeed();
        }
        if (dy > 1.1) {
            this.func_70664_aZ();
        }
    }

    public void selfDestruct() {
        this.field_70738_aO = 30;
        this.field_70737_aN = 30;
        this.deathCounter = 30;
    }

    public int func_70667_aM() {
        return 250;
    }
}

