/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client;

import java.awt.image.BufferedImage;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderEngine;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.storage.MapCoord;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import twilightforest.TFMagicMapData;
import twilightforest.item.TFItems;

public class TFMagicMapRenderer
implements IItemRenderer {
    private int[] intArray = new int[16384];
    private int bufferedImage;
    private GameSettings gameSettings;
    private FontRenderer fontRenderer;

    public TFMagicMapRenderer(FontRenderer par1FontRenderer, GameSettings par2GameSettings, RenderEngine par3RenderEngine) {
        this.gameSettings = par2GameSettings;
        this.fontRenderer = par1FontRenderer;
        this.bufferedImage = par3RenderEngine.func_78353_a(new BufferedImage(128, 128, 2));
        for (int var4 = 0; var4 < 16384; ++var4) {
            this.intArray[var4] = 0;
        }
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return item.field_77993_c == TFItems.magicMap.field_77779_bT && type == IItemRenderer.ItemRenderType.FIRST_PERSON_MAP;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        EntityPlayer player = (EntityPlayer)data[0];
        RenderEngine renderEngine = (RenderEngine)data[1];
        MapData mapData = (MapData)data[2];
        if (mapData != null) {
            this.renderMap(player, renderEngine, mapData);
        }
    }

    public void renderMap(EntityPlayer par1EntityPlayer, RenderEngine par2RenderEngine, MapData par3MapData) {
        float var24;
        float var22;
        float var23;
        float var21;
        TFMagicMapData magicMapData = (TFMagicMapData)par3MapData;
        for (int i = 0; i < 16384; ++i) {
            int colorByte = par3MapData.field_76198_e[i] & 0xFF;
            if (colorByte == 0) {
                this.intArray[i] = (i + i / 128 & 1) * 8 + 16 << 24;
                continue;
            }
            int biomeID = colorByte - 1;
            BiomeGenBase biome = BiomeGenBase.field_76773_a[biomeID];
            if (biome == null) continue;
            this.intArray[i] = 0xFF000000 | biome.field_76790_z;
        }
        par2RenderEngine.func_78349_a(this.intArray, 128, 128, this.bufferedImage);
        int var15 = 0;
        int var16 = 0;
        Tessellator tesselator = Tessellator.field_78398_a;
        float var18 = 0.0f;
        GL11.glBindTexture((int)3553, (int)this.bufferedImage);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)771);
        GL11.glDisable((int)3008);
        tesselator.func_78382_b();
        tesselator.func_78374_a((double)((float)(var15 + 0) + var18), (double)((float)(var16 + 128) - var18), (double)-0.01f, 0.0, 1.0);
        tesselator.func_78374_a((double)((float)(var15 + 128) - var18), (double)((float)(var16 + 128) - var18), (double)-0.01f, 1.0, 1.0);
        tesselator.func_78374_a((double)((float)(var15 + 128) - var18), (double)((float)(var16 + 0) + var18), (double)-0.01f, 1.0, 0.0);
        tesselator.func_78374_a((double)((float)(var15 + 0) + var18), (double)((float)(var16 + 0) + var18), (double)-0.01f, 0.0, 0.0);
        tesselator.func_78381_a();
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
        par2RenderEngine.func_98185_a();
        par2RenderEngine.func_98187_b("/misc/mapicons.png");
        for (MapCoord mapCoord : par3MapData.field_76203_h.values()) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)var15 + (float)mapCoord.field_76214_b / 2.0f + 64.0f), (float)((float)var16 + (float)mapCoord.field_76215_c / 2.0f + 64.0f), (float)-0.04f);
            GL11.glRotatef((float)((float)(mapCoord.field_76212_d * 360) / 16.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glScalef((float)4.0f, (float)4.0f, (float)3.0f);
            GL11.glTranslatef((float)-0.125f, (float)0.125f, (float)0.0f);
            var21 = (float)(mapCoord.field_76216_a % 4 + 0) / 4.0f;
            var23 = (float)(mapCoord.field_76216_a / 4 + 0) / 4.0f;
            var22 = (float)(mapCoord.field_76216_a % 4 + 1) / 4.0f;
            var24 = (float)(mapCoord.field_76216_a / 4 + 1) / 4.0f;
            tesselator.func_78382_b();
            tesselator.func_78374_a(-1.0, 1.0, 0.0, (double)var21, (double)var23);
            tesselator.func_78374_a(1.0, 1.0, 0.0, (double)var22, (double)var23);
            tesselator.func_78374_a(1.0, -1.0, 0.0, (double)var22, (double)var24);
            tesselator.func_78374_a(-1.0, -1.0, 0.0, (double)var21, (double)var24);
            tesselator.func_78381_a();
            GL11.glPopMatrix();
        }
        par2RenderEngine.func_98185_a();
        par2RenderEngine.func_98187_b("/mods/twilightforest/textures/gui/mapicons.png");
        for (MapCoord mapCoord : magicMapData.featuresVisibleOnMap) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)var15 + (float)mapCoord.field_76214_b / 2.0f + 64.0f), (float)((float)var16 + (float)mapCoord.field_76215_c / 2.0f + 64.0f), (float)-0.02f);
            GL11.glRotatef((float)((float)(mapCoord.field_76212_d * 360) / 16.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glScalef((float)4.0f, (float)4.0f, (float)3.0f);
            GL11.glTranslatef((float)-0.125f, (float)0.125f, (float)0.0f);
            var21 = (float)(mapCoord.field_76216_a % 8 + 0) / 8.0f;
            var23 = (float)(mapCoord.field_76216_a / 8 + 0) / 8.0f;
            var22 = (float)(mapCoord.field_76216_a % 8 + 1) / 8.0f;
            var24 = (float)(mapCoord.field_76216_a / 8 + 1) / 8.0f;
            tesselator.func_78382_b();
            tesselator.func_78374_a(-1.0, 1.0, 0.0, (double)var21, (double)var23);
            tesselator.func_78374_a(1.0, 1.0, 0.0, (double)var22, (double)var23);
            tesselator.func_78374_a(1.0, -1.0, 0.0, (double)var22, (double)var24);
            tesselator.func_78374_a(-1.0, -1.0, 0.0, (double)var21, (double)var24);
            tesselator.func_78381_a();
            GL11.glPopMatrix();
        }
    }
}

