/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSourceImpl;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import twilightforest.block.TFBlocks;
import twilightforest.item.TFItems;
import twilightforest.tileentity.TileEntityTFCReactorActive;
import twilightforest.tileentity.TileEntityTFGhastTrapActive;
import twilightforest.tileentity.TileEntityTFGhastTrapInactive;
import twilightforest.tileentity.TileEntityTFReverter;
import twilightforest.tileentity.TileEntityTFTowerBuilder;

public class BlockTFTowerDevice
extends Block {
    private static Icon TEX_REAPPEARING_INACTIVE;
    private static Icon TEX_REAPPEARING_ACTIVE;
    private static Icon TEX_VANISH_INACTIVE;
    private static Icon TEX_VANISH_ACTIVE;
    private static Icon TEX_VANISH_LOCKED;
    private static Icon TEX_VANISH_UNLOCKED;
    private static Icon TEX_BUILDER_INACTIVE;
    private static Icon TEX_BUILDER_ACTIVE;
    private static Icon TEX_ANTIBUILDER;
    private static Icon TEX_BUILDER_TIMEOUT;
    private static Icon TEX_GHASTTRAP_INACTIVE;
    private static Icon TEX_GHASTTRAP_ACTIVE;
    private static Icon TEX_REACTOR_INACTIVE;
    private static Icon TEX_REACTOR_ACTIVE;
    private static Icon TEX_GHASTTRAP_LID_INACTIVE;
    private static Icon TEX_GHASTTRAP_LID_ACTIVE;
    private static Icon TEX_SMOKER_ACTIVE;
    private static Icon TEX_SMOKER_INACTIVE;
    private static Icon TEX_FIREJET_ACTIVE;
    private static Icon TEX_FIREJET_INACTIVE;
    public static final int META_REAPPEARING_INACTIVE = 0;
    public static final int META_REAPPEARING_ACTIVE = 1;
    public static final int META_VANISH_INACTIVE = 2;
    public static final int META_VANISH_ACTIVE = 3;
    public static final int META_VANISH_LOCKED = 4;
    public static final int META_VANISH_UNLOCKED = 5;
    public static final int META_BUILDER_INACTIVE = 6;
    public static final int META_BUILDER_ACTIVE = 7;
    public static final int META_BUILDER_TIMEOUT = 8;
    public static final int META_ANTIBUILDER = 9;
    public static final int META_GHASTTRAP_INACTIVE = 10;
    public static final int META_GHASTTRAP_ACTIVE = 11;
    public static final int META_REACTOR_INACTIVE = 12;
    public static final int META_REACTOR_ACTIVE = 13;

    public BlockTFTowerDevice(int id) {
        super(id, Material.field_76245_d);
        this.func_71848_c(10.0f);
        this.func_71894_b(35.0f);
        this.func_71884_a(Block.field_71967_e);
        this.func_71849_a(TFItems.creativeTab);
    }

    public int tickRate() {
        return 15;
    }

    public Icon func_71858_a(int side, int meta) {
        switch (meta) {
            default: {
                return TEX_REAPPEARING_INACTIVE;
            }
            case 1: {
                return TEX_REAPPEARING_ACTIVE;
            }
            case 2: {
                return TEX_VANISH_INACTIVE;
            }
            case 3: {
                return TEX_VANISH_ACTIVE;
            }
            case 4: {
                return TEX_VANISH_LOCKED;
            }
            case 5: {
                return TEX_VANISH_UNLOCKED;
            }
            case 6: {
                return TEX_BUILDER_INACTIVE;
            }
            case 8: {
                return TEX_BUILDER_TIMEOUT;
            }
            case 7: {
                return TEX_BUILDER_ACTIVE;
            }
            case 9: {
                return TEX_ANTIBUILDER;
            }
            case 10: {
                if (side >= 2) {
                    return TEX_GHASTTRAP_INACTIVE;
                }
                if (side == 1) {
                    return TEX_GHASTTRAP_LID_INACTIVE;
                }
                return TFBlocks.towerWood.func_71858_a(side, 1);
            }
            case 11: {
                if (side >= 2) {
                    return TEX_GHASTTRAP_ACTIVE;
                }
                if (side == 1) {
                    return TEX_GHASTTRAP_LID_ACTIVE;
                }
                return TFBlocks.towerWood.func_71858_a(side, 1);
            }
            case 12: {
                return TEX_REACTOR_INACTIVE;
            }
            case 13: 
        }
        return TEX_REACTOR_ACTIVE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister par1IconRegister) {
        TEX_REAPPEARING_INACTIVE = par1IconRegister.func_94245_a("twilightforest:towerdev_reappearing_off");
        TEX_REAPPEARING_ACTIVE = par1IconRegister.func_94245_a("twilightforest:towerdev_reappearing_on");
        TEX_VANISH_INACTIVE = par1IconRegister.func_94245_a("twilightforest:towerdev_vanish_off");
        TEX_VANISH_ACTIVE = par1IconRegister.func_94245_a("twilightforest:towerdev_vanish_on");
        TEX_VANISH_LOCKED = par1IconRegister.func_94245_a("twilightforest:towerdev_lock_on");
        TEX_VANISH_UNLOCKED = par1IconRegister.func_94245_a("twilightforest:towerdev_lock_off");
        TEX_BUILDER_INACTIVE = par1IconRegister.func_94245_a("twilightforest:towerdev_builder_off");
        TEX_BUILDER_ACTIVE = par1IconRegister.func_94245_a("twilightforest:towerdev_builder_on");
        TEX_ANTIBUILDER = par1IconRegister.func_94245_a("twilightforest:towerdev_antibuilder");
        TEX_BUILDER_TIMEOUT = par1IconRegister.func_94245_a("twilightforest:towerdev_builder_timeout");
        TEX_GHASTTRAP_INACTIVE = par1IconRegister.func_94245_a("twilightforest:towerdev_ghasttrap_off");
        TEX_GHASTTRAP_ACTIVE = par1IconRegister.func_94245_a("twilightforest:towerdev_ghasttrap_on");
        TEX_REACTOR_INACTIVE = par1IconRegister.func_94245_a("twilightforest:towerdev_reactor_off");
        TEX_REACTOR_ACTIVE = par1IconRegister.func_94245_a("twilightforest:towerdev_reactor_on");
        TEX_GHASTTRAP_LID_INACTIVE = par1IconRegister.func_94245_a("twilightforest:towerdev_ghasttraplid_off");
        TEX_GHASTTRAP_LID_ACTIVE = par1IconRegister.func_94245_a("twilightforest:towerdev_ghasttraplid_on");
        TEX_SMOKER_INACTIVE = par1IconRegister.func_94245_a("twilightforest:towerdev_smoker_off");
        TEX_SMOKER_ACTIVE = par1IconRegister.func_94245_a("twilightforest:towerdev_smoker_on");
        TEX_FIREJET_INACTIVE = par1IconRegister.func_94245_a("twilightforest:towerdev_firejet_off");
        TEX_FIREJET_ACTIVE = par1IconRegister.func_94245_a("twilightforest:towerdev_firejet_on");
    }

    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
        par3List.add(new ItemStack(par1, 1, 2));
        par3List.add(new ItemStack(par1, 1, 4));
        par3List.add(new ItemStack(par1, 1, 5));
        par3List.add(new ItemStack(par1, 1, 6));
        par3List.add(new ItemStack(par1, 1, 9));
        par3List.add(new ItemStack(par1, 1, 10));
        par3List.add(new ItemStack(par1, 1, 12));
    }

    public boolean func_71903_a(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        int meta = par1World.func_72805_g(x, y, z);
        if (meta == 2) {
            if (BlockTFTowerDevice.areNearbyLockBlocks(par1World, x, y, z)) {
                par1World.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 1.0f, 0.3f);
            } else {
                BlockTFTowerDevice.changeToActiveVanishBlock(par1World, x, y, z, 3);
            }
            return true;
        }
        if (meta == 0) {
            if (BlockTFTowerDevice.areNearbyLockBlocks(par1World, x, y, z)) {
                par1World.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 1.0f, 0.3f);
            } else {
                BlockTFTowerDevice.changeToActiveVanishBlock(par1World, x, y, z, 1);
            }
            return true;
        }
        return false;
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 2) {
            return 6000.0f;
        }
        if (meta == 4) {
            return 6000000.0f;
        }
        return this.func_71904_a(par1Entity);
    }

    public float func_71934_m(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        switch (meta) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return -1.0f;
            }
        }
        return super.func_71934_m(world, x, y, z);
    }

    public static boolean areNearbyLockBlocks(World world, int x, int y, int z) {
        boolean locked = false;
        for (int dx = x - 2; dx <= x + 2; ++dx) {
            for (int dy = y - 2; dy <= y + 2; ++dy) {
                for (int dz = z - 2; dz <= z + 2; ++dz) {
                    if (world.func_72798_a(dx, dy, dz) != TFBlocks.towerDevice.field_71990_ca || world.func_72805_g(dx, dy, dz) != 4) continue;
                    locked = true;
                }
            }
        }
        return locked;
    }

    public static void unlockBlock(World par1World, int x, int y, int z) {
        int thereBlockID = par1World.func_72798_a(x, y, z);
        int thereBlockMeta = par1World.func_72805_g(x, y, z);
        if (thereBlockID == TFBlocks.towerDevice.field_71990_ca || thereBlockMeta == 4) {
            BlockTFTowerDevice.changeToBlockMeta(par1World, x, y, z, 5);
            par1World.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.6f);
        }
    }

    private static void changeToBlockMeta(World par1World, int x, int y, int z, int meta) {
        int thereBlockID = par1World.func_72798_a(x, y, z);
        if (thereBlockID == TFBlocks.towerDevice.field_71990_ca || thereBlockID == TFBlocks.towerTranslucent.field_71990_ca) {
            par1World.func_72832_d(x, y, z, thereBlockID, meta, 3);
            par1World.func_72909_d(x, y, z, x, y, z);
            par1World.func_72898_h(x, y, z, thereBlockID);
        }
    }

    public void func_71861_g(World par1World, int x, int y, int z) {
        int meta = par1World.func_72805_g(x, y, z);
        if (!par1World.field_72995_K && meta == 6 && par1World.func_72864_z(x, y, z)) {
            BlockTFTowerDevice.changeToBlockMeta(par1World, x, y, z, 7);
            par1World.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.6f);
        }
    }

    public void func_71863_a(World par1World, int x, int y, int z, int myBlockID) {
        int meta = par1World.func_72805_g(x, y, z);
        if (!par1World.field_72995_K) {
            if (meta == 2 && par1World.func_72864_z(x, y, z) && !BlockTFTowerDevice.areNearbyLockBlocks(par1World, x, y, z)) {
                BlockTFTowerDevice.changeToActiveVanishBlock(par1World, x, y, z, 3);
            }
            if (meta == 0 && par1World.func_72864_z(x, y, z) && !BlockTFTowerDevice.areNearbyLockBlocks(par1World, x, y, z)) {
                BlockTFTowerDevice.changeToActiveVanishBlock(par1World, x, y, z, 1);
            }
            if (meta == 6 && par1World.func_72864_z(x, y, z)) {
                BlockTFTowerDevice.changeToBlockMeta(par1World, x, y, z, 7);
                par1World.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.6f);
                par1World.func_72836_a(x, y, z, this.field_71990_ca, 4);
            }
            if (meta == 7 && !par1World.func_72864_z(x, y, z)) {
                BlockTFTowerDevice.changeToBlockMeta(par1World, x, y, z, 6);
                par1World.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.6f);
                par1World.func_72836_a(x, y, z, this.field_71990_ca, 4);
            }
            if (meta == 8 && !par1World.func_72864_z(x, y, z)) {
                BlockTFTowerDevice.changeToBlockMeta(par1World, x, y, z, 6);
            }
            if (meta == 10 && this.isInactiveTrapCharged(par1World, x, y, z) && par1World.func_72864_z(x, y, z)) {
                BlockTFTowerDevice.changeToBlockMeta(par1World, x, y, z, 11);
                par1World.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.6f);
                par1World.func_72836_a(x, y, z, this.field_71990_ca, 4);
            }
            if (meta == 12 && this.isReactorReady(par1World, x, y, z)) {
                BlockTFTowerDevice.changeToBlockMeta(par1World, x, y, z, 13);
            }
        }
    }

    public void func_71847_b(World par1World, int x, int y, int z, Random par5Random) {
        if (!par1World.field_72995_K) {
            int meta = par1World.func_72805_g(x, y, z);
            if (meta == 3 || meta == 1) {
                if (meta == 3) {
                    par1World.func_72832_d(x, y, z, 0, 0, 3);
                } else {
                    par1World.func_72832_d(x, y, z, TFBlocks.towerTranslucent.field_71990_ca, 0, 3);
                    par1World.func_72836_a(x, y, z, TFBlocks.towerTranslucent.field_71990_ca, 80);
                }
                par1World.func_72898_h(x, y, z, this.field_71990_ca);
                par1World.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.pop", 0.3f, 0.5f);
                par1World.func_72909_d(x, y, z, x, y, z);
                BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x - 1, y, z);
                BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x + 1, y, z);
                BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x, y + 1, z);
                BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x, y - 1, z);
                BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x, y, z + 1);
                BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x, y, z - 1);
            }
            if (meta == 7 && par1World.func_72864_z(x, y, z)) {
                this.letsBuild(par1World, x, y, z);
            }
            if (meta == 6 || meta == 8) {
                BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x - 1, y, z);
                BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x + 1, y, z);
                BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x, y + 1, z);
                BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x, y - 1, z);
                BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x, y, z + 1);
                BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x, y, z - 1);
            }
        }
    }

    private void letsBuild(World par1World, int x, int y, int z) {
        BlockSourceImpl blockSource = new BlockSourceImpl(par1World, x, y, z);
        TileEntityTFTowerBuilder tileEntity = (TileEntityTFTowerBuilder)blockSource.func_82619_j();
        if (tileEntity != null && !tileEntity.makingBlocks) {
            tileEntity.startBuilding();
        }
    }

    private boolean isInactiveTrapCharged(World par1World, int x, int y, int z) {
        BlockSourceImpl blockSource = new BlockSourceImpl(par1World, x, y, z);
        TileEntityTFGhastTrapInactive tileEntity = (TileEntityTFGhastTrapInactive)blockSource.func_82619_j();
        return tileEntity != null && tileEntity.isCharged();
    }

    private boolean isReactorReady(World world, int x, int y, int z) {
        return world.func_72798_a(x, y + 1, z) == Block.field_94341_cq.field_71990_ca && world.func_72798_a(x, y - 1, z) == Block.field_94341_cq.field_71990_ca && world.func_72798_a(x + 1, y, z) == Block.field_94341_cq.field_71990_ca && world.func_72798_a(x - 1, y, z) == Block.field_94341_cq.field_71990_ca && world.func_72798_a(x, y, z + 1) == Block.field_94341_cq.field_71990_ca && world.func_72798_a(x, y, z - 1) == Block.field_94341_cq.field_71990_ca;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71862_a(World par1World, int x, int y, int z, Random par5Random) {
        block4: {
            block3: {
                int meta = par1World.func_72805_g(x, y, z);
                if (meta == 3 || meta == 1) break block3;
                if (meta != 7) break block4;
            }
            for (int i = 0; i < 1; ++i) {
                this.sparkle(par1World, x, y, z, par5Random);
            }
        }
    }

    public void sparkle(World world, int x, int y, int z, Random rand) {
        double offset = 0.0625;
        for (int side = 0; side < 6; ++side) {
            double rx = (float)x + rand.nextFloat();
            double ry = (float)y + rand.nextFloat();
            double rz = (float)z + rand.nextFloat();
            if (side == 0 && !world.func_72804_r(x, y + 1, z)) {
                ry = (double)(y + 1) + offset;
            }
            if (side == 1 && !world.func_72804_r(x, y - 1, z)) {
                ry = (double)(y + 0) - offset;
            }
            if (side == 2 && !world.func_72804_r(x, y, z + 1)) {
                rz = (double)(z + 1) + offset;
            }
            if (side == 3 && !world.func_72804_r(x, y, z - 1)) {
                rz = (double)(z + 0) - offset;
            }
            if (side == 4 && !world.func_72804_r(x + 1, y, z)) {
                rx = (double)(x + 1) + offset;
            }
            if (side == 5 && !world.func_72804_r(x - 1, y, z)) {
                rx = (double)(x + 0) - offset;
            }
            if (!(rx < (double)x || rx > (double)(x + 1) || ry < 0.0 || ry > (double)(y + 1) || rz < (double)z) && !(rz > (double)(z + 1))) continue;
            world.func_72869_a("reddust", rx, ry, rz, 0.0, 0.0, 0.0);
        }
    }

    public static void checkAndActivateVanishBlock(World world, int x, int y, int z) {
        int thereID = world.func_72798_a(x, y, z);
        int thereMeta = world.func_72805_g(x, y, z);
        if (!(thereID != TFBlocks.towerDevice.field_71990_ca || thereMeta != 2 && thereMeta != 5 || BlockTFTowerDevice.areNearbyLockBlocks(world, x, y, z))) {
            BlockTFTowerDevice.changeToActiveVanishBlock(world, x, y, z, 3);
        } else if (thereID == TFBlocks.towerDevice.field_71990_ca && thereMeta == 0 && !BlockTFTowerDevice.areNearbyLockBlocks(world, x, y, z)) {
            BlockTFTowerDevice.changeToActiveVanishBlock(world, x, y, z, 1);
        } else if (thereID == TFBlocks.towerTranslucent.field_71990_ca && thereMeta == 2) {
            BlockTFTowerDevice.changeToActiveVanishBlock(world, x, y, z, 3);
        }
    }

    public static void changeToActiveVanishBlock(World par1World, int x, int y, int z, int meta) {
        BlockTFTowerDevice.changeToBlockMeta(par1World, x, y, z, meta);
        par1World.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.pop", 0.3f, 0.6f);
        int thereBlockID = par1World.func_72798_a(x, y, z);
        par1World.func_72836_a(x, y, z, thereBlockID, BlockTFTowerDevice.getTickRateFor(thereBlockID, meta, par1World.field_73012_v));
    }

    private static int getTickRateFor(int thereBlockID, int meta, Random rand) {
        if (thereBlockID == TFBlocks.towerDevice.field_71990_ca && (meta == 3 || meta == 1)) {
            return 2 + rand.nextInt(5);
        }
        if (thereBlockID == TFBlocks.towerTranslucent.field_71990_ca && meta == 3) {
            return 10;
        }
        return 15;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int blockID = world.func_72798_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (blockID != this.field_71990_ca) {
            return 0;
        }
        switch (meta) {
            case 1: 
            case 3: 
            case 7: {
                return 4;
            }
            case 9: {
                return 10;
            }
            case 11: 
            case 13: {
                return 15;
            }
        }
        return 0;
    }

    public boolean hasTileEntity(int metadata) {
        return metadata == 7 || metadata == 9 || metadata == 13 || metadata == 10 || metadata == 11;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata == 7) {
            return new TileEntityTFTowerBuilder();
        }
        if (metadata == 9) {
            return new TileEntityTFReverter();
        }
        if (metadata == 10) {
            return new TileEntityTFGhastTrapInactive();
        }
        if (metadata == 11) {
            return new TileEntityTFGhastTrapActive();
        }
        if (metadata == 13) {
            return new TileEntityTFCReactorActive();
        }
        return null;
    }

    public int func_71885_a(int meta, Random par2Random, int par3) {
        switch (meta) {
            case 9: {
                return 0;
            }
        }
        return this.field_71990_ca;
    }

    public int func_71899_b(int meta) {
        switch (meta) {
            case 1: {
                return 0;
            }
            case 7: 
            case 8: {
                return 6;
            }
            case 3: {
                return 2;
            }
            case 11: {
                return 10;
            }
            case 13: {
                return 12;
            }
        }
        return meta;
    }

    public void func_71852_a(World par1World, int x, int y, int z, int par5, int meta) {
        super.func_71852_a(par1World, x, y, z, par5, meta);
        if (meta == 7) {
            BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x - 1, y, z);
            BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x + 1, y, z);
            BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x, y + 1, z);
            BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x, y - 1, z);
            BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x, y, z + 1);
            BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x, y, z - 1);
        }
    }
}

