/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.biomes;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.SpawnListEntry;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import twilightforest.TwilightForestMod;
import twilightforest.biomes.TFBiomeCenter;
import twilightforest.biomes.TFBiomeCenter2;
import twilightforest.biomes.TFBiomeClearing;
import twilightforest.biomes.TFBiomeDarkForest;
import twilightforest.biomes.TFBiomeDecorator;
import twilightforest.biomes.TFBiomeDeepMushrooms;
import twilightforest.biomes.TFBiomeEnchantedForest;
import twilightforest.biomes.TFBiomeFireSwamp;
import twilightforest.biomes.TFBiomeGlacier;
import twilightforest.biomes.TFBiomeHighlands;
import twilightforest.biomes.TFBiomeMushrooms;
import twilightforest.biomes.TFBiomeSnow;
import twilightforest.biomes.TFBiomeStream;
import twilightforest.biomes.TFBiomeSwamp;
import twilightforest.biomes.TFBiomeTwilightForest;
import twilightforest.biomes.TFBiomeTwilightForestVariant;
import twilightforest.biomes.TFBiomeTwilightLake;
import twilightforest.entity.passive.EntityTFBighorn;
import twilightforest.entity.passive.EntityTFBoar;
import twilightforest.entity.passive.EntityTFBunny;
import twilightforest.entity.passive.EntityTFDeer;
import twilightforest.entity.passive.EntityTFMobileFirefly;
import twilightforest.entity.passive.EntityTFRaven;
import twilightforest.entity.passive.EntityTFSquirrel;
import twilightforest.entity.passive.EntityTFTinyBird;

public abstract class TFBiomeBase
extends BiomeGenBase {
    public static final BiomeGenBase tfLake;
    public static final BiomeGenBase twilightForest;
    public static final BiomeGenBase twilightForest2;
    public static final BiomeGenBase highlands;
    public static final BiomeGenBase mushrooms;
    public static final BiomeGenBase swamp;
    public static final BiomeGenBase stream;
    public static final BiomeGenBase snow;
    public static final BiomeGenBase glacier;
    public static final BiomeGenBase clearing;
    public static final BiomeGenBase clearingBorder;
    public static final BiomeGenBase lakeBorder;
    public static final BiomeGenBase deepMushrooms;
    public static final BiomeGenBase majorFeature;
    public static final BiomeGenBase minorFeature;
    public static final BiomeGenBase darkForest;
    public static final BiomeGenBase enchantedForest;
    public static final BiomeGenBase fireSwamp;
    protected WorldGenBigMushroom bigMushroomGen = new WorldGenBigMushroom();

    public TFBiomeBase(int i) {
        super(i);
        this.field_76758_O = null;
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_76762_K.clear();
        this.field_76762_K.add(new SpawnListEntry(EntityTFBighorn.class, 12, 4, 4));
        this.field_76762_K.add(new SpawnListEntry(EntityTFBoar.class, 10, 4, 4));
        this.field_76762_K.add(new SpawnListEntry(EntityChicken.class, 10, 4, 4));
        this.field_76762_K.add(new SpawnListEntry(EntityTFDeer.class, 15, 4, 5));
        this.field_76762_K.add(new SpawnListEntry(EntityWolf.class, 5, 4, 4));
        this.field_76762_K.add(new SpawnListEntry(EntityTFTinyBird.class, 15, 4, 8));
        this.field_76762_K.add(new SpawnListEntry(EntityTFSquirrel.class, 10, 2, 4));
        this.field_76762_K.add(new SpawnListEntry(EntityTFBunny.class, 10, 4, 5));
        this.field_76762_K.add(new SpawnListEntry(EntityTFRaven.class, 10, 1, 2));
        this.field_82914_M.add(new SpawnListEntry(EntityTFMobileFirefly.class, 10, 8, 8));
        this.getTFBiomeDecorator().setTreesPerChunk(10);
        this.getTFBiomeDecorator().setGrassPerChunk(2);
    }

    public TFBiomeBase setColor(int par1) {
        return (TFBiomeBase)super.func_76739_b(par1);
    }

    public float func_76741_f() {
        return 0.12f;
    }

    public BiomeDecorator func_76729_a() {
        return new TFBiomeDecorator(this);
    }

    protected TFBiomeDecorator getTFBiomeDecorator() {
        return (TFBiomeDecorator)this.field_76760_I;
    }

    public WorldGenerator func_76740_a(Random random) {
        if (random.nextInt(5) == 0) {
            return this.field_76764_P;
        }
        if (random.nextInt(10) == 0) {
            return new WorldGenBigTree(false);
        }
        return this.field_76757_N;
    }

    public WorldGenerator func_76730_b(Random par1Random) {
        if (par1Random.nextInt(4) == 0) {
            return new WorldGenTallGrass(Block.field_71962_X.field_71990_ca, 2);
        }
        return new WorldGenTallGrass(Block.field_71962_X.field_71990_ca, 1);
    }

    public static boolean isFeature(int idToCheck) {
        return idToCheck == TFBiomeBase.majorFeature.field_76756_M || idToCheck == TFBiomeBase.minorFeature.field_76756_M;
    }

    public static boolean checkForBiomeConflicts() {
        boolean noConflict = true;
        noConflict &= TFBiomeBase.checkBiomeIDisClearOrOurs(TwilightForestMod.idBiomeLake);
        noConflict &= TFBiomeBase.checkBiomeIDisClearOrOurs(TwilightForestMod.idBiomeTwilightForest);
        noConflict &= TFBiomeBase.checkBiomeIDisClearOrOurs(TwilightForestMod.idBiomeTwilightForestVariant);
        noConflict &= TFBiomeBase.checkBiomeIDisClearOrOurs(TwilightForestMod.idBiomeHighlands);
        noConflict &= TFBiomeBase.checkBiomeIDisClearOrOurs(TwilightForestMod.idBiomeMushrooms);
        noConflict &= TFBiomeBase.checkBiomeIDisClearOrOurs(TwilightForestMod.idBiomeSwamp);
        noConflict &= TFBiomeBase.checkBiomeIDisClearOrOurs(TwilightForestMod.idBiomeStream);
        noConflict &= TFBiomeBase.checkBiomeIDisClearOrOurs(TwilightForestMod.idBiomeSnowfield);
        noConflict &= TFBiomeBase.checkBiomeIDisClearOrOurs(TwilightForestMod.idBiomeGlacier);
        noConflict &= TFBiomeBase.checkBiomeIDisClearOrOurs(TwilightForestMod.idBiomeClearing);
        noConflict &= TFBiomeBase.checkBiomeIDisClearOrOurs(TwilightForestMod.idBiomeClearingBorder);
        noConflict &= TFBiomeBase.checkBiomeIDisClearOrOurs(TwilightForestMod.idBiomeLakeBorder);
        noConflict &= TFBiomeBase.checkBiomeIDisClearOrOurs(TwilightForestMod.idBiomeDeepMushrooms);
        noConflict &= TFBiomeBase.checkBiomeIDisClearOrOurs(TwilightForestMod.idBiomeMajorFeature);
        noConflict &= TFBiomeBase.checkBiomeIDisClearOrOurs(TwilightForestMod.idBiomeMinorFeature);
        noConflict &= TFBiomeBase.checkBiomeIDisClearOrOurs(TwilightForestMod.idBiomeDarkForest);
        noConflict &= TFBiomeBase.checkBiomeIDisClearOrOurs(TwilightForestMod.idBiomeEnchantedForest);
        if (!(noConflict &= TFBiomeBase.checkBiomeIDisClearOrOurs(TwilightForestMod.idBiomeFireSwamp))) {
            FMLLog.warning((String)"[TwilightForest] Biome ID conflict detected.  Edit the Twilight Forest config to give all biomes unique IDs.", (Object[])new Object[0]);
        }
        return noConflict;
    }

    public static boolean checkBiomeIDisClearOrOurs(int id) {
        BiomeGenBase biomeAt = BiomeGenBase.field_76773_a[id];
        if (biomeAt == null || biomeAt instanceof TFBiomeBase) {
            return true;
        }
        FMLLog.warning((String)"[TwilightForest] Biome ID conflict.  Biome ID %d contains a biome named %s, but Twilight Forest is set to use that ID.", (Object[])new Object[]{id, biomeAt.field_76791_y});
        return false;
    }

    public static void registerWithBiomeDictionary() {
        BiomeDictionary.registerBiomeType((BiomeGenBase)tfLake, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.WATER});
        BiomeDictionary.registerBiomeType((BiomeGenBase)twilightForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST});
        BiomeDictionary.registerBiomeType((BiomeGenBase)twilightForest2, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST});
        BiomeDictionary.registerBiomeType((BiomeGenBase)highlands, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MOUNTAIN});
        BiomeDictionary.registerBiomeType((BiomeGenBase)mushrooms, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MUSHROOM});
        BiomeDictionary.registerBiomeType((BiomeGenBase)swamp, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SWAMP});
        BiomeDictionary.registerBiomeType((BiomeGenBase)stream, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.WATER});
        BiomeDictionary.registerBiomeType((BiomeGenBase)snow, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.FROZEN});
        BiomeDictionary.registerBiomeType((BiomeGenBase)glacier, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FROZEN});
        BiomeDictionary.registerBiomeType((BiomeGenBase)clearing, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS});
        BiomeDictionary.registerBiomeType((BiomeGenBase)clearingBorder, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST});
        BiomeDictionary.registerBiomeType((BiomeGenBase)lakeBorder, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST});
        BiomeDictionary.registerBiomeType((BiomeGenBase)deepMushrooms, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MUSHROOM});
        BiomeDictionary.registerBiomeType((BiomeGenBase)darkForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST});
        BiomeDictionary.registerBiomeType((BiomeGenBase)enchantedForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MAGICAL});
        BiomeDictionary.registerBiomeType((BiomeGenBase)fireSwamp, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WASTELAND});
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76737_k() {
        double d0 = MathHelper.func_76131_a((float)this.func_76743_j(), (float)0.0f, (float)1.0f);
        double d1 = MathHelper.func_76131_a((float)this.func_76727_i(), (float)0.0f, (float)1.0f);
        return ColorizerGrass.func_77480_a((double)d0, (double)d1);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76726_l() {
        double d0 = MathHelper.func_76131_a((float)this.func_76743_j(), (float)0.0f, (float)1.0f);
        double d1 = MathHelper.func_76131_a((float)this.func_76727_i(), (float)0.0f, (float)1.0f);
        return ColorizerFoliage.func_77470_a((double)d0, (double)d1);
    }

    @SideOnly(value=Side.CLIENT)
    public int getWaterColorMultiplier() {
        return this.field_76759_H;
    }

    static {
        TFBiomeBase.checkForBiomeConflicts();
        tfLake = new TFBiomeTwilightLake(TwilightForestMod.idBiomeLake).setColor(255).func_76735_a("Twilight Lake");
        twilightForest = new TFBiomeTwilightForest(TwilightForestMod.idBiomeTwilightForest).setColor(21760).func_76735_a("Twilight Forest");
        twilightForest2 = new TFBiomeTwilightForestVariant(TwilightForestMod.idBiomeTwilightForestVariant).setColor(21794).func_76735_a("Dense Twilight Forest");
        highlands = new TFBiomeHighlands(TwilightForestMod.idBiomeHighlands).setColor(0x556644).func_76735_a("Highlands");
        mushrooms = new TFBiomeMushrooms(TwilightForestMod.idBiomeMushrooms).setColor(0x446622).func_76735_a("Mushrooms");
        swamp = new TFBiomeSwamp(TwilightForestMod.idBiomeSwamp).setColor(0x334422).func_76735_a("Twilight Swamp");
        stream = new TFBiomeStream(TwilightForestMod.idBiomeStream).setColor(3298231).func_76735_a("Twilight Stream");
        snow = new TFBiomeSnow(TwilightForestMod.idBiomeSnowfield).setColor(0xCCFFFF).func_76735_a("Snowy Forest");
        glacier = new TFBiomeGlacier(TwilightForestMod.idBiomeGlacier).setColor(0x7777BB).func_76735_a("Glacier");
        clearing = new TFBiomeClearing(TwilightForestMod.idBiomeClearing).setColor(3447604).func_76735_a("Twilight Clearing");
        clearingBorder = new TFBiomeTwilightForest(TwilightForestMod.idBiomeClearingBorder).setColor(26112).func_76735_a("Clearing Border");
        lakeBorder = new TFBiomeTwilightForest(TwilightForestMod.idBiomeLakeBorder).setColor(26163).func_76735_a("Lake Border");
        deepMushrooms = new TFBiomeDeepMushrooms(TwilightForestMod.idBiomeDeepMushrooms).setColor(0x663322).func_76735_a("Lots of Mushrooms");
        majorFeature = new TFBiomeCenter(TwilightForestMod.idBiomeMajorFeature).setColor(0xFF0000).func_76735_a("Major Feature");
        minorFeature = new TFBiomeCenter2(TwilightForestMod.idBiomeMinorFeature).setColor(0xAAAA00).func_76735_a("Minor Feature");
        darkForest = new TFBiomeDarkForest(TwilightForestMod.idBiomeDarkForest).setColor(13073).func_76735_a("Dark Forest");
        enchantedForest = new TFBiomeEnchantedForest(TwilightForestMod.idBiomeEnchantedForest).setColor(0x115566).func_76735_a("Enchanted Forest");
        fireSwamp = new TFBiomeFireSwamp(TwilightForestMod.idBiomeFireSwamp).setColor(4334362).func_76735_a("Fire Swamp");
    }
}

