/*
 * Decompiled with CFR 0.152.
 */
package argo.staj;

import argo.staj.InvalidSyntaxRuntimeException;
import argo.staj.JsonStreamElement;
import argo.staj.PositionTrackingPushbackReader;
import argo.staj.ThingWithPosition;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Stack;

public enum JsonStreamElementType {
    START_ARRAY{

        @Override
        JsonStreamElement parseNext(PositionTrackingPushbackReader pushbackReader, Stack<JsonStreamElementType> stack) {
            char secondChar = (char)JsonStreamElementType.readNextNonWhitespaceChar(pushbackReader);
            if (secondChar != ']') {
                pushbackReader.unread(secondChar);
                return JsonStreamElementType.aJsonValue(pushbackReader, stack);
            }
            stack.pop();
            return JsonStreamElement.endArray();
        }
    }
    ,
    END_ARRAY{

        @Override
        JsonStreamElement parseNext(PositionTrackingPushbackReader pushbackReader, Stack<JsonStreamElementType> stack) {
            return JsonStreamElementType.parseFromTheEndOfARootNode(pushbackReader, stack);
        }
    }
    ,
    START_OBJECT{

        @Override
        JsonStreamElement parseNext(PositionTrackingPushbackReader pushbackReader, Stack<JsonStreamElementType> stack) {
            return JsonStreamElementType.parseFieldOrObjectEnd(pushbackReader, stack);
        }
    }
    ,
    END_OBJECT{

        @Override
        JsonStreamElement parseNext(PositionTrackingPushbackReader pushbackReader, Stack<JsonStreamElementType> stack) {
            return JsonStreamElementType.parseFromTheEndOfARootNode(pushbackReader, stack);
        }
    }
    ,
    START_FIELD{

        @Override
        JsonStreamElement parseNext(PositionTrackingPushbackReader pushbackReader, Stack<JsonStreamElementType> stack) {
            char separatorChar = (char)JsonStreamElementType.readNextNonWhitespaceChar(pushbackReader);
            if (separatorChar != ':') {
                throw InvalidSyntaxRuntimeException.invalidSyntaxRuntimeException("Expected object identifier to be followed by : but got [" + separatorChar + "].", pushbackReader);
            }
            return JsonStreamElementType.aJsonValue(pushbackReader, stack);
        }
    }
    ,
    END_FIELD{

        @Override
        JsonStreamElement parseNext(PositionTrackingPushbackReader pushbackReader, Stack<JsonStreamElementType> stack) {
            return JsonStreamElementType.parseFieldOrObjectEnd(pushbackReader, stack);
        }
    }
    ,
    STRING{

        @Override
        JsonStreamElement parseNext(PositionTrackingPushbackReader pushbackReader, Stack<JsonStreamElementType> stack) {
            return JsonStreamElementType.parseFromEndOfNode(pushbackReader, stack);
        }
    }
    ,
    TRUE{

        @Override
        JsonStreamElement parseNext(PositionTrackingPushbackReader pushbackReader, Stack<JsonStreamElementType> stack) {
            return JsonStreamElementType.parseFromEndOfNode(pushbackReader, stack);
        }
    }
    ,
    FALSE{

        @Override
        JsonStreamElement parseNext(PositionTrackingPushbackReader pushbackReader, Stack<JsonStreamElementType> stack) {
            return JsonStreamElementType.parseFromEndOfNode(pushbackReader, stack);
        }
    }
    ,
    NULL{

        @Override
        JsonStreamElement parseNext(PositionTrackingPushbackReader pushbackReader, Stack<JsonStreamElementType> stack) {
            return JsonStreamElementType.parseFromEndOfNode(pushbackReader, stack);
        }
    }
    ,
    NUMBER{

        @Override
        JsonStreamElement parseNext(PositionTrackingPushbackReader pushbackReader, Stack<JsonStreamElementType> stack) {
            return JsonStreamElementType.parseFromEndOfNode(pushbackReader, stack);
        }
    }
    ,
    START_DOCUMENT{

        @Override
        JsonStreamElement parseNext(PositionTrackingPushbackReader pushbackReader, Stack<JsonStreamElementType> stack) {
            char nextChar = (char)pushbackReader.read();
            switch (nextChar) {
                case '{': {
                    stack.push(START_OBJECT);
                    return JsonStreamElement.startObject();
                }
                case '[': {
                    stack.push(START_ARRAY);
                    return JsonStreamElement.startArray();
                }
            }
            throw InvalidSyntaxRuntimeException.invalidSyntaxRuntimeException("Expected either [ or { but got [" + nextChar + "].", pushbackReader);
        }
    }
    ,
    END_DOCUMENT{

        @Override
        JsonStreamElement parseNext(PositionTrackingPushbackReader pushbackReader, Stack<JsonStreamElementType> stack) {
            throw new NoSuchElementException("Document complete");
        }
    };

    private static final char DOUBLE_QUOTE = '\"';
    private static final char BACK_SLASH = '\\';
    private static final char BACKSPACE = '\b';
    private static final char TAB = '\t';
    private static final char NEWLINE = '\n';
    private static final char CARRIAGE_RETURN = '\r';
    private static final char FORM_FEED = '\f';

    abstract JsonStreamElement parseNext(PositionTrackingPushbackReader var1, Stack<JsonStreamElementType> var2);

    static JsonStreamElement parseFirstElement(PositionTrackingPushbackReader pushbackReader) throws InvalidSyntaxRuntimeException {
        char nextChar = (char)pushbackReader.read();
        if (nextChar == '{' || nextChar == '[') {
            pushbackReader.unread(nextChar);
            return JsonStreamElement.startDocument();
        }
        throw InvalidSyntaxRuntimeException.invalidSyntaxRuntimeException("Expected either [ or { but got [" + nextChar + "].", pushbackReader);
    }

    private static JsonStreamElement parseFieldOrObjectEnd(PositionTrackingPushbackReader pushbackReader, Stack<JsonStreamElementType> stack) {
        char nextChar = (char)JsonStreamElementType.readNextNonWhitespaceChar(pushbackReader);
        if (nextChar != '}') {
            pushbackReader.unread(nextChar);
            return JsonStreamElementType.aFieldToken(pushbackReader, stack);
        }
        stack.pop();
        return JsonStreamElement.endObject();
    }

    private static JsonStreamElement parseFromTheEndOfARootNode(PositionTrackingPushbackReader pushbackReader, Stack<JsonStreamElementType> stack) {
        int nextChar = JsonStreamElementType.readNextNonWhitespaceChar(pushbackReader);
        if (stack.isEmpty()) {
            if (nextChar != -1) {
                throw InvalidSyntaxRuntimeException.invalidSyntaxRuntimeException("Got unexpected trailing character [" + (char)nextChar + "].", pushbackReader);
            }
            return JsonStreamElement.endDocument();
        }
        pushbackReader.unread((char)nextChar);
        return JsonStreamElementType.parseFromEndOfNode(pushbackReader, stack);
    }

    private static JsonStreamElement parseFromEndOfNode(PositionTrackingPushbackReader pushbackReader, Stack<JsonStreamElementType> stack) {
        int nextChar = JsonStreamElementType.readNextNonWhitespaceChar(pushbackReader);
        JsonStreamElementType peek = stack.peek();
        if (peek.equals((Object)START_OBJECT)) {
            switch (nextChar) {
                case 44: {
                    return JsonStreamElementType.aJsonValue(pushbackReader, stack);
                }
                case 125: {
                    stack.pop();
                    return JsonStreamElement.endObject();
                }
            }
            throw InvalidSyntaxRuntimeException.invalidSyntaxRuntimeException("Expected either , or } but got [" + nextChar + "].", pushbackReader);
        }
        if (peek.equals((Object)START_ARRAY)) {
            switch (nextChar) {
                case 44: {
                    return JsonStreamElementType.aJsonValue(pushbackReader, stack);
                }
                case 93: {
                    stack.pop();
                    return JsonStreamElement.endArray();
                }
            }
            throw InvalidSyntaxRuntimeException.invalidSyntaxRuntimeException("Expected either , or ] but got [" + nextChar + "].", pushbackReader);
        }
        switch (nextChar) {
            case 44: {
                stack.pop();
                return JsonStreamElement.endField();
            }
            case 125: {
                stack.pop();
                pushbackReader.unread((char)nextChar);
                return JsonStreamElement.endField();
            }
        }
        throw InvalidSyntaxRuntimeException.invalidSyntaxRuntimeException("Expected either , or ] but got [" + nextChar + "].", pushbackReader);
    }

    private static int readNextNonWhitespaceChar(PositionTrackingPushbackReader in) {
        int nextChar;
        boolean gotNonWhitespace = false;
        do {
            nextChar = in.read();
            switch (nextChar) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    break;
                }
                default: {
                    gotNonWhitespace = true;
                }
            }
        } while (!gotNonWhitespace);
        return nextChar;
    }

    private static JsonStreamElement aJsonValue(PositionTrackingPushbackReader pushbackReader, Stack<JsonStreamElementType> stack) {
        char nextChar = (char)JsonStreamElementType.readNextNonWhitespaceChar(pushbackReader);
        switch (nextChar) {
            case '\"': {
                pushbackReader.unread(nextChar);
                return JsonStreamElement.string(JsonStreamElementType.stringToken(pushbackReader));
            }
            case 't': {
                char[] remainingTrueTokenCharacters = new char[3];
                int trueTokenCharactersRead = pushbackReader.read(remainingTrueTokenCharacters);
                if (trueTokenCharactersRead != 3 || remainingTrueTokenCharacters[0] != 'r' || remainingTrueTokenCharacters[1] != 'u' || remainingTrueTokenCharacters[2] != 'e') {
                    pushbackReader.uncount(remainingTrueTokenCharacters);
                    throw InvalidSyntaxRuntimeException.invalidSyntaxRuntimeException("Expected 't' to be followed by [[r, u, e]], but got [" + Arrays.toString(remainingTrueTokenCharacters) + "].", pushbackReader);
                }
                return JsonStreamElement.trueValue();
            }
            case 'f': {
                char[] remainingFalseTokenCharacters = new char[4];
                int falseTokenCharactersRead = pushbackReader.read(remainingFalseTokenCharacters);
                if (falseTokenCharactersRead != 4 || remainingFalseTokenCharacters[0] != 'a' || remainingFalseTokenCharacters[1] != 'l' || remainingFalseTokenCharacters[2] != 's' || remainingFalseTokenCharacters[3] != 'e') {
                    pushbackReader.uncount(remainingFalseTokenCharacters);
                    throw InvalidSyntaxRuntimeException.invalidSyntaxRuntimeException("Expected 'f' to be followed by [[a, l, s, e]], but got [" + Arrays.toString(remainingFalseTokenCharacters) + "].", pushbackReader);
                }
                return JsonStreamElement.falseValue();
            }
            case 'n': {
                char[] remainingNullTokenCharacters = new char[3];
                int nullTokenCharactersRead = pushbackReader.read(remainingNullTokenCharacters);
                if (nullTokenCharactersRead != 3 || remainingNullTokenCharacters[0] != 'u' || remainingNullTokenCharacters[1] != 'l' || remainingNullTokenCharacters[2] != 'l') {
                    pushbackReader.uncount(remainingNullTokenCharacters);
                    throw InvalidSyntaxRuntimeException.invalidSyntaxRuntimeException("Expected 'n' to be followed by [[u, l, l]], but got [" + Arrays.toString(remainingNullTokenCharacters) + "].", pushbackReader);
                }
                return JsonStreamElement.nullValue();
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                pushbackReader.unread(nextChar);
                return JsonStreamElement.number(JsonStreamElementType.numberToken(pushbackReader));
            }
            case '{': {
                stack.push(START_OBJECT);
                return JsonStreamElement.startObject();
            }
            case '[': {
                stack.push(START_ARRAY);
                return JsonStreamElement.startArray();
            }
        }
        throw InvalidSyntaxRuntimeException.invalidSyntaxRuntimeException("Invalid character at start of value [" + nextChar + "].", pushbackReader);
    }

    private static JsonStreamElement aFieldToken(PositionTrackingPushbackReader pushbackReader, Stack<JsonStreamElementType> stack) {
        char nextChar = (char)JsonStreamElementType.readNextNonWhitespaceChar(pushbackReader);
        if ('\"' != nextChar) {
            throw InvalidSyntaxRuntimeException.invalidSyntaxRuntimeException("Expected object identifier to begin with [\"] but got [" + nextChar + "].", pushbackReader);
        }
        pushbackReader.unread(nextChar);
        stack.push(START_FIELD);
        return JsonStreamElement.startField(JsonStreamElementType.stringToken(pushbackReader));
    }

    private static String stringToken(PositionTrackingPushbackReader in) {
        StringBuilder result = new StringBuilder();
        char firstChar = (char)in.read();
        if ('\"' != firstChar) {
            throw InvalidSyntaxRuntimeException.invalidSyntaxRuntimeException("Expected [\"] but got [" + firstChar + "].", in);
        }
        ThingWithPosition openDoubleQuotesPosition = in.snapshotOfPosition();
        boolean stringClosed = false;
        block5: while (!stringClosed) {
            char nextChar = (char)in.read();
            switch (nextChar) {
                case '\uffff': {
                    throw InvalidSyntaxRuntimeException.invalidSyntaxRuntimeException("Got opening [\"] without matching closing [\"]", openDoubleQuotesPosition);
                }
                case '\"': {
                    stringClosed = true;
                    continue block5;
                }
                case '\\': {
                    char escapedChar = JsonStreamElementType.escapedStringChar(in);
                    result.append(escapedChar);
                    continue block5;
                }
            }
            result.append(nextChar);
        }
        return result.toString();
    }

    private static char escapedStringChar(PositionTrackingPushbackReader in) {
        char result;
        char firstChar = (char)in.read();
        switch (firstChar) {
            case '\"': {
                result = '\"';
                break;
            }
            case '\\': {
                result = '\\';
                break;
            }
            case '/': {
                result = '/';
                break;
            }
            case 'b': {
                result = '\b';
                break;
            }
            case 'f': {
                result = '\f';
                break;
            }
            case 'n': {
                result = '\n';
                break;
            }
            case 'r': {
                result = '\r';
                break;
            }
            case 't': {
                result = '\t';
                break;
            }
            case 'u': {
                result = (char)JsonStreamElementType.hexadecimalNumber(in);
                break;
            }
            default: {
                throw InvalidSyntaxRuntimeException.invalidSyntaxRuntimeException("Unrecognised escape character [" + firstChar + "].", in);
            }
        }
        return result;
    }

    private static int hexadecimalNumber(PositionTrackingPushbackReader in) {
        int result;
        char[] resultCharArray = new char[4];
        int readSize = in.read(resultCharArray);
        if (readSize != 4) {
            throw InvalidSyntaxRuntimeException.invalidSyntaxRuntimeException("Expected a 4 digit hexadecimal number but got only [" + readSize + "], namely [" + String.valueOf(resultCharArray, 0, readSize) + "].", in);
        }
        try {
            result = Integer.parseInt(String.valueOf(resultCharArray), 16);
        }
        catch (NumberFormatException e) {
            in.uncount(resultCharArray);
            throw InvalidSyntaxRuntimeException.invalidSyntaxRuntimeException("Unable to parse [" + String.valueOf(resultCharArray) + "] as a hexadecimal number.", e, in);
        }
        return result;
    }

    private static String numberToken(PositionTrackingPushbackReader in) {
        StringBuilder result = new StringBuilder();
        char firstChar = (char)in.read();
        if ('-' == firstChar) {
            result.append('-');
        } else {
            in.unread(firstChar);
        }
        result.append(JsonStreamElementType.nonNegativeNumberToken(in));
        return result.toString();
    }

    private static String nonNegativeNumberToken(PositionTrackingPushbackReader in) {
        StringBuilder result = new StringBuilder();
        char firstChar = (char)in.read();
        if ('0' == firstChar) {
            result.append('0');
            result.append(JsonStreamElementType.possibleFractionalComponent(in));
            result.append(JsonStreamElementType.possibleExponent(in));
        } else {
            in.unread(firstChar);
            result.append(JsonStreamElementType.nonZeroDigitToken(in));
            result.append(JsonStreamElementType.digitString(in));
            result.append(JsonStreamElementType.possibleFractionalComponent(in));
            result.append(JsonStreamElementType.possibleExponent(in));
        }
        return result.toString();
    }

    private static char nonZeroDigitToken(PositionTrackingPushbackReader in) {
        char result;
        char nextChar = (char)in.read();
        switch (nextChar) {
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                result = nextChar;
                break;
            }
            default: {
                throw InvalidSyntaxRuntimeException.invalidSyntaxRuntimeException("Expected a digit 1 - 9 but got [" + nextChar + "].", in);
            }
        }
        return result;
    }

    private static char digitToken(PositionTrackingPushbackReader in) {
        char result;
        char nextChar = (char)in.read();
        switch (nextChar) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                result = nextChar;
                break;
            }
            default: {
                throw InvalidSyntaxRuntimeException.invalidSyntaxRuntimeException("Expected a digit 1 - 9 but got [" + nextChar + "].", in);
            }
        }
        return result;
    }

    private static String digitString(PositionTrackingPushbackReader in) {
        StringBuilder result = new StringBuilder();
        boolean gotANonDigit = false;
        block3: while (!gotANonDigit) {
            char nextChar = (char)in.read();
            switch (nextChar) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    result.append(nextChar);
                    continue block3;
                }
            }
            gotANonDigit = true;
            in.unread(nextChar);
        }
        return result.toString();
    }

    private static String possibleFractionalComponent(PositionTrackingPushbackReader pushbackReader) {
        StringBuilder result = new StringBuilder();
        char firstChar = (char)pushbackReader.read();
        if (firstChar == '.') {
            result.append('.');
            result.append(JsonStreamElementType.digitToken(pushbackReader));
            result.append(JsonStreamElementType.digitString(pushbackReader));
        } else {
            pushbackReader.unread(firstChar);
        }
        return result.toString();
    }

    private static String possibleExponent(PositionTrackingPushbackReader pushbackReader) {
        StringBuilder result = new StringBuilder();
        char firstChar = (char)pushbackReader.read();
        switch (firstChar) {
            case '.': 
            case 'E': {
                result.append('E');
                result.append(JsonStreamElementType.possibleSign(pushbackReader));
                result.append(JsonStreamElementType.digitToken(pushbackReader));
                result.append(JsonStreamElementType.digitString(pushbackReader));
                break;
            }
            case 'e': {
                result.append('e');
                result.append(JsonStreamElementType.possibleSign(pushbackReader));
                result.append(JsonStreamElementType.digitToken(pushbackReader));
                result.append(JsonStreamElementType.digitString(pushbackReader));
                break;
            }
            default: {
                pushbackReader.unread(firstChar);
            }
        }
        return result.toString();
    }

    private static String possibleSign(PositionTrackingPushbackReader pushbackReader) {
        StringBuilder result = new StringBuilder();
        char firstChar = (char)pushbackReader.read();
        if (firstChar == '+' || firstChar == '-') {
            result.append(firstChar);
        } else {
            pushbackReader.unread(firstChar);
        }
        return result.toString();
    }
}

