/*
 * Decompiled with CFR 0.152.
 */
package dk.zlepper.itlt;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import dk.zlepper.itlt.proxies.ClientProxy;
import dk.zlepper.itlt.proxies.CommonProxy;
import dk.zlepper.itlt.threads.ShouterThread;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

@Mod(modid="itlt", version="1.0.0", name="It's the little things", acceptedMinecraftVersions="[1.5.1,1.5.2]")
public class Itlt {
    @Mod.Instance(value="itlt")
    public static Itlt instance;
    @SidedProxy(clientSide="dk.zlepper.itlt.proxies.ClientProxy", serverSide="dk.zlepper.itlt.proxies.ServerProxy")
    public static CommonProxy proxy;
    public static Logger logger;
    private boolean makeScreenBigger;
    private String windowDisplayTitle;

    @Mod.PreInit
    public void preinit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        if (proxy instanceof ClientProxy) {
            Configuration config = new Configuration(event.getSuggestedConfigurationFile());
            config.load();
            Property javaBitDetectionProp = config.get("BitDetection", "ShouldYellAt32BitUsers", false);
            javaBitDetectionProp.comment = "Set to true to make itlt yell at people attempting to use 32x java for the modpack.";
            String yelling = javaBitDetectionProp.getBoolean(false) ? "We are yelling at people" : "We are NOT yelling at people";
            logger.info(yelling);
            Property javaBitIssueMessageProp = config.get("BitDetection", "ErrorMessage", "You are using a 32 bit version of java. This is not recommended with this modpack.");
            javaBitIssueMessageProp.comment = "If ShouldYellAt32BitUsers is set to true, this is the message that will be displayed to the user.";
            if (javaBitDetectionProp.getBoolean(false) && !Itlt.isJava64bit()) {
                ShouterThread st = new ShouterThread(javaBitIssueMessageProp.getString());
                st.start();
            }
            Property shouldMaximizeDisplayProp = config.get("Display", "ShouldMaximizeDisplay", false);
            shouldMaximizeDisplayProp.comment = "Set to true to make minecraft attempt to maximize itself on startup (This is kinda unstable right now, so don't trust it too much)";
            this.makeScreenBigger = shouldMaximizeDisplayProp.getBoolean(false);
            Property addCustomServerProp = config.get("Server", "AddDedicatedServer", false);
            addCustomServerProp.comment = "Set to true to have a dedicated server added to the server list ingame. The server will not overwrite others servers.";
            Property customServerNameProp = config.get("Server", "ServerName", "Localhost");
            customServerNameProp.comment = "The name of the dedicated server to add.";
            Property customServerIpProp = config.get("Server", "ServerIP", "127.0.0.1:25555");
            customServerIpProp.comment = "The ip of the dedicated server to add.";
            if (addCustomServerProp.getBoolean(false)) {
                bea serverList = new bea(Minecraft.x());
                int c = serverList.c();
                boolean foundServer = false;
                for (int i = 0; i < c; ++i) {
                    bdz data = serverList.a(i);
                    if (!data.b.equals(customServerIpProp.getString())) continue;
                    foundServer = true;
                    break;
                }
                if (!foundServer) {
                    bdz data = new bdz(customServerNameProp.getString(), customServerIpProp.getString());
                    serverList.a(data);
                    serverList.b();
                }
            }
            config.save();
        } else {
            logger.info("Itlt initialized on server, as itlt is purely clientside we aren't doing much. ");
        }
    }

    private Path getAssetDir() {
        Path currentRelativePath = Paths.get("", new String[0]).toAbsolutePath();
        String slugname = currentRelativePath.getFileName().toString();
        Path directParent = currentRelativePath.getParent();
        if (directParent == null) {
            return currentRelativePath;
        }
        Path technic = directParent.getParent();
        if (technic == null) {
            return currentRelativePath;
        }
        return Paths.get(technic.toAbsolutePath().toString(), "assets", "packs", slugname);
    }

    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent event) {
        if (proxy instanceof ClientProxy) {
            ClientProxy cp = (ClientProxy)proxy;
            if (this.makeScreenBigger && !ClientProxy.changed) {
                cp.changeScreen();
            }
            cp.setWindowDisplayTitle(this.windowDisplayTitle);
        }
    }

    private static boolean isJava64bit() {
        String[] astring;
        for (String s : astring = new String[]{"sun.arch.data.model", "com.ibm.vm.bitmode", "os.arch"}) {
            String s1 = System.getProperty(s);
            if (s1 == null || !s1.contains("64")) continue;
            return true;
        }
        return false;
    }
}

