/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.client.modules;

import atomicstryker.dynamiclights.client.DynamicLights;
import atomicstryker.dynamiclights.client.IDynamicLightSource;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

@Mod(modid="DynamicLights_mobEquipment", name="Dynamic Lights on Mob Equipment", version="1.0.0", dependencies="required-after:DynamicLights")
public class EntityLivingEquipmentLightSource {
    private Minecraft mcinstance;
    private long nextUpdate;
    private long updateInterval;
    private ArrayList trackedEntities;
    private Thread thread;
    private boolean threadRunning;
    private HashMap itemsMap;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent evt) {
        String[] tokens;
        Configuration config = new Configuration(evt.getSuggestedConfigurationFile());
        config.load();
        Property updateI = config.get("general", "update Interval", 1000);
        updateI.comment = "Update Interval time for all EntityLiving in milliseconds. The lower the better and costlier.";
        this.updateInterval = updateI.getInt();
        this.itemsMap = new HashMap();
        Property itemsList = config.get("general", "LightItems", "50:15,89:12,348:10,91:15,327:15,76:10,331:10,314:14");
        itemsList.comment = "Item and Armor IDs that shine light when found on any EntityLiving. Syntax: ItemID:LightValue, seperated by commas";
        for (String pair : tokens = itemsList.getString().split(",")) {
            String[] values = pair.split(":");
            int id = Integer.valueOf(values[0]);
            int value = Integer.valueOf(values[1]);
            this.itemsMap.put(id, value);
        }
        config.save();
    }

    @Mod.Init
    public void load(FMLInitializationEvent evt) {
        this.mcinstance = FMLClientHandler.instance().getClient();
        this.nextUpdate = System.currentTimeMillis();
        this.trackedEntities = new ArrayList();
        this.threadRunning = false;
        TickRegistry.registerTickHandler((ITickHandler)new TickHandler(), (Side)Side.CLIENT);
    }

    private boolean hasShinyEquipment(ng ent) {
        return this.getLightFromItemStack(ent.p(0)) > 0 || this.getLightFromItemStack(ent.p(4)) > 0;
    }

    private int getLightFromItemStack(wm stack) {
        Integer i;
        if (stack != null && (i = (Integer)this.itemsMap.get(stack.c)) != null) {
            return i;
        }
        return 0;
    }

    private class EntityLightAdapter
    implements IDynamicLightSource {
        private ng entity;
        private int lightLevel = 0;
        private boolean enabled = false;

        public EntityLightAdapter(ng e) {
            this.entity = e;
        }

        public void onTick() {
            this.lightLevel = Math.max(EntityLivingEquipmentLightSource.this.getLightFromItemStack(this.entity.p(0)), EntityLivingEquipmentLightSource.this.getLightFromItemStack(this.entity.p(4)));
            if (this.entity.getEntityData().i("InfernalMobsMod") != null) {
                this.lightLevel = 15;
            }
            if (!this.enabled && this.lightLevel > 8) {
                this.enableLight();
            } else if (this.enabled && this.lightLevel < 9) {
                this.disableLight();
            }
        }

        private void enableLight() {
            DynamicLights.addLightSource(this);
            this.enabled = true;
        }

        private void disableLight() {
            DynamicLights.removeLightSource(this);
            this.enabled = false;
        }

        @Override
        public mp getAttachmentEntity() {
            return this.entity;
        }

        @Override
        public int getLightLevel() {
            return this.lightLevel;
        }
    }

    private class EntityListChecker
    extends Thread {
        private final Object[] list;

        public EntityListChecker(List input) {
            this.list = input.toArray();
        }

        @Override
        public void run() {
            ArrayList<EntityLightAdapter> newList = new ArrayList<EntityLightAdapter>();
            for (Object o : this.list) {
                mp ent = (mp)o;
                if (!(ent instanceof ng) || !ent.R() || ent instanceof sq || !EntityLivingEquipmentLightSource.this.hasShinyEquipment((ng)ent)) continue;
                boolean found = false;
                Iterator iter = EntityLivingEquipmentLightSource.this.trackedEntities.iterator();
                EntityLightAdapter adapter = null;
                while (iter.hasNext()) {
                    adapter = (EntityLightAdapter)iter.next();
                    if (!adapter.getAttachmentEntity().equals((Object)ent)) continue;
                    adapter.onTick();
                    newList.add(adapter);
                    found = true;
                    iter.remove();
                    break;
                }
                if (found) continue;
                adapter = new EntityLightAdapter((ng)ent);
                adapter.onTick();
                newList.add(adapter);
            }
            for (EntityLightAdapter adapter : EntityLivingEquipmentLightSource.this.trackedEntities) {
                adapter.onTick();
            }
            EntityLivingEquipmentLightSource.this.trackedEntities = newList;
            EntityLivingEquipmentLightSource.this.threadRunning = false;
        }
    }

    private class TickHandler
    implements ITickHandler {
        private final EnumSet ticks = EnumSet.of(TickType.CLIENT);

        public void tickStart(EnumSet type, Object ... tickData) {
        }

        public void tickEnd(EnumSet type, Object ... tickData) {
            if (((EntityLivingEquipmentLightSource)EntityLivingEquipmentLightSource.this).mcinstance.e != null && System.currentTimeMillis() > EntityLivingEquipmentLightSource.this.nextUpdate && !DynamicLights.globalLightsOff()) {
                EntityLivingEquipmentLightSource.this.nextUpdate = System.currentTimeMillis() + EntityLivingEquipmentLightSource.this.updateInterval;
                if (!EntityLivingEquipmentLightSource.this.threadRunning) {
                    EntityLivingEquipmentLightSource.this.thread = new EntityListChecker(((EntityLivingEquipmentLightSource)EntityLivingEquipmentLightSource.this).mcinstance.e.e);
                    EntityLivingEquipmentLightSource.this.thread.setPriority(1);
                    EntityLivingEquipmentLightSource.this.thread.start();
                    EntityLivingEquipmentLightSource.this.threadRunning = true;
                }
            }
        }

        public EnumSet ticks() {
            return this.ticks;
        }

        public String getLabel() {
            return "DynamicLights_onFire";
        }
    }
}

