/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.util.player;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.relauncher.Side;
import java.lang.ref.WeakReference;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import mods.tinker.tconstruct.common.TContent;
import mods.tinker.tconstruct.library.tools.AbilityHelper;
import mods.tinker.tconstruct.util.PHConstruct;
import mods.tinker.tconstruct.util.player.ArmorExtended;
import mods.tinker.tconstruct.util.player.TFoodStats;
import mods.tinker.tconstruct.util.player.TPlayerStats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumEntitySize;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;

public class TPlayerHandler
implements IPlayerTracker {
    public ConcurrentHashMap playerStats = new ConcurrentHashMap();
    Random rand = new Random();

    public void onPlayerLogin(EntityPlayer entityplayer) {
        TFoodStats food = new TFoodStats();
        food.readStats(entityplayer.field_71100_bB);
        entityplayer.field_71100_bB = food;
        NBTTagCompound tags = entityplayer.getEntityData();
        if (!tags.func_74764_b("TConstruct")) {
            tags.func_74766_a("TConstruct", new NBTTagCompound());
        }
        TPlayerStats stats = new TPlayerStats();
        stats.player = new WeakReference<EntityPlayer>(entityplayer);
        stats.armor = new ArmorExtended();
        stats.armor.init(entityplayer);
        stats.armor.loadFromNBT(entityplayer);
        stats.level = entityplayer.field_71068_ca;
        stats.health = entityplayer.maxHealth;
        stats.hunger = entityplayer.func_71024_bL().func_75116_a();
        stats.beginnerManual = tags.func_74775_l("TConstruct").func_74767_n("beginnerManual");
        stats.materialManual = tags.func_74775_l("TConstruct").func_74767_n("materialManual");
        stats.smelteryManual = tags.func_74775_l("TConstruct").func_74767_n("smelteryManual");
        if (!stats.beginnerManual) {
            tags.func_74775_l("TConstruct").func_74757_a("beginnerManual", true);
            ItemStack diary = new ItemStack(TContent.manualBook);
            if (!entityplayer.field_71071_by.func_70441_a(diary)) {
                AbilityHelper.spawnItemAtPlayer(entityplayer, diary);
            }
        }
        this.playerStats.put(entityplayer.field_71092_bJ, stats);
    }

    public void onPlayerLogout(EntityPlayer entityplayer) {
        if (entityplayer != null) {
            this.getPlayerStats((String)entityplayer.field_71092_bJ).armor.saveToNBT(entityplayer);
            this.playerStats.remove(entityplayer.field_71092_bJ);
        }
    }

    public void onPlayerChangedDimension(EntityPlayer entityplayer) {
    }

    public void onPlayerRespawn(EntityPlayer entityplayer) {
        TPlayerStats stats = this.getPlayerStats(entityplayer.field_71092_bJ);
        stats.player = new WeakReference<EntityPlayer>(entityplayer);
        TFoodStats food = new TFoodStats();
        entityplayer.field_71100_bB = food;
        if (PHConstruct.keepLevels) {
            entityplayer.field_71068_ca = stats.level;
        }
        if (PHConstruct.keepHunger) {
            entityplayer.func_71024_bL().func_75122_a(-1 * (20 - stats.hunger), 0.0f);
        }
        NBTTagCompound tags = entityplayer.getEntityData();
        NBTTagCompound tTag = new NBTTagCompound();
        tTag.func_74757_a("beginnerManual", stats.beginnerManual);
        tTag.func_74757_a("materialManual", stats.materialManual);
        tTag.func_74757_a("smelteryManual", stats.smelteryManual);
        tags.func_74766_a("TConstruct", tTag);
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.CLIENT && PHConstruct.keepHunger) {
            entityplayer.func_71024_bL().func_75114_a(stats.hunger);
        }
    }

    @ForgeSubscribe
    public void livingFall(LivingFallEvent evt) {
        if (evt.entityLiving instanceof EntityPlayer) {
            evt.distance -= 1.0f;
        }
    }

    @ForgeSubscribe
    public void playerDrops(PlayerDropsEvent evt) {
        TPlayerStats stats = this.getPlayerStats(evt.entityPlayer.field_71092_bJ);
        stats.level = evt.entityPlayer.field_71068_ca / 2;
        int hunger = evt.entityPlayer.func_71024_bL().func_75116_a();
        stats.hunger = hunger < 6 ? 6 : evt.entityPlayer.func_71024_bL().func_75116_a();
    }

    public TPlayerStats getPlayerStats(String username) {
        TPlayerStats stats = (TPlayerStats)this.playerStats.get(username);
        if (stats == null) {
            stats = new TPlayerStats();
            this.playerStats.put(username, stats);
        }
        return stats;
    }

    public EntityPlayer getEntityPlayer(String username) {
        TPlayerStats stats = (TPlayerStats)this.playerStats.get(username);
        if (stats == null) {
            return null;
        }
        return (EntityPlayer)stats.player.get();
    }

    public void updateSize(String user, float offset) {
    }

    public static void setEntitySize(float width, float height, Entity entity) {
        float que;
        if (width != entity.field_70130_N || height != entity.field_70131_O) {
            entity.field_70130_N = width;
            entity.field_70131_O = height;
            entity.field_70121_D.field_72336_d = entity.field_70121_D.field_72340_a + (double)entity.field_70130_N;
            entity.field_70121_D.field_72334_f = entity.field_70121_D.field_72339_c + (double)entity.field_70130_N;
            entity.field_70121_D.field_72337_e = entity.field_70121_D.field_72338_b + (double)entity.field_70131_O;
        }
        entity.field_70168_am = (double)(que = width % 2.0f) < 0.375 ? EnumEntitySize.SIZE_1 : ((double)que < 0.75 ? EnumEntitySize.SIZE_2 : ((double)que < 1.0 ? EnumEntitySize.SIZE_3 : ((double)que < 1.375 ? EnumEntitySize.SIZE_4 : ((double)que < 1.75 ? EnumEntitySize.SIZE_5 : EnumEntitySize.SIZE_6))));
    }
}

