/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.util.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import mods.tinker.tconstruct.TConstruct;
import mods.tinker.tconstruct.blocks.logic.ToolStationLogic;
import mods.tinker.tconstruct.common.TProxyCommon;
import mods.tinker.tconstruct.library.blocks.InventoryLogic;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class TPacketHandler
implements IPacketHandler {
    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (packet.field_73630_a.equals("TConstruct")) {
            if (side == Side.SERVER) {
                this.handleServerPacket(packet);
            } else {
                this.handleClientPacket(packet);
            }
        }
    }

    void handleClientPacket(Packet250CustomPayload packet) {
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        try {
            byte packetID = inputStream.readByte();
            int dimension = inputStream.readInt();
            WorldServer world = DimensionManager.getWorld((int)dimension);
        }
        catch (IOException e) {
            System.out.println("Failed at reading client packet for TConstruct.");
            e.printStackTrace();
            return;
        }
    }

    void handleServerPacket(Packet250CustomPayload packet) {
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        try {
            byte packetID = inputStream.readByte();
            if (packetID == 1) {
                int dimension = inputStream.readInt();
                WorldServer world = DimensionManager.getWorld((int)dimension);
                int x = inputStream.readInt();
                int y = inputStream.readInt();
                int z = inputStream.readInt();
                TileEntity te = world.func_72796_p(x, y, z);
                String toolName = inputStream.readUTF();
                if (te instanceof ToolStationLogic) {
                    ((ToolStationLogic)te).setToolname(toolName);
                }
            } else if (packetID == 2) {
                int dimension = inputStream.readInt();
                WorldServer world = DimensionManager.getWorld((int)dimension);
                int x = inputStream.readInt();
                int y = inputStream.readInt();
                int z = inputStream.readInt();
                TileEntity te = world.func_72796_p(x, y, z);
                Short itemID = inputStream.readShort();
                Short itemDamage = inputStream.readShort();
                if (te instanceof InventoryLogic) {
                    ((InventoryLogic)te).func_70299_a(1, new ItemStack((int)itemID.shortValue(), 1, (int)itemDamage.shortValue()));
                }
            } else if (packetID == 3) {
                String user = inputStream.readUTF();
                EntityPlayer player = TConstruct.playerTracker.getEntityPlayer(user);
                player.openGui((Object)TConstruct.instance, TProxyCommon.armorGuiID, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            } else if (packetID == 10) {
                String user = inputStream.readUTF();
                EntityPlayer player = TConstruct.playerTracker.getEntityPlayer(user);
                player.field_70143_R = 0.0f;
            }
        }
        catch (IOException e) {
            System.out.println("Failed at reading server packet for TConstruct.");
            e.printStackTrace();
            return;
        }
    }
}

