/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.modifiers;

import java.util.Arrays;
import java.util.List;
import mods.tinker.tconstruct.library.tools.ToolCore;
import mods.tinker.tconstruct.library.tools.ToolMod;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ModRedstone
extends ToolMod {
    String tooltipName = "\u00a74Haste";
    int increase;
    int max;

    public ModRedstone(ItemStack[] items, int effect, int inc) {
        super(items, effect, "Redstone");
        this.increase = inc;
        this.max = 50;
    }

    @Override
    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        ToolCore toolItem = (ToolCore)tool.func_77973_b();
        if (!this.validType(toolItem)) {
            return false;
        }
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        if (!tags.func_74764_b(this.key)) {
            return tags.func_74762_e("Modifiers") > 0;
        }
        int[] keyPair = tags.func_74759_k(this.key);
        if (keyPair[0] + this.increase <= keyPair[1]) {
            return true;
        }
        if (keyPair[0] == keyPair[1]) {
            return tags.func_74762_e("Modifiers") > 0;
        }
        return false;
    }

    @Override
    public void modify(ItemStack[] input, ItemStack tool) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        if (tags.func_74764_b(this.key)) {
            int[] keyPair = tags.func_74759_k(this.key);
            if (keyPair[0] % this.max == 0) {
                keyPair[0] = keyPair[0] + this.increase;
                keyPair[1] = keyPair[1] + this.max;
                tags.func_74783_a(this.key, keyPair);
                int modifiers = tags.func_74762_e("Modifiers");
                tags.func_74768_a("Modifiers", --modifiers);
            } else {
                keyPair[0] = keyPair[0] + this.increase;
                tags.func_74783_a(this.key, keyPair);
            }
            this.updateModTag(tool, keyPair);
        } else {
            int modifiers = tags.func_74762_e("Modifiers");
            tags.func_74768_a("Modifiers", --modifiers);
            String modName = "\u00a74Redstone (" + this.increase + "/" + this.max + ")";
            int tooltipIndex = this.addToolTip(tool, this.tooltipName, modName);
            int[] keyPair = new int[]{this.increase, this.max, tooltipIndex};
            tags.func_74783_a(this.key, keyPair);
        }
        int miningSpeed = tags.func_74762_e("MiningSpeed");
        tags.func_74768_a("MiningSpeed", miningSpeed += this.increase * 8);
        if (tags.func_74764_b("MiningSpeed2")) {
            int miningSpeed2 = tags.func_74762_e("MiningSpeed2");
            tags.func_74768_a("MiningSpeed2", miningSpeed2 += this.increase * 8);
        }
    }

    void updateModTag(ItemStack tool, int[] keys) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        String tip = "ModifierTip" + keys[2];
        String modName = "\u00a74Redstone (" + keys[0] + "/" + keys[1] + ")";
        tags.func_74778_a(tip, modName);
    }

    @Override
    public boolean validType(ToolCore tool) {
        List<String> list = Arrays.asList(tool.toolCategories());
        return list.contains("harvest");
    }
}

