/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.modifiers;

import java.util.Arrays;
import java.util.List;
import mods.tinker.tconstruct.library.tools.ToolCore;
import mods.tinker.tconstruct.library.tools.ToolMod;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ModAttack
extends ToolMod {
    String tooltipName = "\u00a7fSharpness";
    int increase;
    int max = 72;
    String guiType;

    public ModAttack(String type, ItemStack[] items, int effect, int inc) {
        super(items, effect, "ModAttack");
        this.guiType = type;
        this.increase = inc;
    }

    @Override
    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        if (!tags.func_74764_b(this.key)) {
            return tags.func_74762_e("Modifiers") > 0;
        }
        int[] keyPair = tags.func_74759_k(this.key);
        if (keyPair[0] + this.increase <= keyPair[1]) {
            return true;
        }
        if (keyPair[0] == keyPair[1]) {
            return tags.func_74762_e("Modifiers") > 0;
        }
        return false;
    }

    @Override
    public void modify(ItemStack[] input, ItemStack tool) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        if (tags.func_74764_b(this.key)) {
            int[] keyPair;
            int leftToBoost;
            int amount = 24;
            ToolCore toolItem = (ToolCore)tool.func_77973_b();
            if (toolItem.pierceArmor() || !this.validType(toolItem)) {
                amount = 36;
            }
            if (this.increase >= (leftToBoost = amount - (keyPair = tags.func_74759_k(this.key))[0] % amount)) {
                int attack = tags.func_74762_e("Attack");
                tags.func_74768_a("Attack", ++attack);
            }
            if (keyPair[0] % this.max == 0) {
                keyPair[0] = keyPair[0] + this.increase;
                keyPair[1] = keyPair[1] + this.max;
                tags.func_74783_a(this.key, keyPair);
                int modifiers = tags.func_74762_e("Modifiers");
                tags.func_74768_a("Modifiers", --modifiers);
            } else {
                keyPair[0] = keyPair[0] + this.increase;
                tags.func_74783_a(this.key, keyPair);
            }
            this.updateModTag(tool, keyPair);
        } else {
            int modifiers = tags.func_74762_e("Modifiers");
            tags.func_74768_a("Modifiers", --modifiers);
            String modName = "\u00a7f" + this.guiType + " (" + this.increase + "/" + this.max + ")";
            int tooltipIndex = this.addToolTip(tool, this.tooltipName, modName);
            int[] keyPair = new int[]{this.increase, this.max, tooltipIndex};
            tags.func_74783_a(this.key, keyPair);
            int attack = tags.func_74762_e("Attack");
            tags.func_74768_a("Attack", ++attack);
        }
    }

    void updateModTag(ItemStack tool, int[] keys) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        String tip = "ModifierTip" + keys[2];
        String modName = "\u00a7f" + this.guiType + " (" + keys[0] + "/" + keys[1] + ")";
        tags.func_74778_a(tip, modName);
    }

    @Override
    public boolean validType(ToolCore tool) {
        List<String> list = Arrays.asList(tool.toolCategories());
        return list.contains("throwing");
    }
}

