/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.library.tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.IBoxable;
import ic2.api.item.ICustomElectricItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mods.tinker.tconstruct.library.TConstructRegistry;
import mods.tinker.tconstruct.library.crafting.ToolBuilder;
import mods.tinker.tconstruct.library.tools.AbilityHelper;
import mods.tinker.tconstruct.library.tools.ToolMaterial;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public abstract class ToolCore
extends Item
implements ICustomElectricItem,
IBoxable {
    protected Random random = new Random();
    protected int damageVsEntity;
    public static Icon blankSprite;
    public static Icon emptyIcon;
    public HashMap headIcons = new HashMap();
    public HashMap brokenHeadIcons = new HashMap();
    public HashMap handleIcons = new HashMap();
    public HashMap accessoryIcons = new HashMap();
    public HashMap effectIcons = new HashMap();
    public HashMap headStrings = new HashMap();
    public HashMap brokenHeadStrings = new HashMap();
    public HashMap handleStrings = new HashMap();
    public HashMap accessoryStrings = new HashMap();
    public HashMap effectStrings = new HashMap();
    static String[] toolMaterialNames;

    public ToolCore(int id, int baseDamage) {
        super(id);
        this.field_77777_bU = 1;
        this.func_77656_e(100);
        this.func_77655_b("InfiTool");
        this.func_77637_a(TConstructRegistry.toolTab);
        this.damageVsEntity = baseDamage;
        TConstructRegistry.addToolMapping(this);
        this.setNoRepair();
        this.canRepair = false;
    }

    public abstract int getHeadType();

    public String getToolName() {
        return this.getClass().getSimpleName();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 9;
    }

    public int getPartAmount() {
        return 3;
    }

    public abstract String getIconSuffix(int var1);

    public abstract String getEffectSuffix();

    public abstract String getDefaultFolder();

    public void registerPartPaths(int index, String[] location) {
        this.headStrings.put(index, location[0]);
        this.brokenHeadStrings.put(index, location[1]);
        this.handleStrings.put(index, location[2]);
        this.accessoryStrings.put(index, location[3]);
    }

    public void registerEffectPath(int index, String location) {
        this.effectStrings.put(index, location);
    }

    public void func_94581_a(IconRegister iconRegister) {
        this.headIcons.clear();
        this.brokenHeadIcons.clear();
        this.handleIcons.clear();
        this.accessoryIcons.clear();
        this.effectIcons.clear();
        for (Map.Entry pairs : this.headStrings.entrySet()) {
            this.headIcons.put((Integer)pairs.getKey(), iconRegister.func_94245_a((String)pairs.getValue()));
        }
        for (Map.Entry pairs : this.brokenHeadStrings.entrySet()) {
            this.brokenHeadIcons.put((Integer)pairs.getKey(), iconRegister.func_94245_a((String)pairs.getValue()));
        }
        for (Map.Entry pairs : this.handleStrings.entrySet()) {
            this.handleIcons.put((Integer)pairs.getKey(), iconRegister.func_94245_a((String)pairs.getValue()));
        }
        if (this.getPartAmount() > 2) {
            for (Map.Entry pairs : this.accessoryStrings.entrySet()) {
                this.accessoryIcons.put((Integer)pairs.getKey(), iconRegister.func_94245_a((String)pairs.getValue()));
            }
        }
        for (Map.Entry pairs : this.effectStrings.entrySet()) {
            this.effectIcons.put((Integer)pairs.getKey(), iconRegister.func_94245_a((String)pairs.getValue()));
        }
        emptyIcon = iconRegister.func_94245_a("tinker:blankface");
    }

    public Icon getIcon(ItemStack stack, int renderPass) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null) {
            tags = stack.func_77978_p().func_74775_l("InfiTool");
            if (renderPass < this.getPartAmount()) {
                if (renderPass == 0) {
                    return (Icon)this.handleIcons.get(tags.func_74762_e("RenderHandle"));
                }
                if (renderPass == 1) {
                    if (tags.func_74767_n("Broken")) {
                        return (Icon)this.brokenHeadIcons.get(tags.func_74762_e("RenderHead"));
                    }
                    return (Icon)this.headIcons.get(tags.func_74762_e("RenderHead"));
                }
                if (renderPass == 2) {
                    return (Icon)this.accessoryIcons.get(tags.func_74762_e("RenderAccessory"));
                }
            } else if (renderPass == this.getPartAmount()) {
                if (tags.func_74764_b("Effect1")) {
                    return (Icon)this.effectIcons.get(tags.func_74762_e("Effect1"));
                }
            } else if (renderPass == this.getPartAmount() + 1) {
                if (tags.func_74764_b("Effect2")) {
                    return (Icon)this.effectIcons.get(tags.func_74762_e("Effect2"));
                }
            } else if (renderPass == this.getPartAmount() + 2) {
                if (tags.func_74764_b("Effect3")) {
                    return (Icon)this.effectIcons.get(tags.func_74762_e("Effect3"));
                }
            } else if (renderPass == this.getPartAmount() + 3) {
                if (tags.func_74764_b("Effect4")) {
                    return (Icon)this.effectIcons.get(tags.func_74762_e("Effect4"));
                }
            } else if (renderPass == this.getPartAmount() + 4) {
                if (tags.func_74764_b("Effect5")) {
                    return (Icon)this.effectIcons.get(tags.func_74762_e("Effect5"));
                }
            } else if (renderPass == this.getPartAmount() + 5 && tags.func_74764_b("Effect6")) {
                return (Icon)this.effectIcons.get(tags.func_74762_e("Effect6"));
            }
            return blankSprite;
        }
        return emptyIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound tags = stack.func_77978_p();
        if (tags.func_74764_b("charge")) {
            String color = "";
            int power = tags.func_74762_e("charge");
            if (power != 0) {
                color = power <= this.getMaxCharge(stack) / 3 ? "\u00a74" : (power > this.getMaxCharge(stack) * 2 / 3 ? "\u00a72" : "\u00a76");
            }
            String charge = color + tags.func_74762_e("charge") + "/" + this.getMaxCharge(stack) + " EU";
            list.add(charge);
        }
        if (tags.func_74764_b("InfiTool")) {
            boolean broken = tags.func_74775_l("InfiTool").func_74767_n("Broken");
            if (broken) {
                list.add("\u00a7oBroken");
            } else {
                String reinforced;
                String bindingName;
                String handleName;
                int head = tags.func_74775_l("InfiTool").func_74762_e("Head");
                int handle = tags.func_74775_l("InfiTool").func_74762_e("Handle");
                int binding = tags.func_74775_l("InfiTool").func_74762_e("Accessory");
                String headName = this.getAbilityNameForType(head);
                if (!headName.equals("")) {
                    list.add(ToolCore.getStyleForType(head) + headName);
                }
                if (!(handleName = this.getAbilityNameForType(handle)).equals("") && handle != head) {
                    list.add(ToolCore.getStyleForType(handle) + handleName);
                }
                if (this.getPartAmount() >= 3 && !(bindingName = this.getAbilityNameForType(binding)).equals("") && binding != head && binding != handle) {
                    list.add(ToolCore.getStyleForType(binding) + bindingName);
                }
                if (!(reinforced = this.getReinforcedName(head, handle, binding)).equals("")) {
                    list.add(reinforced);
                }
                boolean displayToolTips = true;
                int tipNum = 0;
                while (displayToolTips) {
                    String tooltip = "Tooltip" + ++tipNum;
                    if (tags.func_74775_l("InfiTool").func_74764_b(tooltip)) {
                        String tipName = tags.func_74775_l("InfiTool").func_74779_i(tooltip);
                        if (tipName.equals("")) continue;
                        list.add(tipName);
                        continue;
                    }
                    displayToolTips = false;
                }
            }
        }
    }

    public static String getStyleForType(int type) {
        return TConstructRegistry.getMaterial(type).style();
    }

    public String getAbilityNameForType(int type) {
        return TConstructRegistry.getMaterial(type).ability();
    }

    public String getReinforcedName(int head, int handle, int accessory) {
        ToolMaterial headMat = TConstructRegistry.getMaterial(head);
        ToolMaterial handleMat = TConstructRegistry.getMaterial(handle);
        ToolMaterial accessoryMat = TConstructRegistry.getMaterial(accessory);
        int reinforced = 0;
        String style = "";
        int current = headMat.reinforced();
        if (current > 0) {
            style = headMat.style();
            reinforced = current;
        }
        if ((current = handleMat.reinforced()) > 0 && current > reinforced) {
            style = handleMat.style();
            reinforced = current;
        }
        if (this.getPartAmount() >= 3 && (current = accessoryMat.reinforced()) > 0 && current > reinforced) {
            style = accessoryMat.style();
            reinforced = current;
        }
        if (reinforced > 0) {
            return style + this.getReinforcedString(reinforced);
        }
        return "";
    }

    String getReinforcedString(int reinforced) {
        String ret = "Reinforced ";
        switch (reinforced) {
            case 1: {
                ret = ret + "I";
                break;
            }
            case 2: {
                ret = ret + "II";
                break;
            }
            case 3: {
                ret = ret + "III";
                break;
            }
            case 4: {
                ret = ret + "IV";
                break;
            }
            case 5: {
                ret = ret + "V";
                break;
            }
            case 6: {
                ret = ret + "VI";
                break;
            }
            case 7: {
                ret = ret + "VII";
                break;
            }
            case 8: {
                ret = ret + "VIII";
                break;
            }
            case 9: {
                ret = ret + "IX";
                break;
            }
            default: {
                ret = ret + "X";
            }
        }
        return ret;
    }

    public void onEntityDamaged(World world, EntityPlayer player, Entity entity) {
    }

    public void func_77633_a(int id, CreativeTabs tab, List list) {
        for (int i = 0; i < 18; ++i) {
            Item accessory = this.getAccessoryItem();
            ItemStack accessoryStack = accessory != null ? new ItemStack(this.getAccessoryItem(), 1, i) : null;
            ItemStack tool = ToolBuilder.instance.buildTool(new ItemStack(this.getHeadItem(), 1, i), new ItemStack(this.getHandleItem(), 1, i), accessoryStack, toolMaterialNames[i] + this.getToolName());
            tool.func_77978_p().func_74775_l("InfiTool").func_74757_a("Built", true);
            list.add(tool);
        }
    }

    protected abstract Item getHeadItem();

    protected abstract Item getAccessoryItem();

    protected Item getHandleItem() {
        return TConstructRegistry.toolRod;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        NBTTagCompound tags;
        if (!world.field_72995_K && entity instanceof EntityLiving && !((EntityLiving)entity).field_82175_bq && (tags = stack.func_77978_p().func_74775_l("InfiTool")).func_74764_b("Moss")) {
            int check;
            int chance = tags.func_74762_e("Moss");
            int n = check = world.func_72937_j((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v) ? 750 : 1500;
            if (this.random.nextInt(check) < chance) {
                AbilityHelper.healTool(stack, 1, (EntityLiving)entity, true, false);
            }
        }
    }

    public abstract String[] toolCategories();

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        World world = player.field_70170_p;
        int bID = player.field_70170_p.func_72798_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        Block block = Block.field_71973_m[bID];
        if (block == null || bID < 1 || bID > 4095) {
            return false;
        }
        if (tags.func_74767_n("Lava") && block.quantityDropped(meta, 0, this.random) != 0) {
            ItemStack smeltStack = new ItemStack(block.func_71885_a(meta, this.random, 0), 1, block.func_71899_b(meta));
            if (smeltStack.field_77993_c < 0 || smeltStack.field_77993_c >= 32000 || smeltStack.func_77973_b() == null) {
                return false;
            }
            ItemStack result = FurnaceRecipes.func_77602_a().getSmeltingResult(smeltStack);
            if (result != null) {
                world.func_94571_i(x, y, z);
                if (!player.field_71075_bZ.field_75098_d) {
                    this.func_77660_a(stack, world, bID, x, y, z, (EntityLiving)player);
                }
                if (!world.field_72995_K) {
                    int loot;
                    ItemStack spawnme = result.func_77946_l();
                    if (!(result.func_77973_b() instanceof ItemBlock) && (loot = EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)stack)) > 0) {
                        spawnme.field_77994_a *= this.random.nextInt(loot + 1) + 1;
                    }
                    EntityItem entityitem = new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, spawnme);
                    entityitem.field_70293_c = 10;
                    world.func_72838_d((Entity)entityitem);
                    world.func_72926_e(2001, x, y, z, bID + (meta << 12));
                }
                for (int i = 0; i < 6; ++i) {
                    float f = (float)x + this.random.nextFloat();
                    float f1 = (float)y + this.random.nextFloat();
                    float f2 = (float)z + this.random.nextFloat();
                    float f3 = 0.52f;
                    float f4 = this.random.nextFloat() * 0.6f - 0.3f;
                    world.func_72869_a("smoke", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    world.func_72869_a("smoke", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    world.func_72869_a("smoke", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
                    world.func_72869_a("smoke", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
                }
                return true;
            }
        }
        return false;
    }

    public boolean func_77660_a(ItemStack itemstack, World world, int bID, int x, int y, int z, EntityLiving player) {
        return AbilityHelper.onBlockChanged(itemstack, world, bID, x, y, z, player, this.random);
    }

    public float getStrVsBlock(ItemStack stack, Block block, int meta) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags.func_74775_l("InfiTool").func_74767_n("Broken")) {
            return 0.1f;
        }
        return 1.0f;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        AbilityHelper.onLeftClickEntity(stack, player, entity, this);
        return true;
    }

    public boolean func_77644_a(ItemStack stack, EntityLiving mob, EntityLiving player) {
        return true;
    }

    public boolean pierceArmor() {
        return false;
    }

    public float chargeAttack() {
        return 1.0f;
    }

    public int func_77649_a(Entity par1Entity) {
        return this.damageVsEntity;
    }

    public float getDurabilityModifier() {
        return 1.0f;
    }

    public float getDamageModifier() {
        return 1.0f;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float clickX, float clickY, float clickZ) {
        ItemStack next;
        int posX = x;
        int posY = y;
        int posZ = z;
        int playerPosX = (int)Math.floor(player.field_70165_t);
        int playerPosY = (int)Math.floor(player.field_70163_u);
        int playerPosZ = (int)Math.floor(player.field_70161_v);
        if (side == 0) {
            --posY;
        }
        if (side == 1) {
            ++posY;
        }
        if (side == 2) {
            --posZ;
        }
        if (side == 3) {
            ++posZ;
        }
        if (side == 4) {
            --posX;
        }
        if (side == 5) {
            ++posX;
        }
        if (posX == playerPosX && (posY == playerPosY || posY == playerPosY + 1 || posY == playerPosY - 1) && posZ == playerPosZ) {
            return false;
        }
        int hotbarSlot = player.field_71071_by.field_70461_c;
        if (hotbarSlot == 0) {
            ItemStack next2 = player.field_71071_by.func_70301_a(8);
            if (next2 != null && next2.func_77973_b() instanceof ItemBlock) {
                next2.func_77973_b().func_77648_a(next2, player, world, x, y, z, side, clickX, clickY, clickZ);
                if (next2.field_77994_a < 1) {
                    player.field_71071_by.func_70299_a(8, null);
                }
            }
        } else if (hotbarSlot < 8 && (next = player.field_71071_by.func_70301_a(hotbarSlot + 1)) != null && next.func_77973_b() instanceof ItemBlock) {
            next.func_77973_b().func_77648_a(next, player, world, x, y, z, side, clickX, clickY, clickZ);
            if (next.field_77994_a < 1) {
                player.field_71071_by.func_70299_a(hotbarSlot + 1, null);
            }
        }
        return false;
    }

    @Override
    public boolean canBeStoredInToolbox(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p();
        return tags.func_74764_b("charge");
    }

    @Override
    public int getChargedItemId(ItemStack stack) {
        return this.field_77779_bT;
    }

    @Override
    public int getEmptyItemId(ItemStack stack) {
        return this.field_77779_bT;
    }

    @Override
    public int getMaxCharge(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p();
        if (!tags.func_74764_b("charge")) {
            return 0;
        }
        return 10000;
    }

    @Override
    public int getTier(ItemStack itemStack) {
        return 0;
    }

    @Override
    public int getTransferLimit(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p();
        if (!tags.func_74764_b("charge")) {
            return 0;
        }
        return 32;
    }

    @Override
    public int charge(ItemStack stack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        NBTTagCompound tags = stack.func_77978_p();
        if (!tags.func_74764_b("charge")) {
            return 0;
        }
        if (amount > 0) {
            if (amount > this.getTransferLimit(stack) && !ignoreTransferLimit) {
                amount = this.getTransferLimit(stack);
            }
            int charge = tags.func_74762_e("charge");
            if (amount > this.getMaxCharge(stack) - charge) {
                amount = this.getMaxCharge(stack) - charge;
            }
            charge += amount;
            if (!simulate) {
                tags.func_74768_a("charge", charge);
                stack.func_77964_b(1 + (this.getMaxCharge(stack) - charge) * (stack.func_77958_k() - 2) / this.getMaxCharge(stack));
            }
            return amount;
        }
        return 0;
    }

    @Override
    public int discharge(ItemStack stack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        NBTTagCompound tags = stack.func_77978_p();
        if (!tags.func_74764_b("charge")) {
            return 0;
        }
        if (amount > 0) {
            int charge;
            if (amount > this.getTransferLimit(stack) && !ignoreTransferLimit) {
                amount = this.getTransferLimit(stack);
            }
            if (amount > (charge = tags.func_74762_e("charge"))) {
                amount = charge;
            }
            charge -= amount;
            if (!simulate) {
                tags.func_74768_a("charge", charge);
                stack.func_77964_b(1 + (this.getMaxCharge(stack) - charge) * (stack.func_77958_k() - 1) / this.getMaxCharge(stack));
            }
            return amount;
        }
        return 0;
    }

    @Override
    public boolean canShowChargeToolTip(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean canUse(ItemStack itemStack, int amount) {
        return false;
    }

    public boolean func_77616_k(ItemStack par1ItemStack) {
        return false;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_77662_d() {
        return true;
    }

    static {
        toolMaterialNames = new String[]{"Wooden ", "Stone ", "Iron ", "Flint ", "Cactus ", "Bone ", "Obsidian ", "Netherrack ", "Slime ", "Paper ", "Cobalt ", "Ardite ", "Manyullyn ", "Copper ", "Bronze ", "Alumite ", "Steel ", "Slime "};
    }
}

