/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.library.tools;

import mods.tinker.tconstruct.common.TContent;
import mods.tinker.tconstruct.library.tools.ToolCore;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;

public abstract class HarvestTool
extends ToolCore {
    public HarvestTool(int itemID, int baseDamage) {
        super(itemID, baseDamage);
    }

    @Override
    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        TContent.modL.midStreamModify(stack);
        return super.onBlockStartBreak(stack, x, y, z, player);
    }

    @Override
    public float getStrVsBlock(ItemStack stack, Block block, int meta) {
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        if (tags.func_74767_n("Broken")) {
            return 0.1f;
        }
        Material[] materials = this.getEffectiveMaterials();
        for (int i = 0; i < materials.length; ++i) {
            if (materials[i] != block.field_72018_cp) continue;
            float speed = tags.func_74762_e("MiningSpeed");
            speed /= 100.0f;
            int hlvl = MinecraftForge.getBlockHarvestLevel((Block)block, (int)meta, (String)this.getHarvestType());
            int durability = tags.func_74762_e("Damage");
            float shoddy = tags.func_74760_g("Shoddy");
            speed += shoddy * (float)durability / 100.0f;
            if (hlvl <= tags.func_74762_e("HarvestLevel")) {
                return speed;
            }
            return 0.1f;
        }
        return super.getStrVsBlock(stack, block, meta);
    }

    public boolean func_77641_a(Block block) {
        if (block.field_72018_cp.func_76229_l()) {
            return true;
        }
        for (Material m : this.getEffectiveMaterials()) {
            if (m != block.field_72018_cp) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] toolCategories() {
        return new String[]{"harvest"};
    }

    protected abstract Material[] getEffectiveMaterials();

    protected abstract String getHarvestType();
}

