/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.library.tools;

import ic2.api.item.ICustomElectricItem;
import ic2.api.item.IElectricItem;
import java.util.List;
import java.util.Random;
import mods.tinker.tconstruct.library.tools.ToolCore;
import mods.tinker.tconstruct.library.util.PiercingEntityDamage;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentThorns;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.player.UseHoeEvent;

public class AbilityHelper {
    static Random random = new Random();

    public static boolean onBlockChanged(ItemStack stack, World world, int bID, int x, int y, int z, EntityLiving player, Random random) {
        if (!stack.func_77942_o()) {
            return false;
        }
        int durability = 0;
        NBTTagCompound tags = stack.func_77978_p();
        if (tags.func_74775_l("InfiTool").func_74764_b("Unbreaking")) {
            durability = tags.func_74775_l("InfiTool").func_74762_e("Unbreaking");
        }
        if (random.nextInt(10) < 10 - durability) {
            AbilityHelper.damageTool(stack, 1, tags, player, false, true);
        }
        return true;
    }

    public static void onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity, ToolCore tool) {
        if (entity.func_70075_an() && !entity.func_85031_j((Entity)player)) {
            NBTTagCompound tags = stack.func_77978_p();
            NBTTagCompound toolTags = stack.func_77978_p().func_74775_l("InfiTool");
            int damage = toolTags.func_74762_e("Attack");
            boolean broken = toolTags.func_74767_n("Broken");
            int durability = tags.func_74775_l("InfiTool").func_74762_e("Damage");
            float shoddy = tags.func_74775_l("InfiTool").func_74760_g("Shoddy");
            float damageModifier = -shoddy * (float)durability / 100.0f;
            if (player.func_70644_a(Potion.field_76420_g)) {
                damage += 3 << player.func_70660_b(Potion.field_76420_g).func_76458_c();
            }
            if (player.func_70644_a(Potion.field_76437_t)) {
                damage -= 2 << player.func_70660_b(Potion.field_76437_t).func_76458_c();
            }
            float knockback = 0.0f;
            int enchantDamage = 0;
            if (entity instanceof EntityLiving) {
                enchantDamage = EnchantmentHelper.func_77512_a((EntityLiving)player, (EntityLiving)((EntityLiving)entity));
                knockback += (float)EnchantmentHelper.func_77507_b((EntityLiving)player, (EntityLiving)((EntityLiving)entity));
            }
            damage = (int)((float)damage + damageModifier);
            if (player.func_70051_ag()) {
                knockback += 1.0f;
                float lunge = tool.chargeAttack();
                if (lunge > 1.0f) {
                    knockback += lunge - 1.0f;
                    damage = (int)((float)damage * lunge);
                }
            }
            if (damage > 0 || enchantDamage > 0) {
                boolean criticalHit;
                boolean bl = criticalHit = player.field_70143_R > 0.0f && !player.field_70122_E && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(Potion.field_76440_q) && player.field_70154_o == null && entity instanceof EntityLiving;
                if (criticalHit) {
                    damage += random.nextInt(damage / 2 + 2);
                }
                damage += enchantDamage;
                if (tool.getDamageModifier() != 1.0f) {
                    damage = (int)((float)damage * tool.getDamageModifier());
                }
                boolean var6 = false;
                int fireAspect = EnchantmentHelper.func_90036_a((EntityLiving)player);
                if (entity instanceof EntityLiving && fireAspect > 0 && !entity.func_70027_ad()) {
                    var6 = true;
                    entity.func_70015_d(1);
                }
                if (broken) {
                    damage = 1;
                }
                boolean causedDamage = false;
                causedDamage = tool.pierceArmor() && !broken ? entity.func_70097_a(AbilityHelper.causePlayerPiercingDamage(player), damage) : entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), damage);
                if (causedDamage) {
                    AbilityHelper.damageTool(stack, 1, (EntityLiving)player, false);
                    tool.onEntityDamaged(player.field_70170_p, player, entity);
                    int drain = toolTags.func_74762_e("Necrotic") * 2;
                    if (drain > 0) {
                        player.func_70691_i(random.nextInt(drain));
                    }
                    if (knockback > 0.0f) {
                        entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(player.field_70177_z * (float)Math.PI / 180.0f)) * knockback * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(player.field_70177_z * (float)Math.PI / 180.0f)) * knockback * 0.5f));
                        player.field_70159_w *= 0.6;
                        player.field_70179_y *= 0.6;
                        player.func_70031_b(false);
                    }
                    if (criticalHit) {
                        player.func_71009_b(entity);
                    }
                    if (enchantDamage > 0) {
                        player.func_71047_c(entity);
                    }
                    if (damage >= 18) {
                        player.func_71029_a((StatBase)AchievementList.field_75999_E);
                    }
                    player.func_70607_j(entity);
                    if (entity instanceof EntityLiving) {
                        EnchantmentThorns.func_92096_a((Entity)player, (EntityLiving)((EntityLiving)entity), (Random)random);
                    }
                }
                if (entity instanceof EntityLiving) {
                    stack.func_77961_a((EntityLiving)entity, player);
                    if (entity.func_70089_S()) {
                        AbilityHelper.alertPlayerWolves(player, (EntityLiving)entity, true);
                    }
                    player.func_71064_a(StatList.field_75951_w, damage);
                    if ((fireAspect > 0 || toolTags.func_74764_b("Fiery") || toolTags.func_74764_b("Lava")) && causedDamage) {
                        fireAspect *= 4;
                        if (toolTags.func_74764_b("Fiery")) {
                            fireAspect += toolTags.func_74762_e("Fiery") / 5 + 1;
                        }
                        if (toolTags.func_74767_n("Lava")) {
                            fireAspect += 3;
                        }
                        entity.func_70015_d(fireAspect);
                    } else if (var6) {
                        entity.func_70066_B();
                    }
                }
                player.func_71020_j(0.3f);
            }
        }
    }

    static void alertPlayerWolves(EntityPlayer player, EntityLiving living, boolean par2) {
        if (!(living instanceof EntityCreeper) && !(living instanceof EntityGhast)) {
            EntityWolf var3;
            if (living instanceof EntityWolf && (var3 = (EntityWolf)living).func_70909_n() && player.field_71092_bJ.equals(var3.func_70905_p())) {
                return;
            }
            if (!(living instanceof EntityPlayer) || player.func_96122_a((EntityPlayer)living)) {
                List var6 = player.field_70170_p.func_72872_a(EntityWolf.class, AxisAlignedBB.func_72332_a().func_72299_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70165_t + 1.0, player.field_70163_u + 1.0, player.field_70161_v + 1.0).func_72314_b(16.0, 4.0, 16.0));
                for (EntityWolf var5 : var6) {
                    if (!var5.func_70909_n() || var5.func_70777_m() != null || !player.field_71092_bJ.equals(var5.func_70905_p()) || par2 && var5.func_70906_o()) continue;
                    var5.func_70904_g(false);
                    var5.func_70784_b((Entity)living);
                }
            }
        }
    }

    public static void damageTool(ItemStack stack, int dam, EntityLiving entity, boolean ignoreCharge) {
        NBTTagCompound tags = stack.func_77978_p();
        AbilityHelper.damageTool(stack, dam, tags, entity, ignoreCharge, true);
    }

    public static void healTool(ItemStack stack, int dam, EntityLiving entity, boolean ignoreCharge, boolean updateDamageBar) {
        NBTTagCompound tags = stack.func_77978_p();
        AbilityHelper.damageTool(stack, -dam, tags, entity, ignoreCharge, updateDamageBar);
    }

    public static void damageTool(ItemStack stack, int dam, NBTTagCompound tags, EntityLiving entity, boolean ignoreCharge, boolean updateDamageBar) {
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            return;
        }
        if (ignoreCharge || !AbilityHelper.damageElectricTool(stack, tags, (Entity)entity)) {
            int damage = tags.func_74775_l("InfiTool").func_74762_e("Damage");
            int damageTrue = damage + dam;
            int maxDamage = tags.func_74775_l("InfiTool").func_74762_e("TotalDurability");
            if (damageTrue <= 0) {
                tags.func_74775_l("InfiTool").func_74768_a("Damage", 0);
                if (updateDamageBar) {
                    stack.func_77964_b(0);
                }
            } else if (damageTrue > maxDamage) {
                AbilityHelper.breakTool(stack, tags, (Entity)entity);
                if (updateDamageBar) {
                    stack.func_77964_b(0);
                }
            } else {
                tags.func_74775_l("InfiTool").func_74768_a("Damage", damage + dam);
                int toolDamage = damage * 100 / maxDamage + 1;
                int stackDamage = stack.func_77960_j();
                if (updateDamageBar && toolDamage != stackDamage) {
                    stack.func_77964_b(damage * 100 / maxDamage + 1);
                }
            }
        }
    }

    public static boolean damageElectricTool(ItemStack stack, NBTTagCompound tags, Entity entity) {
        if (!tags.func_74764_b("charge")) {
            return false;
        }
        int charge = tags.func_74762_e("charge");
        int mineSpeed = tags.func_74775_l("InfiTool").func_74762_e("MiningSpeed");
        if (tags.func_74775_l("InfiTool").func_74764_b("MiningSpeed2")) {
            mineSpeed = (mineSpeed + tags.func_74775_l("InfiTool").func_74762_e("MiningSpeed2")) / 2;
        }
        if (charge < (mineSpeed /= 15)) {
            if (charge > 0) {
                tags.func_74768_a("charge", 0);
            }
            return false;
        }
        ToolCore tool = (ToolCore)stack.func_77973_b();
        stack.func_77964_b(1 + (tool.getMaxCharge(stack) - (charge -= mineSpeed)) * (stack.func_77958_k() - 1) / tool.getMaxCharge(stack));
        tags.func_74768_a("charge", charge);
        if (entity instanceof EntityPlayer) {
            AbilityHelper.chargeFromArmor(stack, (EntityPlayer)entity);
        }
        return true;
    }

    static void chargeFromArmor(ItemStack stack, EntityPlayer player) {
        boolean inContainer = false;
        for (int armorIter = 0; armorIter < 4; ++armorIter) {
            ItemStack armor = player.field_71071_by.field_70460_b[armorIter];
            if (armor == null || !(armor.func_77973_b() instanceof IElectricItem)) continue;
            IElectricItem electricArmor = (IElectricItem)armor.func_77973_b();
            ToolCore tool = (ToolCore)stack.func_77973_b();
            if (!electricArmor.canProvideEnergy(stack) || electricArmor.getTier(stack) < ((IElectricItem)stack.func_77973_b()).getTier(stack)) continue;
            int chargeAmount = tool.charge(stack, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true);
            if ((chargeAmount = AbilityHelper.discharge(armor, chargeAmount, Integer.MAX_VALUE, true, false)) <= 0) continue;
            tool.charge(stack, chargeAmount, Integer.MAX_VALUE, true, false);
            inContainer = true;
        }
        if (inContainer) {
            player.field_71070_bA.func_75142_b();
        }
    }

    public static int discharge(ItemStack stack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        IElectricItem ielectricitem = (IElectricItem)stack.func_77973_b();
        if (ielectricitem instanceof ICustomElectricItem) {
            return ((ICustomElectricItem)ielectricitem).discharge(stack, amount, tier, ignoreTransferLimit, simulate);
        }
        if (amount >= 0 && stack.field_77994_a <= 1 && ielectricitem.getTier(stack) <= tier) {
            NBTTagCompound tags;
            int charge;
            if (amount > ielectricitem.getTransferLimit(stack) && !ignoreTransferLimit) {
                amount = ielectricitem.getTransferLimit(stack);
            }
            if (amount > (charge = (tags = stack.func_77978_p()).func_74762_e("charge"))) {
                amount = charge;
            }
            charge -= amount;
            if (!simulate) {
                tags.func_74768_a("charge", charge);
                int n = stack.field_77993_c = charge > 0 ? ielectricitem.getChargedItemId(stack) : ielectricitem.getEmptyItemId(stack);
                if (stack.func_77973_b() instanceof IElectricItem) {
                    ielectricitem = (IElectricItem)stack.func_77973_b();
                    if (stack.func_77958_k() > 2) {
                        if (stack.func_77960_j() + 1 < stack.func_77958_k()) {
                            stack.func_77964_b(1 + (ielectricitem.getMaxCharge(stack) - charge) * (stack.func_77958_k() - 2) / ielectricitem.getMaxCharge(stack));
                        }
                    } else {
                        stack.func_77964_b(0);
                    }
                } else {
                    stack.func_77964_b(0);
                }
            }
            return amount;
        }
        return 0;
    }

    public static void breakTool(ItemStack stack, NBTTagCompound tags, Entity entity) {
        tags.func_74775_l("InfiTool").func_74757_a("Broken", true);
        if (entity != null) {
            entity.field_70170_p.func_72980_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, "random.break", 1.0f, 1.0f, true);
        }
    }

    public static void repairTool(ItemStack stack, NBTTagCompound tags) {
        tags.func_74775_l("InfiTool").func_74757_a("Broken", false);
        tags.func_74775_l("InfiTool").func_74768_a("Damage", 0);
    }

    public static DamageSource causePiercingDamage(EntityLiving mob) {
        return new PiercingEntityDamage("mob", (Entity)mob);
    }

    public static DamageSource causePlayerPiercingDamage(EntityPlayer player) {
        return new PiercingEntityDamage("player", (Entity)player);
    }

    public static void knockbackEntity(EntityLiving living, double boost) {
        living.field_70159_w *= boost;
        living.field_70179_y *= boost;
    }

    public static boolean hoeGround(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, Random random) {
        if (!player.func_82247_a(x, y, z, side, stack)) {
            return false;
        }
        UseHoeEvent event = new UseHoeEvent(player, stack, world, x, y, z);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            AbilityHelper.onBlockChanged(stack, world, 0, x, y, z, (EntityLiving)player, random);
            return true;
        }
        int bID = world.func_72798_a(x, y, z);
        int bIDabove = world.func_72798_a(x, y + 1, z);
        if ((side == 0 || bIDabove != 0 || bID != Block.field_71980_u.field_71990_ca) && bID != Block.field_71979_v.field_71990_ca) {
            return false;
        }
        Block block = Block.field_72050_aA;
        world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), block.field_72020_cn.func_72675_d(), (block.field_72020_cn.func_72677_b() + 1.0f) / 2.0f, block.field_72020_cn.func_72678_c() * 0.8f);
        if (world.field_72995_K) {
            return true;
        }
        world.func_94575_c(x, y, z, block.field_71990_ca);
        AbilityHelper.onBlockChanged(stack, world, 0, x, y, z, (EntityLiving)player, random);
        return true;
    }

    public static void spawnItemAtPlayer(EntityPlayer player, ItemStack stack) {
        EntityItem entityitem = new EntityItem(player.field_70170_p, player.field_70165_t + 0.5, player.field_70163_u + 0.5, player.field_70161_v + 0.5, stack);
        player.field_70170_p.func_72838_d((Entity)entityitem);
        entityitem.func_70100_b_(player);
    }

    public static void forceAddToInv(EntityPlayer entityplayer, ItemStack itemstack, int i, boolean flag) {
        ItemStack itemstack1 = entityplayer.field_71071_by.func_70301_a(i);
        entityplayer.field_71071_by.func_70299_a(i, itemstack);
        if (itemstack1 != null) {
            AbilityHelper.addToInv(entityplayer, itemstack1, flag);
        }
    }

    public static boolean addToInv(EntityPlayer entityplayer, ItemStack itemstack, boolean flag) {
        return AbilityHelper.addToInv(entityplayer, itemstack, entityplayer.field_71071_by.field_70461_c, flag);
    }

    public static boolean addToInv(EntityPlayer entityplayer, ItemStack itemstack, int i, boolean flag) {
        boolean flag1;
        ItemStack itemstack1 = entityplayer.field_71071_by.func_70301_a(i);
        if (itemstack1 == null) {
            entityplayer.field_71071_by.func_70299_a(i, itemstack);
            flag1 = true;
        } else {
            flag1 = entityplayer.field_71071_by.func_70441_a(itemstack);
        }
        if (flag && !flag1) {
            AbilityHelper.addItemStackToWorld(entityplayer.field_70170_p, (float)Math.floor(entityplayer.field_70165_t), (float)Math.floor(entityplayer.field_70163_u), (float)Math.floor(entityplayer.field_70161_v), itemstack);
            return true;
        }
        return flag1;
    }

    public static EntityItem addItemStackToWorld(World world, float f, float f1, float f2, ItemStack itemstack) {
        return AbilityHelper.addItemStackToWorld(world, f, f1, f2, itemstack, false);
    }

    public static EntityItem addItemStackToWorld(World world, float f, float f1, float f2, ItemStack itemstack, boolean flag) {
        EntityItem entityitem;
        if (flag) {
            entityitem = new EntityItem(world, (double)f, (double)f1, (double)f2, itemstack);
        } else {
            float f3 = 0.7f;
            float f4 = random.nextFloat() * f3 + (1.0f - f3) * 0.5f;
            float f5 = 1.2f;
            float f6 = random.nextFloat() * f3 + (1.0f - f3) * 0.5f;
            entityitem = new EntityItem(world, (double)(f + f4), (double)(f1 + f5), (double)(f2 + f6), itemstack);
        }
        entityitem.field_70293_c = 10;
        world.func_72838_d((Entity)entityitem);
        return entityitem;
    }
}

