/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.library.crafting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mods.tinker.tconstruct.library.TConstructRegistry;
import mods.tinker.tconstruct.library.crafting.ToolRecipe;
import mods.tinker.tconstruct.library.tools.ToolCore;
import mods.tinker.tconstruct.library.tools.ToolMaterial;
import mods.tinker.tconstruct.library.tools.ToolMod;
import mods.tinker.tconstruct.library.util.IToolPart;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ToolBuilder {
    public static ToolBuilder instance = new ToolBuilder();
    public List combos = new ArrayList();
    public HashMap modifiers = new HashMap();
    public List toolMods = new ArrayList();

    public static void addToolRecipe(ToolCore output, Item head) {
        ToolBuilder.addToolRecipe(output, head, null);
    }

    public static void addToolRecipe(ToolCore output, Item head, Item accessory) {
        ToolBuilder.instance.combos.add(new ToolRecipe(head, accessory, output));
    }

    public ToolCore getMatchingRecipe(Item head, Item handle, Item accessory) {
        for (ToolRecipe recipe : this.combos) {
            if (!recipe.validHead(head) || !recipe.validHandle(handle) || !recipe.validAccessory(accessory)) continue;
            return recipe.getType();
        }
        return null;
    }

    public ItemStack buildTool(ItemStack headStack, ItemStack handleStack, ItemStack accessoryStack, String name) {
        ToolCore item;
        if (headStack != null && headStack.func_77973_b() instanceof ToolCore) {
            return this.modifyTool(headStack, handleStack, accessoryStack);
        }
        if (headStack == null || handleStack == null) {
            return null;
        }
        boolean validMaterials = true;
        int head = -1;
        int handle = -1;
        int accessory = -1;
        if (headStack.func_77973_b() instanceof IToolPart) {
            head = ((IToolPart)headStack.func_77973_b()).getMaterialID(headStack);
        } else {
            validMaterials = false;
        }
        Item handleItem = handleStack.func_77973_b();
        if (handleItem == Item.field_77669_D) {
            handle = 0;
        } else if (handleItem == Item.field_77755_aX) {
            handle = 5;
        } else if (handleItem instanceof IToolPart) {
            handle = ((IToolPart)handleItem).getMaterialID(handleStack);
        } else {
            validMaterials = false;
        }
        if (!validMaterials) {
            return null;
        }
        if (accessoryStack == null) {
            item = this.getMatchingRecipe(headStack.func_77973_b(), handleStack.func_77973_b(), null);
        } else {
            if (!(accessoryStack.func_77973_b() instanceof IToolPart)) {
                return null;
            }
            accessory = ((IToolPart)accessoryStack.func_77973_b()).getMaterialID(accessoryStack);
            item = this.getMatchingRecipe(headStack.func_77973_b(), handleStack.func_77973_b(), accessoryStack.func_77973_b());
        }
        if (item == null) {
            return null;
        }
        ToolMaterial headMat = null;
        ToolMaterial handleMat = null;
        ToolMaterial accessoryMat = null;
        headMat = TConstructRegistry.getMaterial(head);
        handleMat = TConstructRegistry.getMaterial(handle);
        if (accessory != -1) {
            accessoryMat = TConstructRegistry.getMaterial(accessory);
        }
        int durability = (int)((float)headMat.durability() * handleMat.handleDurability() * item.getDurabilityModifier());
        if (accessoryStack != null && (item.getHeadType() == 2 || item.getHeadType() == 3)) {
            durability = (int)((float)((headMat.durability() + accessoryMat.durability()) / 2) * handleMat.handleDurability() * item.getDurabilityModifier());
        }
        ItemStack tool = new ItemStack((Item)item);
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74766_a("InfiTool", new NBTTagCompound());
        compound.func_74775_l("InfiTool").func_74768_a("Head", head);
        compound.func_74775_l("InfiTool").func_74768_a("Handle", handle);
        compound.func_74775_l("InfiTool").func_74768_a("Accessory", accessory);
        compound.func_74775_l("InfiTool").func_74768_a("RenderHead", head);
        compound.func_74775_l("InfiTool").func_74768_a("RenderHandle", handle);
        compound.func_74775_l("InfiTool").func_74768_a("RenderAccessory", accessory);
        compound.func_74775_l("InfiTool").func_74768_a("Damage", 0);
        compound.func_74775_l("InfiTool").func_74768_a("TotalDurability", durability);
        compound.func_74775_l("InfiTool").func_74768_a("BaseDurability", durability);
        compound.func_74775_l("InfiTool").func_74768_a("BonusDurability", 0);
        compound.func_74775_l("InfiTool").func_74776_a("ModDurability", 0.0f);
        compound.func_74775_l("InfiTool").func_74757_a("Broken", false);
        compound.func_74775_l("InfiTool").func_74768_a("Attack", headMat.attack() + item.func_77649_a(null));
        compound.func_74775_l("InfiTool").func_74768_a("MiningSpeed", headMat.toolSpeed());
        if (item.getHeadType() == 2) {
            int hLvl = headMat.harvestLevel();
            int shLvl = accessoryMat.harvestLevel();
        } else {
            compound.func_74775_l("InfiTool").func_74768_a("HarvestLevel", headMat.harvestLevel());
        }
        if (item.getHeadType() == 3) {
            compound.func_74775_l("InfiTool").func_74768_a("MiningSpeed2", accessoryMat.toolSpeed());
            compound.func_74775_l("InfiTool").func_74768_a("HarvestLevel2", accessoryMat.harvestLevel());
        }
        compound.func_74775_l("InfiTool").func_74768_a("Unbreaking", this.buildReinforced(headMat, handleMat, accessoryMat));
        compound.func_74775_l("InfiTool").func_74776_a("Shoddy", this.buildShoddy(headMat, handleMat, accessoryMat));
        int modifiers = 3;
        modifiers = accessory == -1 ? (modifiers += (head == 9 ? 2 : 0) + (handle == 9 ? 1 : 0)) : (modifiers += (head == 9 ? 1 : 0) + (handle == 9 ? 1 : 0) + (accessory == 9 ? 1 : 0));
        compound.func_74775_l("InfiTool").func_74768_a("Modifiers", modifiers);
        if (name != null && !name.equals("")) {
            compound.func_74766_a("display", new NBTTagCompound());
            compound.func_74775_l("display").func_74778_a("Name", "\u00a7f" + name);
        }
        tool.func_77982_d(compound);
        return tool;
    }

    public ItemStack modifyTool(ItemStack input, ItemStack topSlot, ItemStack bottomSlot) {
        ItemStack tool = input.func_77946_l();
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        tags.func_82580_o("Built");
        if (topSlot == null && bottomSlot == null) {
            return tool;
        }
        boolean built = false;
        for (ToolMod mod : this.toolMods) {
            ItemStack[] slots;
            if (!mod.matches(slots = new ItemStack[]{topSlot, bottomSlot}, tool)) continue;
            built = true;
            mod.addMatchingEffect(tool);
            mod.modify(slots, tool);
        }
        if (built) {
            return tool;
        }
        return null;
    }

    int buildReinforced(ToolMaterial headMat, ToolMaterial handleMat, ToolMaterial accessoryMat) {
        int durability = 0;
        int dHead = headMat.reinforced();
        int dHandle = handleMat.reinforced();
        int dAccessory = 0;
        if (accessoryMat != null) {
            dAccessory = accessoryMat.reinforced();
        }
        if (dHead > durability) {
            durability = dHead;
        }
        if (dHandle > durability) {
            durability = dHandle;
        }
        if (dAccessory > durability) {
            durability = dAccessory;
        }
        return durability;
    }

    float buildShoddy(ToolMaterial headMat, ToolMaterial handleMat, ToolMaterial accessoryMat) {
        float sHead = headMat.shoddy();
        float sHandle = handleMat.shoddy();
        if (accessoryMat != null) {
            float sAccessory = accessoryMat.shoddy();
            return (sHead + sHandle + sAccessory) / 3.0f;
        }
        return (sHead + sHandle) / 2.0f;
    }

    public static void registerToolMod(ToolMod mod) {
        ToolBuilder.instance.toolMods.add(mod);
    }
}

