/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.library.crafting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import mods.tinker.tconstruct.library.crafting.AlloyMix;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidStack;

public class Smeltery {
    public static Smeltery instance = new Smeltery();
    private HashMap smeltingList = new HashMap();
    private HashMap temperatureList = new HashMap();
    private HashMap renderIndex = new HashMap();
    private ArrayList alloys = new ArrayList();

    public static void addMelting(ItemStack stack, int temperature, LiquidStack output) {
        Smeltery.addMelting(stack, stack.field_77993_c, stack.func_77960_j(), temperature, output);
    }

    public static void addMelting(Block block, int metadata, int temperature, LiquidStack output) {
        Smeltery.addMelting(new ItemStack(block, 1, metadata), block.field_71990_ca, metadata, temperature, output);
    }

    public static void addMelting(ItemStack input, int blockID, int metadata, int temperature, LiquidStack liquid) {
        Smeltery.instance.smeltingList.put(Arrays.asList(input.field_77993_c, input.func_77960_j()), liquid);
        Smeltery.instance.temperatureList.put(Arrays.asList(input.field_77993_c, input.func_77960_j()), temperature);
        Smeltery.instance.renderIndex.put(Arrays.asList(input.field_77993_c, input.func_77960_j()), new ItemStack(blockID, input.field_77994_a, metadata));
    }

    public static void addAlloyMixing(LiquidStack result, LiquidStack ... mixers) {
        ArrayList<LiquidStack> inputs = new ArrayList<LiquidStack>();
        for (LiquidStack liquid : mixers) {
            inputs.add(liquid);
        }
        Smeltery.instance.alloys.add(new AlloyMix(result, inputs));
    }

    public static Integer getLiquifyTemperature(ItemStack item) {
        if (item == null) {
            return 20;
        }
        Integer temp = (Integer)Smeltery.instance.temperatureList.get(Arrays.asList(item.field_77993_c, item.func_77960_j()));
        if (temp == null) {
            return 20;
        }
        return temp;
    }

    public static Integer getLiquifyTemperature(int blockID, int metadata) {
        return (Integer)Smeltery.instance.temperatureList.get(Arrays.asList(blockID, metadata));
    }

    public static LiquidStack getSmelteryResult(ItemStack item) {
        if (item == null) {
            return null;
        }
        LiquidStack stack = (LiquidStack)Smeltery.instance.smeltingList.get(Arrays.asList(item.field_77993_c, item.func_77960_j()));
        if (stack == null) {
            return null;
        }
        return stack.copy();
    }

    public static LiquidStack getSmelteryResult(int blockID, int metadata) {
        LiquidStack stack = (LiquidStack)Smeltery.instance.smeltingList.get(Arrays.asList(blockID, metadata));
        if (stack == null) {
            return null;
        }
        return stack.copy();
    }

    public static ItemStack getRenderIndex(ItemStack input) {
        return (ItemStack)Smeltery.instance.renderIndex.get(Arrays.asList(input.field_77993_c, input.func_77960_j()));
    }

    public static ArrayList mixMetals(ArrayList moltenMetal) {
        ArrayList<LiquidStack> liquids = new ArrayList<LiquidStack>();
        for (AlloyMix alloy : Smeltery.instance.alloys) {
            LiquidStack liquid = alloy.mix(moltenMetal);
            if (liquid == null) continue;
            liquids.add(liquid);
        }
        return liquids;
    }

    public static HashMap getSmeltingList() {
        return Smeltery.instance.smeltingList;
    }

    public static HashMap getTemperatureList() {
        return Smeltery.instance.temperatureList;
    }

    public static HashMap getRenderIndex() {
        return Smeltery.instance.renderIndex;
    }

    public static ArrayList getAlloyList() {
        return Smeltery.instance.alloys;
    }
}

