/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.library.crafting;

import java.util.ArrayList;
import mods.tinker.tconstruct.library.crafting.CastingRecipe;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidStack;

public class LiquidCasting {
    private ArrayList casts = new ArrayList();

    public void addCastingRecipe(ItemStack output, LiquidStack metal, ItemStack cast, boolean consume, int delay) {
        this.casts.add(new CastingRecipe(output, metal, cast, consume, delay));
    }

    public void addCastingRecipe(ItemStack output, LiquidStack metal, ItemStack cast, int delay) {
        this.addCastingRecipe(output, metal, cast, false, delay);
    }

    public void addCastingRecipe(ItemStack output, LiquidStack metal, int delay) {
        this.addCastingRecipe(output, metal, null, false, delay);
    }

    public int getCastingDelay(LiquidStack metal, ItemStack cast) {
        CastingRecipe recipe = this.getCastingRecipe(metal, cast);
        if (recipe != null) {
            return recipe.coolTime;
        }
        return -1;
    }

    public int getCastingAmount(LiquidStack metal, ItemStack cast) {
        CastingRecipe recipe = this.getCastingRecipe(metal, cast);
        if (recipe != null) {
            return recipe.castingMetal.amount;
        }
        return 0;
    }

    public CastingRecipe getCastingRecipe(LiquidStack metal, ItemStack cast) {
        for (CastingRecipe recipe : this.casts) {
            if (!recipe.matches(metal, cast)) continue;
            return recipe;
        }
        return null;
    }

    public ArrayList getCastingRecipes() {
        return this.casts;
    }
}

