/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.items.tools;

import java.util.List;
import mods.tinker.tconstruct.common.TContent;
import mods.tinker.tconstruct.library.tools.AbilityHelper;
import mods.tinker.tconstruct.library.tools.HarvestTool;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class LumberAxe
extends HarvestTool {
    static Material[] materials = new Material[]{Material.field_76245_d, Material.field_76265_p, Material.field_76268_x, Material.field_76266_z};

    public LumberAxe(int itemID) {
        super(itemID, 3);
        this.func_77655_b("InfiTool.LumberAxe");
    }

    @Override
    public int getHeadType() {
        return 1;
    }

    @Override
    protected Material[] getEffectiveMaterials() {
        return materials;
    }

    @Override
    protected String getHarvestType() {
        return "axe";
    }

    @Override
    public float getDurabilityModifier() {
        return 2.5f;
    }

    @Override
    public String getToolName() {
        return "Lumber Axe";
    }

    @Override
    public void func_77633_a(int id, CreativeTabs tab, List list) {
    }

    @Override
    public boolean func_77660_a(ItemStack itemstack, World world, int bID, int x, int y, int z, EntityLiving player) {
        Block block = Block.field_71973_m[bID];
        if (block != null && block.field_72018_cp == Material.field_76257_i) {
            return false;
        }
        return AbilityHelper.onBlockChanged(itemstack, world, bID, x, y, z, player, this.random);
    }

    @Override
    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        World world = player.field_70170_p;
        int woodID = world.func_72798_a(x, y, z);
        Block wood = Block.field_71973_m[woodID];
        if (wood.isWood(world, x, y, z)) {
            int height = y;
            boolean foundTop = false;
            do {
                int blockID;
                if ((blockID = world.func_72798_a(x, ++height, z)) == woodID) continue;
                --height;
                foundTop = true;
            } while (!foundTop);
            int numLeaves = 0;
            for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
                for (int yPos = height - 1; yPos <= height + 1; ++yPos) {
                    for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                        Block leaves = Block.field_71973_m[world.func_72798_a(xPos, yPos, zPos)];
                        if (leaves == null || !leaves.isLeaves(world, xPos, yPos, zPos)) continue;
                        ++numLeaves;
                    }
                }
            }
            NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
            int meta = world.func_72805_g(x, y, z);
            if (numLeaves > 3) {
                this.breakTree(world, x, y, z, stack, tags, woodID, meta, player);
            } else {
                this.destroyWood(world, x, y, z, stack, tags, player);
            }
            if (!world.field_72995_K) {
                world.func_72926_e(2001, x, y, z, woodID + (meta << 12));
            }
        }
        return super.onBlockStartBreak(stack, x, y, z, player);
    }

    void breakTree(World world, int x, int y, int z, ItemStack stack, NBTTagCompound tags, int bID, int meta, EntityPlayer player) {
        for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
            for (int yPos = y - 1; yPos <= y + 1; ++yPos) {
                for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                    if (tags.func_74767_n("Broken") || world.func_72798_a(xPos, yPos, zPos) != bID || world.func_72805_g(xPos, yPos, zPos) % 4 != meta % 4) continue;
                    world.func_94571_i(x, y, z);
                    Block.field_71973_m[bID].func_71893_a(world, player, xPos, yPos, zPos, meta);
                    if (!player.field_71075_bZ.field_75098_d) {
                        this.func_77660_a(stack, world, bID, xPos, yPos, zPos, (EntityLiving)player);
                    }
                    this.breakTree(world, xPos, yPos, zPos, stack, tags, bID, meta, player);
                }
            }
        }
    }

    void destroyWood(World world, int x, int y, int z, ItemStack stack, NBTTagCompound tags, EntityPlayer player) {
        for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
            for (int yPos = y - 1; yPos <= y + 1; ++yPos) {
                for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                    int blockID;
                    Block block;
                    if (tags.func_74767_n("Broken") || (block = Block.field_71973_m[blockID = world.func_72798_a(xPos, yPos, zPos)]) == null || block.field_72018_cp != Material.field_76245_d) continue;
                    int meta = world.func_72805_g(xPos, yPos, zPos);
                    world.func_94571_i(x, y, z);
                    Block.field_71973_m[blockID].func_71893_a(world, player, xPos, yPos, zPos, meta);
                    if (player.field_71075_bZ.field_75098_d) continue;
                    this.func_77660_a(stack, world, blockID, xPos, yPos, zPos, (EntityLiving)player);
                }
            }
        }
    }

    @Override
    protected Item getHeadItem() {
        return TContent.lumberHead;
    }

    @Override
    protected Item getAccessoryItem() {
        return null;
    }

    @Override
    public String getIconSuffix(int partType) {
        switch (partType) {
            case 0: {
                return "_lumberaxe_head";
            }
            case 1: {
                return "_lumberaxe_head_broken";
            }
            case 2: {
                return "_lumberaxe_handle";
            }
            case 3: {
                return "_lumberaxe_accessory";
            }
        }
        return "";
    }

    @Override
    public String getEffectSuffix() {
        return "_lumber_effect";
    }

    @Override
    public String getDefaultFolder() {
        return "lumberaxe";
    }
}

