/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.client.gui;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import mods.tinker.tconstruct.blocks.logic.ToolStationLogic;
import mods.tinker.tconstruct.client.gui.GuiButtonTool;
import mods.tinker.tconstruct.client.gui.NewContainerGui;
import mods.tinker.tconstruct.inventory.ActiveContainer;
import mods.tinker.tconstruct.inventory.ToolStationContainer;
import mods.tinker.tconstruct.library.client.TConstructClientRegistry;
import mods.tinker.tconstruct.library.client.ToolGuiElement;
import mods.tinker.tconstruct.library.tools.ToolCore;
import mods.tinker.tconstruct.library.tools.Weapon;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ToolStationGui
extends NewContainerGui {
    ToolStationLogic logic;
    ToolStationContainer toolSlots;
    GuiTextField text;
    String toolName;
    int guiType;
    int[] slotX;
    int[] slotY;
    int[] iconX;
    int[] iconY;
    boolean active;
    String title;
    String body = "";

    public ToolStationGui(InventoryPlayer inventoryplayer, ToolStationLogic stationlogic, World world, int x, int y, int z) {
        super((ActiveContainer)stationlogic.getGuiContainer(inventoryplayer, world, x, y, z));
        this.logic = stationlogic;
        this.toolSlots = (ToolStationContainer)this.container;
        this.text = new GuiTextField(this.field_73886_k, this.xSize / 2 - 5, 8, 30, 12);
        this.text.func_73804_f(40);
        this.text.func_73786_a(false);
        this.text.func_73790_e(true);
        this.text.func_73805_d(false);
        this.text.func_73796_b(true);
        this.text.func_73794_g(0xFFFFFF);
        this.toolName = "";
        this.resetGui();
        Keyboard.enableRepeatEvents((boolean)true);
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            int gLeft = this.guiLeft + 68;
            int gTop = this.guiTop + 6;
            int gWidth = 102;
            int gHeight = 12;
            this.active = mouseX > gLeft && mouseX < gLeft + gWidth && mouseY > gTop && mouseY < gTop + gHeight;
        }
    }

    void resetGui() {
        this.text.func_73782_a("");
        this.guiType = 0;
        this.setSlotType(0);
        this.iconX = new int[]{0, 1, 2};
        this.iconY = new int[]{13, 13, 13};
        this.title = "\u00a7nRepair and Modification";
        this.body = "The main way to repair or change your tools. Place a tool and a material on the left to get started.";
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int cornerX = (this.field_73880_f - this.xSize) / 2;
        int cornerY = (this.field_73881_g - this.ySize) / 2;
        this.field_73887_h.clear();
        ToolGuiElement repair = (ToolGuiElement)TConstructClientRegistry.toolButtons.get(0);
        GuiButtonTool repairButton = new GuiButtonTool(0, cornerX - 110, cornerY, repair.buttonIconX, repair.buttonIconY, repair.texture);
        repairButton.field_73742_g = false;
        this.field_73887_h.add(repairButton);
        for (int iter = 1; iter < TConstructClientRegistry.toolButtons.size(); ++iter) {
            ToolGuiElement element = (ToolGuiElement)TConstructClientRegistry.toolButtons.get(iter);
            GuiButtonTool button = new GuiButtonTool(iter, cornerX - 110 + 22 * (iter % 5), cornerY + 22 * (iter / 5), element.buttonIconX, element.buttonIconY, element.texture);
            this.field_73887_h.add(button);
        }
    }

    protected void func_73875_a(GuiButton button) {
        ((GuiButton)this.field_73887_h.get((int)this.guiType)).field_73742_g = true;
        this.guiType = button.field_73741_f;
        button.field_73742_g = false;
        ToolGuiElement element = (ToolGuiElement)TConstructClientRegistry.toolButtons.get(this.guiType);
        this.setSlotType(element.slotType);
        this.iconX = element.iconsX;
        this.iconY = element.iconsY;
        this.title = "\u00a7n" + element.title;
        this.body = element.body;
    }

    void setSlotType(int type) {
        switch (type) {
            case 0: {
                this.slotX = new int[]{56, 38, 38};
                this.slotY = new int[]{37, 28, 46};
                break;
            }
            case 1: {
                this.slotX = new int[]{56, 56, 56};
                this.slotY = new int[]{19, 55, 37};
                break;
            }
            case 2: {
                this.slotX = new int[]{56, 56, 14};
                this.slotY = new int[]{28, 46, 37};
                break;
            }
            case 3: {
                this.slotX = new int[]{38, 47, 56};
                this.slotY = new int[]{28, 46, 28};
                break;
            }
            case 4: {
                this.slotX = new int[]{47, 47, 38, 56};
                this.slotY = new int[]{19, 55, 37, 37};
            }
        }
        this.toolSlots.resetSlots(this.slotX, this.slotY);
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.text.func_73780_a();
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"crafters.ToolStation"), 6, 8, 0);
        this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"container.inventory"), 8, this.ySize - 96 + 2, 0);
        this.field_73886_k.func_78276_b(this.toolName + "_", this.xSize / 2 - 18, 8, 0xFFFFFF);
        if (this.logic.isStackInSlot(0)) {
            this.drawToolStats();
        } else {
            this.drawToolInformation();
        }
    }

    void drawToolStats() {
        ItemStack stack = this.logic.func_70301_a(0);
        ToolCore tool = (ToolCore)stack.func_77973_b();
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        this.func_73732_a(this.field_73886_k, "\u00a7n" + tool.getToolName(), this.xSize + 63, 8, 0xFFFFFF);
        if (tool instanceof Weapon) {
            this.drawWeaponStats(stack, tool, tags);
        } else if (tool.getHeadType() == 3) {
            this.drawDualStats(stack, tool, tags);
        } else {
            this.drawHarvestStats(stack, tool, tags);
        }
    }

    void drawWeaponStats(ItemStack stack, ToolCore tool, NBTTagCompound tags) {
        String heart;
        int dur = tags.func_74762_e("Damage");
        int maxDur = tags.func_74762_e("TotalDurability");
        dur = maxDur - dur;
        this.field_73886_k.func_78276_b("Durability: " + dur + "/" + maxDur, this.xSize + 8, 24, 0xFFFFFF);
        int attack = (int)((float)tags.func_74762_e("Attack") * tool.getDamageModifier());
        String string = heart = attack == 2 ? " Heart" : " Hearts";
        if (attack % 2 == 0) {
            this.field_73886_k.func_78276_b("Attack: " + attack / 2 + heart, this.xSize + 8, 35, 0xFFFFFF);
        } else {
            this.field_73886_k.func_78276_b("Attack: " + (float)attack / 2.0f + heart, this.xSize + 8, 35, 0xFFFFFF);
        }
        this.field_73886_k.func_78276_b("Modifiers remaining: " + tags.func_74762_e("Modifiers"), this.xSize + 8, 57, 0xFFFFFF);
        if (tags.func_74764_b("Tooltip1")) {
            this.field_73886_k.func_78276_b("Modifiers:", this.xSize + 8, 68, 0xFFFFFF);
        }
        boolean displayToolTips = true;
        int tipNum = 0;
        while (displayToolTips) {
            String tooltip = "ModifierTip" + ++tipNum;
            if (tags.func_74764_b(tooltip)) {
                String tipName = tags.func_74779_i(tooltip);
                this.field_73886_k.func_78276_b("- " + tipName, this.xSize + 8, 68 + tipNum * 11, 0xFFFFFF);
                continue;
            }
            displayToolTips = false;
        }
    }

    void drawHarvestStats(ItemStack stack, ToolCore tool, NBTTagCompound tags) {
        String heart;
        int dur = tags.func_74762_e("Damage");
        int maxDur = tags.func_74762_e("TotalDurability");
        dur = maxDur - dur;
        this.field_73886_k.func_78276_b("Durability: " + dur + "/" + maxDur, this.xSize + 8, 24, 0xFFFFFF);
        int attack = tags.func_74762_e("Attack");
        String string = heart = attack == 2 ? " Heart" : " Hearts";
        if (attack % 2 == 0) {
            this.field_73886_k.func_78276_b("Attack: " + attack / 2 + heart, this.xSize + 8, 35, 0xFFFFFF);
        } else {
            this.field_73886_k.func_78276_b("Attack: " + (float)attack / 2.0f + heart, this.xSize + 8, 35, 0xFFFFFF);
        }
        float mineSpeed = (float)tags.func_74762_e("MiningSpeed") / 100.0f;
        this.field_73886_k.func_78276_b("Mining Speed: " + mineSpeed, this.xSize + 8, 46, 0xFFFFFF);
        this.field_73886_k.func_78276_b("Mining Level: " + this.getHarvestLevelName(tags.func_74762_e("HarvestLevel")), this.xSize + 8, 57, 0xFFFFFF);
        this.field_73886_k.func_78276_b("Modifiers remaining: " + tags.func_74762_e("Modifiers"), this.xSize + 8, 79, 0xFFFFFF);
        if (tags.func_74764_b("Tooltip1")) {
            this.field_73886_k.func_78276_b("Modifiers:", this.xSize + 8, 90, 0xFFFFFF);
        }
        boolean displayToolTips = true;
        int tipNum = 0;
        while (displayToolTips) {
            String tooltip = "ModifierTip" + ++tipNum;
            if (tags.func_74764_b(tooltip)) {
                String tipName = tags.func_74779_i(tooltip);
                this.field_73886_k.func_78276_b("- " + tipName, this.xSize + 8, 90 + tipNum * 11, 0xFFFFFF);
                continue;
            }
            displayToolTips = false;
        }
    }

    void drawDualStats(ItemStack stack, ToolCore tool, NBTTagCompound tags) {
        int dur = tags.func_74762_e("Damage");
        int maxDur = tags.func_74762_e("TotalDurability");
        dur = maxDur - dur;
        this.field_73886_k.func_78276_b("Durability: " + dur + "/" + maxDur, this.xSize + 8, 24, 0xFFFFFF);
        float mineSpeed = (float)tags.func_74762_e("MiningSpeed") / 100.0f;
        float mineSpeed2 = (float)tags.func_74762_e("MiningSpeed2") / 100.0f;
        this.field_73886_k.func_78276_b("Mining Speeds: ", this.xSize + 8, 35, 0xFFFFFF);
        this.field_73886_k.func_78276_b("- " + mineSpeed + ", " + mineSpeed2, this.xSize + 8, 46, 0xFFFFFF);
        this.field_73886_k.func_78276_b("Harvest Levels:", this.xSize + 8, 57, 0xFFFFFF);
        this.field_73886_k.func_78276_b("- " + this.getHarvestLevelName(tags.func_74762_e("HarvestLevel")), this.xSize + 8, 68, 0xFFFFFF);
        this.field_73886_k.func_78276_b("- " + this.getHarvestLevelName(tags.func_74762_e("HarvestLevel2")), this.xSize + 8, 79, 0xFFFFFF);
        this.field_73886_k.func_78276_b("Modifiers remaining: " + tags.func_74762_e("Modifiers"), this.xSize + 8, 90, 0xFFFFFF);
        if (tags.func_74764_b("Tooltip1")) {
            this.field_73886_k.func_78276_b("Modifiers:", this.xSize + 8, 101, 0xFFFFFF);
        }
        boolean displayToolTips = true;
        int tipNum = 0;
        while (displayToolTips) {
            String tooltip = "ModifierTip" + ++tipNum;
            if (tags.func_74764_b(tooltip)) {
                String tipName = tags.func_74779_i(tooltip);
                this.field_73886_k.func_78276_b("- " + tipName, this.xSize + 8, 101 + tipNum * 11, 0xFFFFFF);
                continue;
            }
            displayToolTips = false;
        }
    }

    void drawToolInformation() {
        this.func_73732_a(this.field_73886_k, this.title, this.xSize + 63, 8, 0xFFFFFF);
        this.field_73886_k.func_78279_b(this.body, this.xSize + 8, 24, 115, 0xFFFFFF);
    }

    String getHarvestLevelName(int num) {
        switch (num) {
            case 0: {
                return "Stone";
            }
            case 1: {
                return "Iron";
            }
            case 2: {
                return "Redstone";
            }
            case 3: {
                return "Obsidian";
            }
            case 4: {
                return "Cobalt";
            }
            case 5: {
                return "Manyullyn";
            }
        }
        return String.valueOf(num);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_98187_b("/mods/tinker/textures/gui/toolstation.png");
        int cornerX = (this.field_73880_f - this.xSize) / 2;
        int cornerY = (this.field_73881_g - this.ySize) / 2;
        this.func_73729_b(cornerX, cornerY, 0, 0, this.xSize, this.ySize);
        if (this.active) {
            this.func_73729_b(cornerX + 62, cornerY, 0, this.ySize, 112, 22);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_98187_b("/mods/tinker/textures/gui/icons.png");
        for (int i = 0; i < this.slotX.length; ++i) {
            this.func_73729_b(cornerX + this.slotX[i] - 4, cornerY + this.slotY[i] - 4, 140, 212, 28, 28);
            if (this.logic.isStackInSlot(i + 1)) continue;
            this.func_73729_b(cornerX + this.slotX[i], cornerY + this.slotY[i], 18 * this.iconX[i], 18 * this.iconY[i], 18, 18);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_98187_b("/mods/tinker/textures/gui/description.png");
        cornerX = (this.field_73880_f + this.xSize) / 2;
        cornerY = (this.field_73881_g - this.ySize) / 2;
        this.func_73729_b(cornerX, cornerY, 0, 0, 126, this.ySize + 30);
    }

    @Override
    protected void func_73869_a(char par1, int keyCode) {
        if (keyCode == 1 || !this.active && keyCode == this.field_73882_e.field_71474_y.field_74315_B.field_74512_d) {
            this.logic.setToolname("");
            this.updateServer("");
            Keyboard.enableRepeatEvents((boolean)false);
            this.field_73882_e.field_71439_g.func_71053_j();
        } else if (this.active) {
            this.text.func_73802_a(par1, keyCode);
            this.toolName = this.text.func_73781_b().trim();
            this.logic.setToolname(this.toolName);
            this.updateServer(this.toolName);
        }
    }

    void updateServer(String name) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(8);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeByte(1);
            outputStream.writeInt(this.logic.field_70331_k.field_73011_w.field_76574_g);
            outputStream.writeInt(this.logic.field_70329_l);
            outputStream.writeInt(this.logic.field_70330_m);
            outputStream.writeInt(this.logic.field_70327_n);
            outputStream.writeUTF(name);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = "TConstruct";
        packet.field_73629_c = bos.toByteArray();
        packet.field_73628_b = bos.size();
        PacketDispatcher.sendPacketToServer((Packet)packet);
    }
}

