/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.client.gui;

import mods.tinker.tconstruct.blocks.logic.SmelteryLogic;
import mods.tinker.tconstruct.client.gui.NewContainerGui;
import mods.tinker.tconstruct.inventory.ActiveContainer;
import mods.tinker.tconstruct.inventory.SmelteryContainer;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.Icon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class SmelteryGui
extends NewContainerGui {
    public SmelteryLogic logic;
    String username;
    boolean isScrolling = false;
    boolean wasClicking;
    float currentScroll = 0.0f;
    int slotPos = 0;
    int prevSlotPos = 0;

    public SmelteryGui(InventoryPlayer inventoryplayer, SmelteryLogic smeltery, World world, int x, int y, int z) {
        super((ActiveContainer)smeltery.getGuiContainer(inventoryplayer, world, x, y, z));
        this.logic = smeltery;
        this.username = inventoryplayer.field_70458_d.field_71092_bJ;
        this.xSize = 248;
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float par3) {
        super.func_73863_a(mouseX, mouseY, par3);
        this.updateScrollbar(mouseX, mouseY, par3);
    }

    protected void updateScrollbar(int mouseX, int mouseY, float par3) {
        if (this.logic.layers > 2) {
            boolean mouseDown = Mouse.isButtonDown((int)0);
            int lefto = this.guiLeft;
            int topo = this.guiTop;
            int xScroll = lefto + 67;
            int yScroll = topo + 8;
            int scrollWidth = xScroll + 14;
            int scrollHeight = yScroll + 144;
            if (!this.wasClicking && mouseDown && mouseX >= xScroll && mouseY >= yScroll && mouseX < scrollWidth && mouseY < scrollHeight) {
                this.isScrolling = true;
            }
            if (!mouseDown) {
                this.isScrolling = false;
            }
            if (this.wasClicking && !this.isScrolling && this.slotPos != this.prevSlotPos) {
                this.prevSlotPos = this.slotPos;
            }
            this.wasClicking = mouseDown;
            if (this.isScrolling) {
                int s;
                this.currentScroll = ((float)(mouseY - yScroll) - 7.5f) / ((float)(scrollHeight - yScroll) - 15.0f);
                if (this.currentScroll < 0.0f) {
                    this.currentScroll = 0.0f;
                }
                if (this.currentScroll > 1.0f) {
                    this.currentScroll = 1.0f;
                }
                if ((s = ((SmelteryContainer)this.container).scrollTo(this.currentScroll)) != -1) {
                    this.slotPos = s;
                }
            }
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"crafters.Smeltery"), 86, 5, 0x404040);
        this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"container.inventory"), 90, this.ySize - 96 + 2, 0x404040);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        int slotSize;
        int size;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_98187_b("/mods/tinker/textures/gui/smeltery.png");
        int cornerX = (this.field_73880_f - this.xSize) / 2 + 36;
        int cornerY = (this.field_73881_g - this.ySize) / 2;
        this.func_73729_b(cornerX + 46, cornerY, 0, 0, 176, this.ySize);
        if (this.logic.fuelGague > 0) {
            this.field_73882_e.field_71446_o.func_98187_b("/terrain.png");
            Icon lavaIcon = Block.field_71938_D.func_71858_a(0, 0);
            int fuel = this.logic.getScaledFuelGague(52);
            int count = 0;
            while (fuel > 0) {
                int size2 = fuel >= 16 ? 16 : fuel;
                fuel -= size2;
                this.func_94065_a(cornerX + 117, cornerY + 68 - size2 - 16 * count, lavaIcon, 12, size2);
                ++count;
            }
        }
        int base = 0;
        for (LiquidStack liquid : this.logic.moltenMetal) {
            Icon renderIndex;
            if (liquid.itemID < 4096) {
                Block liquidBlock = Block.field_71973_m[liquid.itemID];
                this.field_73882_e.field_71446_o.func_98187_b("/terrain.png");
                renderIndex = liquidBlock.func_71858_a(0, liquid.itemMeta);
            } else {
                Item liquidItem = Item.field_77698_e[liquid.itemID];
                this.field_73882_e.field_71446_o.func_98187_b("/gui/items.png");
                renderIndex = liquidItem.func_77617_a(liquid.itemMeta);
            }
            if (this.logic.getCapacity() <= 0) continue;
            int liquidSize = liquid.amount * 52 / this.logic.getCapacity();
            while (liquidSize > 0) {
                size = liquidSize >= 16 ? 16 : liquidSize;
                int basePos = 54;
                this.func_94065_a(cornerX + basePos, cornerY + 68 - size - base, renderIndex, 16, size);
                this.func_94065_a(cornerX + basePos + 16, cornerY + 68 - size - base, renderIndex, 16, size);
                this.func_94065_a(cornerX + basePos + 32, cornerY + 68 - size - base, renderIndex, 16, size);
                this.func_94065_a(cornerX + basePos + 48, cornerY + 68 - size - base, renderIndex, 4, size);
                liquidSize -= size;
                base += size;
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_98187_b("/mods/tinker/textures/gui/smeltery.png");
        this.func_73729_b(cornerX + 54, cornerY + 16, 176, 76, 52, 52);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_98187_b("/mods/tinker/textures/gui/smelteryside.png");
        if (this.logic.layers > 0) {
            if (this.logic.layers == 1) {
                this.func_73729_b(cornerX - 46, cornerY, 0, 0, 98, 43);
                this.func_73729_b(cornerX - 46, cornerY + 43, 0, 133, 98, 25);
            } else if (this.logic.layers == 2) {
                this.func_73729_b(cornerX - 46, cornerY, 0, 0, 98, 61);
                this.func_73729_b(cornerX - 46, cornerY + 61, 0, 97, 98, 61);
            } else {
                this.func_73729_b(cornerX - 46, cornerY, 0, 0, 98, this.ySize - 8);
            }
            this.func_73729_b(cornerX + 32, (int)((float)(cornerY + 8) + 127.0f * this.currentScroll), 98, 0, 12, 15);
        }
        if ((slotSize = this.logic.layers * 9) > 24) {
            slotSize = 24;
        }
        for (int iter = 0; iter < slotSize; ++iter) {
            int slotTemp = this.logic.getTempForSlot(iter + this.slotPos * 3) - 20;
            int maxTemp = this.logic.getMeltingPointForSlot(iter + this.slotPos * 3) - 20;
            if (slotTemp <= 0 || maxTemp <= 0) continue;
            size = 16 * slotTemp / maxTemp + 1;
            this.func_73729_b(cornerX - 38 + iter % 3 * 22, cornerY + 8 + iter / 3 * 18 + 16 - size, 98, 31 - size, 5, size);
        }
    }

    public void drawLiquidRect(int par1, int par2, Icon par3Icon, int par4, int par5) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + par5), (double)this.field_73735_i, (double)par3Icon.func_94209_e(), (double)par3Icon.func_94210_h());
        tessellator.func_78374_a((double)(par1 + par4), (double)(par2 + par5), (double)this.field_73735_i, (double)par3Icon.func_94212_f(), (double)par3Icon.func_94210_h());
        tessellator.func_78374_a((double)(par1 + par4), (double)(par2 + 0), (double)this.field_73735_i, (double)par3Icon.func_94212_f(), (double)par3Icon.func_94206_g());
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + 0), (double)this.field_73735_i, (double)par3Icon.func_94209_e(), (double)par3Icon.func_94206_g());
        tessellator.func_78381_a();
    }
}

