/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.blocks.logic;

import mods.tinker.tconstruct.blocks.logic.MultiServantLogic;
import mods.tinker.tconstruct.blocks.logic.SmelteryLogic;
import mods.tinker.tconstruct.library.util.IFacingLogic;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class SmelteryDrainLogic
extends MultiServantLogic
implements ITankContainer,
IFacingLogic {
    byte direction;

    @Override
    public boolean canUpdate() {
        return false;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (this.hasMaster && resource != null) {
            if (doFill) {
                SmelteryLogic smeltery = (SmelteryLogic)this.field_70331_k.func_72796_p(this.master.x, this.master.y, this.master.z);
                return smeltery.fill(resource, doFill);
            }
            return resource.amount;
        }
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(0, maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        if (this.hasValidMaster()) {
            SmelteryLogic smeltery = (SmelteryLogic)this.field_70331_k.func_72796_p(this.master.x, this.master.y, this.master.z);
            return smeltery.drain(maxDrain, doDrain);
        }
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        if (this.hasValidMaster()) {
            SmelteryLogic smeltery = (SmelteryLogic)this.field_70331_k.func_72796_p(this.master.x, this.master.y, this.master.z);
            return new ILiquidTank[]{smeltery};
        }
        return null;
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        if (this.hasValidMaster()) {
            return (SmelteryLogic)this.field_70331_k.func_72796_p(this.master.x, this.master.y, this.master.z);
        }
        return null;
    }

    @Override
    public byte getRenderDirection() {
        return this.direction;
    }

    @Override
    public ForgeDirection getForgeDirection() {
        return ForgeDirection.VALID_DIRECTIONS[this.direction];
    }

    @Override
    public void setDirection(float yaw, float pitch, EntityLiving player) {
        if (pitch > 45.0f) {
            this.direction = 1;
        } else if (pitch < -45.0f) {
            this.direction = 0;
        } else {
            int facing = MathHelper.func_76128_c((double)((double)(yaw / 360.0f) + 0.5)) & 3;
            switch (facing) {
                case 0: {
                    this.direction = (byte)2;
                    break;
                }
                case 1: {
                    this.direction = (byte)5;
                    break;
                }
                case 2: {
                    this.direction = (byte)3;
                    break;
                }
                case 3: {
                    this.direction = (byte)4;
                }
            }
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound tags) {
        super.func_70307_a(tags);
        this.direction = tags.func_74771_c("Direction");
    }

    @Override
    public void func_70310_b(NBTTagCompound tags) {
        super.func_70310_b(tags);
        tags.func_74774_a("Direction", this.direction);
    }

    @Override
    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70310_b(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }

    @Override
    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.func_70307_a(packet.field_73331_e);
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }
}

