/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.blocks.logic;

import mods.tinker.tconstruct.library.util.CoordTuple;
import mods.tinker.tconstruct.library.util.IMasterLogic;
import mods.tinker.tconstruct.library.util.IServantLogic;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;

public class MultiServantLogic
extends TileEntity
implements IServantLogic {
    boolean hasMaster;
    CoordTuple master;
    short masterID;
    byte masterMeat;

    public boolean canUpdate() {
        return false;
    }

    public boolean hasValidMaster() {
        if (!this.hasMaster) {
            return false;
        }
        if (this.field_70331_k.func_72798_a(this.master.x, this.master.y, this.master.z) == this.masterID && this.field_70331_k.func_72805_g(this.master.x, this.master.y, this.master.z) == this.masterMeat) {
            return true;
        }
        this.hasMaster = false;
        this.master = null;
        return false;
    }

    @Override
    public CoordTuple getMasterPosition() {
        return this.master;
    }

    public void overrideMaster(int x, int y, int z) {
        this.hasMaster = true;
        this.master = new CoordTuple(x, y, z);
        this.masterID = (short)this.field_70331_k.func_72798_a(x, y, z);
        this.masterMeat = (byte)this.field_70331_k.func_72805_g(x, y, z);
    }

    public void removeMaster() {
        this.hasMaster = false;
        this.master = null;
        this.masterID = 0;
        this.masterMeat = 0;
    }

    @Override
    public boolean verifyMaster(int x, int y, int z) {
        return this.master.equalCoords(x, y, z) && this.field_70331_k.func_72798_a(x, y, z) == this.masterID && this.field_70331_k.func_72805_g(x, y, z) == this.masterMeat;
    }

    @Override
    public boolean setMaster(int x, int y, int z) {
        if (!this.hasMaster || this.field_70331_k.func_72798_a(this.master.x, this.master.y, this.master.z) != this.masterID || this.field_70331_k.func_72805_g(this.master.x, this.master.y, this.master.z) != this.masterMeat) {
            this.overrideMaster(x, y, z);
            return true;
        }
        return false;
    }

    @Override
    public void notifyMasterOfChange() {
        if (this.hasValidMaster()) {
            IMasterLogic logic = (IMasterLogic)this.field_70331_k.func_72796_p(this.master.x, this.master.y, this.master.z);
            logic.notifyChange(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    public void readCustomNBT(NBTTagCompound tags) {
        this.hasMaster = tags.func_74767_n("HasMaster");
        if (this.hasMaster) {
            int xCenter = tags.func_74762_e("xCenter");
            int yCenter = tags.func_74762_e("yCenter");
            int zCenter = tags.func_74762_e("zCenter");
            this.master = new CoordTuple(xCenter, yCenter, zCenter);
            this.masterID = tags.func_74765_d("MasterID");
            this.masterMeat = tags.func_74771_c("masterMeat");
        }
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        tags.func_74757_a("HasMaster", this.hasMaster);
        if (this.hasMaster) {
            tags.func_74768_a("xCenter", this.master.x);
            tags.func_74768_a("yCenter", this.master.y);
            tags.func_74768_a("zCenter", this.master.z);
            tags.func_74777_a("MasterID", this.masterID);
            tags.func_74774_a("masterMeat", this.masterMeat);
        }
    }

    public void func_70307_a(NBTTagCompound tags) {
        super.func_70307_a(tags);
        this.readCustomNBT(tags);
    }

    public void func_70310_b(NBTTagCompound tags) {
        super.func_70310_b(tags);
        this.writeCustomNBT(tags);
    }

    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.readCustomNBT(packet.field_73331_e);
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }
}

