/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.blocks.logic;

import mods.tinker.tconstruct.TConstruct;
import mods.tinker.tconstruct.library.blocks.InventoryLogic;
import mods.tinker.tconstruct.library.crafting.CastingRecipe;
import mods.tinker.tconstruct.library.util.IPattern;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class CastingBasinLogic
extends InventoryLogic
implements ILiquidTank,
ITankContainer,
ISidedInventory {
    public LiquidStack liquid;
    int castingDelay = 0;
    int renderOffset = 0;
    int capacity = 0;
    boolean needsUpdate;
    boolean init = true;
    int tick;

    public CastingBasinLogic() {
        super(2);
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public String func_70303_b() {
        return null;
    }

    @Override
    protected String getDefaultName() {
        return null;
    }

    @Override
    public Container getGuiContainer(InventoryPlayer inventoryplayer, World world, int x, int y, int z) {
        return null;
    }

    public LiquidStack getLiquid() {
        return this.liquid;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int updateCapacity() {
        int ret = 144;
        ItemStack inv = this.inventory[0];
        ret = inv != null && inv.func_77973_b() instanceof IPattern ? (int)((double)ret * ((double)((IPattern)inv.func_77973_b()).getPatternCost(inv.func_77960_j()) * 0.5)) : TConstruct.basinCasting.getCastingAmount(this.liquid, inv);
        return ret;
    }

    public int updateCapacity(int capacity) {
        int ret = 144;
        ItemStack inv = this.inventory[0];
        ret = inv != null && inv.func_77973_b() instanceof IPattern ? (int)((double)ret * ((double)((IPattern)inv.func_77973_b()).getPatternCost(inv.func_77960_j()) * 0.5)) : capacity;
        return ret;
    }

    public int fill(LiquidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (this.liquid == null) {
            CastingRecipe recipe = TConstruct.basinCasting.getCastingRecipe(resource, this.inventory[0]);
            if (recipe == null) {
                return 0;
            }
            this.capacity = this.updateCapacity(recipe.castingMetal.amount);
            if (this.inventory[1] == null) {
                LiquidStack copyLiquid = resource.copy();
                if (copyLiquid.amount > this.capacity) {
                    copyLiquid.amount = this.capacity;
                }
                if (doFill) {
                    if (copyLiquid.amount == this.capacity) {
                        this.castingDelay = recipe.coolTime;
                    }
                    this.renderOffset = copyLiquid.amount;
                    this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                    this.liquid = copyLiquid;
                    this.needsUpdate = true;
                }
                return copyLiquid.amount;
            }
            return 0;
        }
        if (resource.isLiquidEqual(this.liquid)) {
            if (resource.amount + this.liquid.amount >= this.capacity) {
                int roomInTank = this.capacity - this.liquid.amount;
                if (doFill && roomInTank > 0) {
                    this.renderOffset = roomInTank;
                    this.castingDelay = TConstruct.basinCasting.getCastingDelay(this.liquid, this.inventory[0]);
                    this.liquid.amount = this.capacity;
                    this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                    this.needsUpdate = true;
                }
                return roomInTank;
            }
            if (doFill) {
                this.liquid.amount += resource.amount;
                this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                this.needsUpdate = true;
            }
            return resource.amount;
        }
        return 0;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.needsUpdate = true;
    }

    @Override
    public ItemStack func_70298_a(int slot, int quantity) {
        ItemStack stack = super.func_70298_a(slot, quantity);
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return stack;
    }

    public LiquidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    public int getTankPressure() {
        return 0;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return this.fill(resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this;
    }

    public int getLiquidAmount() {
        return this.liquid.amount - this.renderOffset;
    }

    public void func_70316_g() {
        if (this.castingDelay > 0) {
            --this.castingDelay;
            if (this.castingDelay == 0) {
                this.castLiquid();
            }
        }
        if (this.renderOffset > 0) {
            this.renderOffset -= 6;
            this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        ++this.tick;
        if (this.tick % 20 == 0) {
            this.tick = 0;
            if (this.needsUpdate) {
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
        }
    }

    public void castLiquid() {
        CastingRecipe recipe = TConstruct.basinCasting.getCastingRecipe(this.liquid, this.inventory[0]);
        if (recipe != null) {
            this.inventory[1] = recipe.getResult();
            if (recipe.consumeCast) {
                this.inventory[0] = null;
            }
            this.liquid = null;
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound tags) {
        super.func_70307_a(tags);
        this.readCustomNBT(tags);
    }

    public void readCustomNBT(NBTTagCompound tags) {
        this.liquid = tags.func_74767_n("hasLiquid") ? new LiquidStack(tags.func_74762_e("itemID"), tags.func_74762_e("amount"), tags.func_74762_e("itemMeta")) : null;
        this.capacity = tags.func_74767_n("Initialized") ? tags.func_74762_e("Capacity") : this.updateCapacity();
    }

    @Override
    public void func_70310_b(NBTTagCompound tags) {
        super.func_70310_b(tags);
        this.writeCustomNBT(tags);
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        tags.func_74757_a("hasLiquid", this.liquid != null);
        if (this.liquid != null) {
            tags.func_74768_a("itemID", this.liquid.itemID);
            tags.func_74768_a("amount", this.liquid.amount);
            tags.func_74768_a("itemMeta", this.liquid.itemMeta);
        }
        tags.func_74757_a("Initialized", this.init);
        tags.func_74768_a("Capacity", this.capacity);
    }

    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70310_b(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.func_70307_a(packet.field_73331_e);
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public int[] func_94128_d(int side) {
        if (side == 0) {
            return new int[]{1};
        }
        return new int[]{0};
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return true;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }
}

