/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.blocks;

import java.util.List;
import mods.tinker.tconstruct.blocks.logic.LavaTankLogic;
import mods.tinker.tconstruct.client.block.TankRender;
import mods.tinker.tconstruct.library.TConstructRegistry;
import mods.tinker.tconstruct.library.util.IServantLogic;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;

public class LavaTankBlock
extends BlockContainer {
    public Icon[] icons;

    public LavaTankBlock(int id) {
        super(id, Material.field_76246_e);
        this.func_71848_c(12.0f);
        this.func_71849_a(TConstructRegistry.blockTab);
        this.func_71864_b("TConstruct.LavaTank");
        this.func_71884_a(Block.field_71974_j);
    }

    public String[] getTextureNames() {
        String[] textureNames = new String[]{"lavatank_side", "lavatank_top", "searedgague_top", "searedgague_side", "searedgague_bottom", "searedwindow_top", "searedwindow_side", "searedwindow_bottom"};
        return textureNames;
    }

    public void func_94332_a(IconRegister iconRegister) {
        String[] textureNames = this.getTextureNames();
        this.icons = new Icon[textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("tinker:" + textureNames[i]);
        }
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public boolean func_71877_c(IBlockAccess world, int x, int y, int z, int side) {
        int bID = world.func_72798_a(x, y, z);
        return bID == this.field_71990_ca ? false : super.func_71877_c(world, x, y, z, side);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity logic = world.func_72796_p(x, y, z);
        if (logic != null && logic instanceof LavaTankLogic) {
            return ((LavaTankLogic)logic).getBrightness();
        }
        return 0;
    }

    public int func_71857_b() {
        return TankRender.tankModelID;
    }

    public Icon func_71858_a(int side, int meta) {
        if (meta == 0) {
            if (side == 0 || side == 1) {
                return this.icons[1];
            }
            return this.icons[0];
        }
        return this.icons[meta * 3 + this.getTextureIndex(side) - 1];
    }

    public int getTextureIndex(int side) {
        if (side == 0) {
            return 2;
        }
        if (side == 1) {
            return 0;
        }
        return 1;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new LavaTankLogic();
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float clickX, float clickY, float clickZ) {
        ItemStack heldItem = player.field_71071_by.func_70448_g();
        if (heldItem != null) {
            LiquidStack liquid = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)player.func_71045_bC());
            LavaTankLogic logic = (LavaTankLogic)world.func_72796_p(x, y, z);
            if (liquid != null) {
                int amount = logic.fill(0, liquid, false);
                if (amount == liquid.amount) {
                    logic.fill(ForgeDirection.UNKNOWN, liquid, true);
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, LavaTankBlock.consumeItem(heldItem));
                    }
                    return true;
                }
                return true;
            }
            if (LiquidContainerRegistry.isBucket((ItemStack)heldItem)) {
                ILiquidTank[] tanks = logic.getTanks(ForgeDirection.UNKNOWN);
                LiquidStack fillLiquid = tanks[0].getLiquid();
                ItemStack fillStack = LiquidContainerRegistry.fillLiquidContainer((LiquidStack)fillLiquid, (ItemStack)heldItem);
                if (fillStack != null) {
                    logic.drain(ForgeDirection.UNKNOWN, LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)fillStack).amount, true);
                    if (!player.field_71075_bZ.field_75098_d) {
                        if (heldItem.field_77994_a == 1) {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, fillStack);
                        } else {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, LavaTankBlock.consumeItem(heldItem));
                            if (!player.field_71071_by.func_70441_a(fillStack)) {
                                player.func_71021_b(fillStack);
                            }
                        }
                    }
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    public static ItemStack consumeItem(ItemStack stack) {
        if (stack.field_77994_a == 1) {
            if (stack.func_77973_b().func_77634_r()) {
                return stack.func_77973_b().getContainerItemStack(stack);
            }
            return null;
        }
        stack.func_77979_a(1);
        return stack;
    }

    public TileEntity func_72274_a(World world) {
        return this.createTileEntity(world, 0);
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (int iter = 0; iter < 3; ++iter) {
            list.add(new ItemStack(id, 1, iter));
        }
    }

    public int func_71899_b(int meta) {
        return meta;
    }

    public void func_71863_a(World world, int x, int y, int z, int nBlockID) {
        TileEntity logic = world.func_72796_p(x, y, z);
        if (logic instanceof IServantLogic) {
            ((IServantLogic)logic).notifyMasterOfChange();
        }
    }
}

